/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.ksp.common;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.FileLocation;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.Location;
import com.google.devtools.ksp.symbol.NonExistLocation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.ksp.common.BaseSymbolProcessorKt;
import ru.tinkoff.kora.ksp.common.KoraSymbolProcessingEnv;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lru/tinkoff/kora/ksp/common/BaseSymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "kspLogger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "getKspLogger", "()Lcom/google/devtools/ksp/processing/KSPLogger;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "processRound", "symbol-processor-common"})
public abstract class BaseSymbolProcessor
implements SymbolProcessor {
    @NotNull
    private final KSPLogger kspLogger;

    public BaseSymbolProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.kspLogger = !BaseSymbolProcessorKt.access$getDebug$p() ? environment.getLogger() : (KSPLogger)new KSPLogger(environment){
            final /* synthetic */ SymbolProcessorEnvironment $environment;
            {
                this.$environment = $environment;
            }

            public void error(@NotNull String message, @Nullable KSNode symbol) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$environment.getLogger().error(message, symbol);
                this.writeMessage("error", message, symbol);
            }

            public void exception(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$environment.getLogger().exception(e);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                sw.flush();
                String string = sw.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.writeMessage("exception", string, null);
            }

            public void info(@NotNull String message, @Nullable KSNode symbol) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.writeMessage("info", message, symbol);
            }

            public void logging(@NotNull String message, @Nullable KSNode symbol) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.writeMessage("logging", message, symbol);
            }

            public void warn(@NotNull String message, @Nullable KSNode symbol) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.writeMessage("warn", message, symbol);
            }

            private final void writeMessage(String level, String message, KSNode symbol) {
                String string;
                Location location;
                KSNode kSNode = symbol;
                Object object = location = kSNode != null ? kSNode.getLocation() : null;
                if (location instanceof FileLocation) {
                    string = "[" + level + "] " + ((FileLocation)location).getFilePath() + ":" + ((FileLocation)location).getLineNumber() + "\n" + message;
                } else if (location instanceof NonExistLocation ? true : location == null) {
                    string = "[" + level + "] " + message;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String msg = string;
                BaseSymbolProcessorKt.access$logToFile(msg);
            }
        };
    }

    @NotNull
    public final KSPLogger getKspLogger() {
        return this.kspLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        try {
            KoraSymbolProcessingEnv.INSTANCE.setLogger(this.kspLogger);
            List<KSAnnotated> list = this.processRound(resolver);
            return list;
        }
        finally {
            KoraSymbolProcessingEnv.INSTANCE.resetLogger();
        }
    }

    @NotNull
    public abstract List<KSAnnotated> processRound(@NotNull Resolver var1);
}

