/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.ksp.common;

import com.google.devtools.ksp.symbol.KSType;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.ksp.common.CommonClassNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lru/tinkoff/kora/ksp/common/MappingData;", "", "mapper", "Lcom/google/devtools/ksp/symbol/KSType;", "tags", "", "", "(Lcom/google/devtools/ksp/symbol/KSType;Ljava/util/Set;)V", "getMapper", "()Lcom/google/devtools/ksp/symbol/KSType;", "getTags", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isGeneric", "parameterized", "Lcom/squareup/kotlinpoet/TypeName;", "tn", "toString", "toTagAnnotation", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "symbol-processor-common"})
public final class MappingData {
    @Nullable
    private final KSType mapper;
    @NotNull
    private final Set<String> tags;

    public MappingData(@Nullable KSType mapper, @NotNull Set<String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.mapper = mapper;
        this.tags = tags;
    }

    @Nullable
    public final KSType getMapper() {
        return this.mapper;
    }

    @NotNull
    public final Set<String> getTags() {
        return this.tags;
    }

    @Nullable
    public final AnnotationSpec toTagAnnotation() {
        if (this.tags.isEmpty()) {
            return null;
        }
        CodeBlock.Builder tags = CodeBlock.Companion.builder();
        Iterator iterator = CollectionsKt.withIndex(this.tags.iterator());
        while (iterator.hasNext()) {
            IndexedValue indexedValue = (IndexedValue)iterator.next();
            int i = indexedValue.component1();
            String tag = (String)indexedValue.component2();
            if (i > 0) {
                tags.add(", ", new Object[0]);
            }
            Object[] objectArray = new Object[]{tag};
            tags.add("%L::class", objectArray);
        }
        return AnnotationSpec.Companion.builder(CommonClassNames.INSTANCE.getTag()).addMember(tags.build()).build();
    }

    public final boolean isGeneric() {
        return this.mapper != null && !((Collection)this.mapper.getDeclaration().getTypeParameters()).isEmpty();
    }

    @NotNull
    public final TypeName parameterized(@NotNull TypeName tn) {
        Intrinsics.checkNotNullParameter((Object)tn, (String)"tn");
        boolean bl = this.isGeneric();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        KSType kSType = this.mapper;
        Intrinsics.checkNotNull((Object)kSType);
        TypeName[] typeNameArray = new TypeName[]{tn};
        return (TypeName)ParameterizedTypeName.Companion.get(KsTypesKt.toClassName((KSType)kSType), typeNameArray);
    }

    @Nullable
    public final KSType component1() {
        return this.mapper;
    }

    @NotNull
    public final Set<String> component2() {
        return this.tags;
    }

    @NotNull
    public final MappingData copy(@Nullable KSType mapper, @NotNull Set<String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new MappingData(mapper, tags);
    }

    public static /* synthetic */ MappingData copy$default(MappingData mappingData, KSType kSType, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            kSType = mappingData.mapper;
        }
        if ((n & 2) != 0) {
            set = mappingData.tags;
        }
        return mappingData.copy(kSType, set);
    }

    @NotNull
    public String toString() {
        return "MappingData(mapper=" + this.mapper + ", tags=" + this.tags + ")";
    }

    public int hashCode() {
        int result = this.mapper == null ? 0 : this.mapper.hashCode();
        result = result * 31 + ((Object)this.tags).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappingData)) {
            return false;
        }
        MappingData mappingData = (MappingData)other;
        if (!Intrinsics.areEqual((Object)this.mapper, (Object)mappingData.mapper)) {
            return false;
        }
        return Intrinsics.areEqual(this.tags, mappingData.tags);
    }
}

