/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;

final class DefaultKoraAppGraph
implements KoraAppGraph {
    private static final Class<?>[] TAG_ANY = new Class[]{Tag.Any.class};
    private final ApplicationGraphDraw graphDraw;
    private final Graph graph;

    DefaultKoraAppGraph(ApplicationGraphDraw graphDraw, Graph graph) {
        this.graphDraw = graphDraw;
        this.graph = graph;
    }

    @Override
    @Nullable
    public Object getFirst(@Nonnull Type type) {
        Node node = this.graphDraw.findNodeByType(type);
        return node == null ? null : this.graph.get(node);
    }

    @Override
    @Nullable
    public <T> T getFirst(@Nonnull Class<T> type) {
        return type.cast(this.getFirst((Type)type));
    }

    @Override
    @Nullable
    public Object getFirst(@Nonnull Type type, Class<?> ... tags) {
        Set nodes = GraphUtils.findNodeByType(this.graphDraw, new GraphCandidate(type, tags));
        return nodes.stream().map(arg_0 -> ((Graph)this.graph).get(arg_0)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public <T> T getFirst(@Nonnull Class<T> type, Class<?> ... tags) {
        return (T)this.getFirst((Type)type, tags);
    }

    @Override
    @Nonnull
    public List<Object> getAll(@Nonnull Type type) {
        return this.getAll(type, TAG_ANY);
    }

    @Override
    @Nonnull
    public List<Object> getAll(@Nonnull Type type, Class<?> ... tags) {
        Set nodes = GraphUtils.findNodeByType(this.graphDraw, new GraphCandidate(type, tags));
        return nodes.stream().map(arg_0 -> ((Graph)this.graph).get(arg_0)).toList();
    }

    @Override
    @Nonnull
    public <T> List<T> getAll(@Nonnull Class<T> type) {
        return this.getAll(type, TAG_ANY);
    }

    @Override
    @Nonnull
    public <T> List<T> getAll(@Nonnull Class<T> type, Class<?> ... tags) {
        return this.getAll((Type)type, tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultKoraAppGraph)) {
            return false;
        }
        DefaultKoraAppGraph that = (DefaultKoraAppGraph)o;
        return Objects.equals(this.graph, that.graph);
    }

    public int hashCode() {
        return Objects.hash(this.graph);
    }
}

