/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.MockKKt;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.mockito.Mockito;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.test.extension.junit5.DefaultKoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.MockUtils;

record GraphReplacementWithDeps<T>(Function<KoraAppGraph, ? extends T> function, GraphCandidate candidate) implements GraphModification
{
    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToReplace = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToReplace.isEmpty()) {
            throw new ExtensionConfigurationException("Can't find Nodes to Replace: " + String.valueOf(this.candidate()));
        }
        Iterator<Node<?>> iterator = nodesToReplace.iterator();
        while (iterator.hasNext()) {
            Node<?> node;
            Node<?> casted = node = iterator.next();
            graphDraw.replaceNodeKeepDependencies(casted, g -> {
                Object replacement = this.function.apply(new DefaultKoraAppGraph(graphDraw, g));
                Optional<Class<?>> wrappedType = GraphUtils.findWrappedType(node.type());
                if (wrappedType.isPresent() && wrappedType.get().isInstance(replacement)) {
                    Optional<Class<?>> mockClass = GraphUtils.tryCastType(node.type());
                    if (mockClass.isPresent() && !mockClass.get().equals(Wrapped.class) && MockUtils.haveAnyMockEngine()) {
                        if (MockUtils.isMockitoAvailable()) {
                            Wrapped mockedWrapper = (Wrapped)Mockito.mock(mockClass.get());
                            Mockito.when((Object)mockedWrapper.value()).thenReturn(replacement);
                            return mockedWrapper;
                        }
                        KClass kotlinTC = JvmClassMappingKt.getKotlinClass(mockClass.get());
                        Wrapped mockedWrapper = (Wrapped)MockKKt.mockkClass((KClass)kotlinTC, null, (boolean)true, (KClass[])new KClass[0], (boolean)true, v -> null);
                        MockKKt.every(mockKMatcherScope -> mockedWrapper.value()).returns(replacement);
                        return mockedWrapper;
                    }
                    return () -> replacement;
                }
                return replacement;
            });
        }
    }
}

