/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.junit.TestFinishedEvent;
import org.mockito.internal.junit.UniversalTestListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockitoLogger;
import org.mockito.quality.Strictness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.test.extension.junit5.GraphMockitoContext;

final class MockitoUnusedStubbingReporter {
    private final GraphMockitoContext mockitoContext;
    private final Strictness strictness;

    public MockitoUnusedStubbingReporter(GraphMockitoContext mockitoContext, Strictness strictness) {
        this.mockitoContext = mockitoContext;
        this.strictness = strictness;
    }

    public void reportUnused(final ExtensionContext context) {
        if (this.mockitoContext.isEmpty()) {
            return;
        }
        UniversalTestListener listener = new UniversalTestListener(this.strictness, (MockitoLogger)new Slf4jReporterLogger());
        for (Map.Entry<Object, MockSettingsImpl<?>> mockEntry : this.mockitoContext.mocksMap().entrySet()) {
            listener.onMockCreated(mockEntry.getKey(), (MockCreationSettings)mockEntry.getValue());
        }
        for (Object spy : this.mockitoContext.spySet()) {
            listener.onMockCreated(spy, (MockCreationSettings)Mockito.withSettings());
        }
        listener.testFinished(new TestFinishedEvent(){

            public Throwable getFailure() {
                return context.getExecutionException().orElse(null);
            }

            public String getTestName() {
                return context.getRequiredTestInstance().getClass().getCanonicalName();
            }
        });
    }

    private static class Slf4jReporterLogger
    implements MockitoLogger {
        private static final Logger logger = LoggerFactory.getLogger(MockitoUnusedStubbingReporter.class);

        private Slf4jReporterLogger() {
        }

        public void log(Object o) {
            logger.warn(String.valueOf(o));
        }

        public void warn(Object what) {
            logger.warn(String.valueOf(what));
        }
    }
}

