/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;
import ru.tinkoff.kora.validation.annotation.processor.ValidatorGenerator;

public final class ValidAnnotationProcessor
extends AbstractKoraProcessor {
    private ValidatorGenerator generator;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ValidMeta.VALID_TYPE.canonicalName());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = new ValidatorGenerator(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<TypeElement> validatedElements = this.getValidatedTypeElements(this.processingEnv, roundEnv);
        for (TypeElement validatedElement : validatedElements) {
            try {
                this.generator.generateFor(validatedElement);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
        }
        return false;
    }

    private List<TypeElement> getValidatedTypeElements(ProcessingEnvironment processEnv, RoundEnvironment roundEnv) {
        TypeElement annotation = processEnv.getElementUtils().getTypeElement(ValidMeta.VALID_TYPE.canonicalName());
        return roundEnv.getElementsAnnotatedWith(annotation).stream().filter(a -> a instanceof TypeElement).map(element -> {
            if (element.getKind() == ElementKind.ENUM) {
                throw new ProcessingErrorException("Validation can't be generated for: " + element.getKind(), element);
            }
            if (element.getKind() == ElementKind.INTERFACE && !element.getModifiers().contains((Object)Modifier.SEALED)) {
                throw new ProcessingErrorException("Validation can't be generated for: " + element.getKind(), element);
            }
            return (TypeElement)element;
        }).toList();
    }

    record ValidatorSpec(ValidMeta meta, TypeSpec spec, List<ParameterSpec> parameterSpecs) {
    }
}

