/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;

public record ValidMeta(Type source, Validator validator, TypeElement sourceElement, List<Field> fields) {
    public static final ClassName VALID_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common.annotation", (String)"Valid", (String[])new String[0]);
    public static final ClassName VALIDATED_BY_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common.annotation", (String)"ValidatedBy", (String[])new String[0]);
    public static final ClassName CONTEXT_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common", (String)"ValidationContext", (String[])new String[0]);
    public static final ClassName VALIDATOR_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common", (String)"Validator", (String[])new String[0]);
    public static final ClassName VIOLATION_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common", (String)"Violation", (String[])new String[0]);
    public static final ClassName EXCEPTION_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common", (String)"ViolationException", (String[])new String[0]);

    public ValidMeta(Type source, TypeElement sourceElement, List<Field> fields) {
        this(source, new Validator(Type.ofName(VALIDATOR_TYPE.canonicalName(), List.of(source)), new Type(source.packageName, NameUtils.generatedType((Element)sourceElement, (ClassName)VALIDATOR_TYPE), List.of(source))), sourceElement, fields);
    }

    public record Type(String packageName, String simpleName, List<Type> generic) {
        public static Type ofType(TypeMirror type) {
            if (type instanceof DeclaredType) {
                return Type.ofType((DeclaredType)type);
            }
            return Type.ofName(type.toString());
        }

        public static Type ofType(DeclaredType type) {
            List<Type> generics = type.getTypeArguments().stream().map(Type::ofType).toList();
            return Type.ofName(type.asElement().toString(), generics);
        }

        public static Type ofClass(Class<?> clazz) {
            return Type.ofClass(clazz, Collections.emptyList());
        }

        public static Type ofClass(Class<?> clazz, List<Type> generic) {
            return new Type(clazz.getPackageName(), clazz.getSimpleName(), generic);
        }

        public static Type ofName(String canonicalName) {
            return Type.ofName(canonicalName, Collections.emptyList());
        }

        public static Type ofName(String canonicalName, List<Type> generic) {
            return new Type(canonicalName.substring(0, canonicalName.lastIndexOf(46)), canonicalName.substring(canonicalName.lastIndexOf(46) + 1), generic);
        }

        public String canonicalName() {
            return this.packageName + "." + this.simpleName;
        }

        public TypeMirror asMirror(ProcessingEnvironment env) {
            if (this.generic.isEmpty()) {
                return env.getTypeUtils().getDeclaredType(env.getElementUtils().getTypeElement(this.canonicalName()), new TypeMirror[0]);
            }
            TypeMirror[] generics = (TypeMirror[])this.generic().stream().map(g -> g.asMirror(env)).toArray(TypeMirror[]::new);
            return env.getTypeUtils().getDeclaredType(env.getElementUtils().getTypeElement(this.canonicalName()), generics);
        }

        public TypeName asPoetType(ProcessingEnvironment env) {
            return this.generic.isEmpty() ? TypeName.get((TypeMirror)this.asMirror(env)) : ParameterizedTypeName.get((TypeMirror)this.asMirror(env));
        }

        @Override
        public String toString() {
            if (this.generic().isEmpty()) {
                return this.canonicalName();
            }
            String generics = this.generic().stream().map(Type::toString).collect(Collectors.joining(", ", "<", ">"));
            return this.canonicalName() + generics;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Type)) {
                return false;
            }
            Type type = (Type)o;
            return Objects.equals(this.packageName, type.packageName) && Objects.equals(this.simpleName, type.simpleName) && Objects.equals(this.generic, type.generic);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.packageName, this.simpleName, this.generic);
        }
    }

    public record Validator(Type contract, Type implementation) {
    }

    public record Constraint(Type annotation, Factory factory) {

        public record Factory(Type type, Map<String, Object> parameters) {
            public Type validator() {
                return Type.ofName(VALIDATOR_TYPE.canonicalName(), this.type.generic());
            }
        }
    }

    public record Field(Type type, String name, boolean isRecord, boolean isNullable, boolean isPrimitive, List<Constraint> constraint, List<Validated> validates) {
        public boolean isNotNull() {
            return !this.isNullable;
        }

        public String accessor() {
            return this.isRecord ? this.name + "()" : "get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + "()";
        }
    }

    public record Validated(Type target) {
        public Type validator() {
            return Type.ofName(VALIDATOR_TYPE.canonicalName(), List.of(this.target));
        }
    }
}

