/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;

public final class ValidUtils {
    public static List<ValidMeta.Constraint> getValidatedByConstraints(ProcessingEnvironment env, TypeMirror parameterType, List<? extends AnnotationMirror> annotations) {
        List innerAnnotationConstraints = annotations.stream().flatMap(annotation -> annotation.getAnnotationType().asElement().getAnnotationMirrors().stream().filter(validatedBy -> validatedBy.getAnnotationType().toString().equals(ValidMeta.VALIDATED_BY_TYPE.canonicalName())).flatMap(validatedBy -> validatedBy.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")).map(en -> ((AnnotationValue)en.getValue()).getValue()).filter(ft -> ft instanceof DeclaredType).map(factoryType -> {
            DeclaredType factoryRawType = (DeclaredType)factoryType;
            Map parametersWithDefaults = env.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)annotation).entrySet().stream().collect(Collectors.toMap(ae -> ((ExecutableElement)ae.getKey()).getSimpleName().toString(), ae -> ValidUtils.castParameterValue((AnnotationValue)ae.getValue()), (v1, v2) -> v2, LinkedHashMap::new));
            LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
            for (Element element : annotation.getAnnotationType().asElement().getEnclosedElements()) {
                if (!(element instanceof ExecutableElement)) continue;
                ExecutableElement ep = (ExecutableElement)element;
                String parameterName = ep.getSimpleName().toString();
                Object parameterValue = parametersWithDefaults.get(parameterName);
                parameters.put(parameterName, parameterValue);
            }
            if (parameters.size() > 0) {
                factoryRawType.asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(e -> e.getSimpleName().contentEquals("create")).filter(e -> e.getParameters().size() == parameters.size()).findFirst().orElseThrow(() -> new ProcessingErrorException("Expected " + factoryRawType.asElement().getSimpleName() + "#create() method with " + parameters.size() + " parameters, but was didn't find such", factoryRawType.asElement(), annotation));
            }
            TypeMirror fieldType = ValidUtils.getBoxType(parameterType, env);
            DeclaredType declaredType = ((DeclaredType)factoryRawType.asElement().asType()).getTypeArguments().isEmpty() ? env.getTypeUtils().getDeclaredType((TypeElement)factoryRawType.asElement(), new TypeMirror[0]) : env.getTypeUtils().getDeclaredType((TypeElement)factoryRawType.asElement(), fieldType);
            ValidMeta.Type factoryGenericType = ValidMeta.Type.ofType(declaredType);
            ValidMeta.Constraint.Factory constraintFactory = new ValidMeta.Constraint.Factory(factoryGenericType, parameters);
            ValidMeta.Type annotationType = ValidMeta.Type.ofType(annotation.getAnnotationType().asElement().asType());
            return new ValidMeta.Constraint(annotationType, constraintFactory);
        }))).toList();
        List selfAnnotationConstraints = annotations.stream().filter(validatedBy -> validatedBy.getAnnotationType().toString().equals(ValidMeta.VALIDATED_BY_TYPE.canonicalName())).flatMap(validatedBy -> validatedBy.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")).map(en -> ((AnnotationValue)en.getValue()).getValue()).filter(ft -> ft instanceof DeclaredType).map(factoryType -> {
            DeclaredType factoryRawType = (DeclaredType)factoryType;
            TypeMirror fieldType = ValidUtils.getBoxType(parameterType, env);
            DeclaredType factoryDeclaredType = ((DeclaredType)factoryRawType.asElement().asType()).getTypeArguments().isEmpty() ? env.getTypeUtils().getDeclaredType((TypeElement)factoryRawType.asElement(), new TypeMirror[0]) : env.getTypeUtils().getDeclaredType((TypeElement)factoryRawType.asElement(), fieldType);
            ValidMeta.Type factoryGenericType = ValidMeta.Type.ofType(factoryDeclaredType);
            ValidMeta.Constraint.Factory constraintFactory = new ValidMeta.Constraint.Factory(factoryGenericType, Collections.emptyMap());
            ValidMeta.Type annotationType = ValidMeta.Type.ofType(validatedBy.getAnnotationType().asElement().asType());
            return new ValidMeta.Constraint(annotationType, constraintFactory);
        })).toList();
        ArrayList<ValidMeta.Constraint> constraints = new ArrayList<ValidMeta.Constraint>(innerAnnotationConstraints);
        constraints.addAll(selfAnnotationConstraints);
        constraints.sort(Comparator.comparing(c -> c.factory().type().toString()));
        return constraints;
    }

    private static Object castParameterValue(AnnotationValue value) {
        if (value.getValue() instanceof String) {
            return value.toString();
        }
        if (value.getValue() instanceof Number) {
            return value.toString();
        }
        Object object = value.getValue();
        if (object instanceof VariableElement) {
            VariableElement ve = (VariableElement)object;
            return ve.asType().toString() + "." + value.getValue();
        }
        if (value.getValue() instanceof List) {
            return ((List)((Object)value)).stream().map(v -> v instanceof AnnotationValue ? ValidUtils.castParameterValue((AnnotationValue)v) : v.toString()).toList();
        }
        return value.toString();
    }

    public static TypeMirror getBoxType(TypeMirror mirror, ProcessingEnvironment env) {
        TypeMirror typeMirror;
        if (mirror instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)mirror;
            typeMirror = env.getTypeUtils().boxedClass(primitive).asType();
        } else {
            typeMirror = mirror;
        }
        return typeMirror;
    }
}

