/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.SealedTypeUtils;
import ru.tinkoff.kora.validation.annotation.processor.ValidAnnotationProcessor;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;
import ru.tinkoff.kora.validation.annotation.processor.ValidUtils;

public class ValidatorGenerator {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final ProcessingEnvironment processingEnv;

    public ValidatorGenerator(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.processingEnv = env;
    }

    public void generateFor(TypeElement validatedElement) {
        if (validatedElement.getKind().isInterface()) {
            this.generateForSealed(validatedElement);
            return;
        }
        ValidMeta validMeta = this.getValidatorMetas(validatedElement);
        ValidAnnotationProcessor.ValidatorSpec validator = this.getValidatorSpecs(validMeta);
        PackageElement packageElement = this.elements.getPackageOf(validator.meta().sourceElement());
        JavaFile javaFile = JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)validator.spec()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateForSealed(TypeElement validatedElement) {
        assert (validatedElement.getModifiers().contains((Object)Modifier.SEALED));
        TypeName validatedTypeName = TypeName.get((TypeMirror)validatedElement.asType());
        ParameterizedTypeName validatorType = ParameterizedTypeName.get((ClassName)ValidMeta.VALIDATOR_TYPE, (TypeName[])new TypeName[]{validatedTypeName});
        TypeSpec.Builder validatorSpecBuilder = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)validatedElement, (ClassName)ValidMeta.VALIDATOR_TYPE)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)validatorType).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", "$S", new Object[]{this.getClass().getCanonicalName()}).build());
        for (TypeParameterElement typeParameterElement : validatedElement.getTypeParameters()) {
            validatorSpecBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"validate").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.list, (TypeName[])new TypeName[]{ValidMeta.VIOLATION_TYPE})).addParameter(ParameterSpec.builder((TypeName)validatedTypeName, (String)"value", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build()).addParameter((TypeName)ValidMeta.CONTEXT_TYPE, "context", new Modifier[0]);
        List subclasses = SealedTypeUtils.collectFinalPermittedSubtypes((Types)this.types, (Elements)this.elements, (TypeElement)validatedElement);
        for (int i = 0; i < subclasses.size(); ++i) {
            TypeElement permittedSubclass = (TypeElement)subclasses.get(i);
            String name = "_validator" + (i + 1);
            TypeName subclassTypeName = TypeName.get((TypeMirror)permittedSubclass.asType());
            ParameterizedTypeName fieldValidator = ParameterizedTypeName.get((ClassName)ValidMeta.VALIDATOR_TYPE, (TypeName[])new TypeName[]{subclassTypeName});
            validatorSpecBuilder.addField((TypeName)fieldValidator, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addParameter((TypeName)fieldValidator, name, new Modifier[0]);
            constructor.addStatement("this.$N = $N", new Object[]{name, name});
            if (i > 0) {
                builder.nextControlFlow("else if (value instanceof $T casted)", new Object[]{subclassTypeName});
            } else {
                builder.beginControlFlow("if (value instanceof $T casted)", new Object[]{subclassTypeName});
            }
            builder.addStatement("return $N.validate(casted, context)", new Object[]{name});
        }
        validatorSpecBuilder.addMethod(builder.endControlFlow().addStatement("throw new $T()", new Object[]{IllegalStateException.class}).build());
        validatorSpecBuilder.addMethod(constructor.build());
        JavaFile javaFile = JavaFile.builder((String)this.elements.getPackageOf(validatedElement).getQualifiedName().toString(), (TypeSpec)validatorSpecBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ValidAnnotationProcessor.ValidatorSpec getValidatorSpecs(ValidMeta meta) {
        ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
        TypeName typeName = meta.validator().contract().asPoetType(this.processingEnv);
        TypeSpec.Builder validatorSpecBuilder = TypeSpec.classBuilder((String)meta.validator().implementation().simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(typeName).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", "$S", new Object[]{this.getClass().getCanonicalName()}).build());
        HashMap<ValidMeta.Constraint.Factory, String> constraintToFieldName = new HashMap<ValidMeta.Constraint.Factory, String>();
        HashMap<ValidMeta.Validated, String> validatedToFieldName = new HashMap<ValidMeta.Validated, String>();
        ArrayList<CodeBlock> fieldConstraintBuilder = new ArrayList<CodeBlock>();
        for (int i = 1; i <= meta.fields().size(); ++i) {
            boolean canBeNullable;
            Iterator field = meta.fields().get(i - 1);
            String string = "_context" + i;
            boolean bl = canBeNullable = ((ValidMeta.Field)((Object)field)).isNotNull() && !((ValidMeta.Field)((Object)field)).isPrimitive();
            if (canBeNullable) {
                fieldConstraintBuilder.add(CodeBlock.of((String)"if(value.$L == null) {\n    var $L = context.addPath($S);\n    if(context.isFailFast()) {\n        return List.of($L.violates(\"Should be not null, but was null\"));\n    } else {\n        _violations.add($L.violates(\"Should be not null, but was null\"));\n    }\n}", (Object[])new Object[]{((ValidMeta.Field)((Object)field)).accessor(), string, ((ValidMeta.Field)((Object)field)).name(), string, string}));
            }
            if (!((ValidMeta.Field)((Object)field)).constraint().isEmpty() || !((ValidMeta.Field)((Object)field)).validates().isEmpty()) {
                String suffix;
                int j;
                if (canBeNullable) {
                    fieldConstraintBuilder.add(CodeBlock.of((String)"else {$>", (Object[])new Object[]{((ValidMeta.Field)((Object)field)).accessor()}));
                } else if (!((ValidMeta.Field)((Object)field)).isPrimitive()) {
                    fieldConstraintBuilder.add(CodeBlock.of((String)"if(value.$L != null) {$>", (Object[])new Object[]{((ValidMeta.Field)((Object)field)).accessor()}));
                }
                fieldConstraintBuilder.add(CodeBlock.of((String)"var $L = context.addPath($S);", (Object[])new Object[]{string, ((ValidMeta.Field)((Object)field)).name()}));
                for (j = 1; j <= ((ValidMeta.Field)((Object)field)).constraint().size(); ++j) {
                    ValidMeta.Constraint constraint = ((ValidMeta.Field)((Object)field)).constraint().get(j - 1);
                    suffix = i + "_" + j;
                    String constraintField = constraintToFieldName.computeIfAbsent(constraint.factory(), k -> "_constraint" + suffix);
                    String constraintResultField = "_constraintResult_" + suffix;
                    fieldConstraintBuilder.add(CodeBlock.of((String)"var $N = $L.validate(value.$L, $L);\nif(!$N.isEmpty()) {\n    if(context.isFailFast()) {\n        return $N;\n    } else {\n        _violations.addAll($N);\n    }\n}", (Object[])new Object[]{constraintResultField, constraintField, ((ValidMeta.Field)((Object)field)).accessor(), string, constraintResultField, constraintResultField, constraintResultField}));
                }
                for (j = 1; j <= ((ValidMeta.Field)((Object)field)).validates().size(); ++j) {
                    ValidMeta.Validated validated = ((ValidMeta.Field)((Object)field)).validates().get(j - 1);
                    suffix = i + "_" + j;
                    String validatorField = validatedToFieldName.computeIfAbsent(validated, k -> "_validator" + suffix);
                    String validatorResultField = "_validatorResult_" + suffix;
                    fieldConstraintBuilder.add(CodeBlock.of((String)"var $N = $L.validate(value.$L, $L);\nif(!$N.isEmpty()) {\n    if(context.isFailFast()) {\n        return $N;\n    } else {\n        _violations.addAll($N);\n    }\n}", (Object[])new Object[]{validatorResultField, validatorField, ((ValidMeta.Field)((Object)field)).accessor(), string, validatorResultField, validatorResultField, validatorResultField}));
                }
                if (!((ValidMeta.Field)((Object)field)).isPrimitive()) {
                    fieldConstraintBuilder.add(CodeBlock.of((String)"$<}", (Object[])new Object[0]));
                }
            }
            fieldConstraintBuilder.add(CodeBlock.of((String)"", (Object[])new Object[0]));
        }
        MethodSpec.Builder constructorSpecBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Map.Entry entry : constraintToFieldName.entrySet()) {
            ValidMeta.Constraint.Factory factory = (ValidMeta.Constraint.Factory)entry.getKey();
            String fieldName = (String)entry.getValue();
            String createParameters = factory.parameters().values().stream().map(Object::toString).collect(Collectors.joining(", "));
            validatorSpecBuilder.addField(FieldSpec.builder((TypeName)factory.validator().asPoetType(this.processingEnv), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)factory.type().asPoetType(this.processingEnv), (String)fieldName, (Modifier[])new Modifier[0]).build();
            parameterSpecs.add(parameterSpec);
            constructorSpecBuilder.addParameter(parameterSpec).addStatement("this.$L = $L.create($L)", new Object[]{fieldName, fieldName, createParameters});
        }
        for (Map.Entry entry : validatedToFieldName.entrySet()) {
            String fieldName = (String)entry.getValue();
            TypeName fieldType = ((ValidMeta.Validated)entry.getKey()).validator().asPoetType(this.processingEnv);
            validatorSpecBuilder.addField(FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[0]).build();
            parameterSpecs.add(parameterSpec);
            constructorSpecBuilder.addParameter(parameterSpec).addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
        }
        MethodSpec.Builder validateMethodSpecBuilder = MethodSpec.methodBuilder((String)"validate").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ValidMeta.Type.ofClass(List.class, List.of(ValidMeta.Type.ofName(ValidMeta.VIOLATION_TYPE.canonicalName()))).asPoetType(this.processingEnv)).addParameter(ParameterSpec.builder((TypeName)meta.source().asPoetType(this.processingEnv), (String)"value", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ValidMeta.Type.ofName(ValidMeta.CONTEXT_TYPE.canonicalName()).asPoetType(this.processingEnv), (String)"context", (Modifier[])new Modifier[0]).build()).addCode(CodeBlock.join(List.of(CodeBlock.of((String)"if(value == null) {\n    return $T.of(context.violates(\"$L input value should be not null, but was null\"));\n}\n\nfinal $T<Violation> _violations = new $T<>();", (Object[])new Object[]{List.class, meta.source().simpleName(), List.class, ArrayList.class}), CodeBlock.join(fieldConstraintBuilder, (String)"\n"), CodeBlock.of((String)"return _violations;", (Object[])new Object[0])), (String)"\n\n"));
        TypeSpec typeSpec = validatorSpecBuilder.addMethod(constructorSpecBuilder.build()).addMethod(validateMethodSpecBuilder.build()).build();
        return new ValidAnnotationProcessor.ValidatorSpec(meta, typeSpec, parameterSpecs);
    }

    private ValidMeta getValidatorMetas(TypeElement element) {
        List<VariableElement> elementFields = ValidatorGenerator.getFields(element);
        ArrayList<ValidMeta.Field> fields = new ArrayList<ValidMeta.Field>();
        for (VariableElement fieldElement : elementFields) {
            List<ValidMeta.Constraint> constraints = ValidatorGenerator.getValidatedByConstraints(this.processingEnv, fieldElement);
            List<ValidMeta.Validated> validateds = ValidatorGenerator.getValidated(fieldElement);
            boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)fieldElement);
            if (isNullable && constraints.isEmpty() && validateds.isEmpty()) continue;
            boolean isPrimitive = fieldElement.asType() instanceof PrimitiveType;
            boolean isRecord = element.getKind() == ElementKind.RECORD;
            TypeMirror fieldType = ValidUtils.getBoxType(fieldElement.asType(), this.processingEnv);
            ValidMeta.Field fieldMeta = new ValidMeta.Field(ValidMeta.Type.ofType(fieldType), fieldElement.getSimpleName().toString(), isRecord, isNullable, isPrimitive, constraints, validateds);
            fields.add(fieldMeta);
        }
        return new ValidMeta(ValidMeta.Type.ofType(element.asType()), element, fields);
    }

    private static List<ValidMeta.Constraint> getValidatedByConstraints(ProcessingEnvironment env, VariableElement field) {
        if (field.asType().getKind() == TypeKind.ERROR) {
            throw new ProcessingErrorException("Type is error in this round", (Element)field);
        }
        return ValidUtils.getValidatedByConstraints(env, field.asType(), field.getAnnotationMirrors());
    }

    private static List<VariableElement> getFields(TypeElement element) {
        return element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> e instanceof VariableElement).map(e -> (VariableElement)e).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).toList();
    }

    private static List<ValidMeta.Validated> getValidated(VariableElement field) {
        if (field.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals(ValidMeta.VALID_TYPE.canonicalName()))) {
            return List.of(new ValidMeta.Validated(ValidMeta.Type.ofType(field.asType())));
        }
        return Collections.emptyList();
    }
}

