/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;
import ru.tinkoff.kora.validation.annotation.processor.ValidUtils;

public class ValidateMethodKoraAspect
implements KoraAspect {
    private static final ClassName VALIDATE_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common.annotation", (String)"Validate", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public ValidateMethodKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(VALIDATE_TYPE.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        boolean isMono = MethodUtils.isMono((ExecutableElement)method);
        boolean isFlux = MethodUtils.isFlux((ExecutableElement)method);
        boolean isFuture = MethodUtils.isFuture((ExecutableElement)method);
        TypeMirror returnType = isMono || isFlux || isFuture ? (TypeMirror)MethodUtils.getGenericType((TypeMirror)method.getReturnType()).orElseThrow() : method.getReturnType();
        Optional<CodeBlock> validationReturnCode = this.buildValidationReturnCode(method, returnType, aspectContext);
        Optional<CodeBlock> validationArgumentCode = this.buildValidationArgumentCode(method, aspectContext);
        if (validationReturnCode.isEmpty() && validationArgumentCode.isEmpty()) {
            return KoraAspect.ApplyResult.Noop.INSTANCE;
        }
        if (validationReturnCode.isPresent()) {
            if (MethodUtils.isVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@Validate for Return Value can't be applied for types assignable from " + Void.class, (Element)method);
            }
            if ((isMono || isFlux || isFuture) && MethodUtils.getGenericType((TypeMirror)method.getReturnType()).filter(CommonUtils::isVoid).isPresent()) {
                throw new ProcessingErrorException("@Validate for Return Value can't be applied for types assignable from " + Void.class, (Element)method);
            }
        }
        CodeBlock body = isMono ? this.buildBodyMono(method, superCall, CommonClassNames.mono, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : (isFlux ? this.buildBodyFlux(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : (isFuture ? this.buildBodyFuture(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : this.buildBodySync(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null))));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private Optional<CodeBlock> buildValidationReturnCode(ExecutableElement method, TypeMirror returnType, KoraAspect.AspectContext aspectContext) {
        int i;
        List validates;
        boolean isMono = MethodUtils.isMono((ExecutableElement)method);
        boolean isFlux = MethodUtils.isFlux((ExecutableElement)method);
        boolean isFuture = MethodUtils.isFuture((ExecutableElement)method);
        List<ValidMeta.Constraint> constraints = ValidUtils.getValidatedByConstraints(this.env, returnType, method.getAnnotationMirrors());
        List<Object> list = validates = method.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals(ValidMeta.VALID_TYPE.canonicalName())) ? List.of(new ValidMeta.Validated(ValidMeta.Type.ofType(returnType))) : Collections.emptyList();
        if (constraints.isEmpty() && validates.isEmpty()) {
            return Optional.empty();
        }
        boolean isNullable = isFuture ? MethodUtils.getGenericType((TypeMirror)method.getReturnType()).map(CommonUtils::isNullable).orElseGet(() -> CommonUtils.isNullable((AnnotatedConstruct)method)) : CommonUtils.isNullable((AnnotatedConstruct)method);
        boolean isPrimitive = returnType instanceof PrimitiveType;
        CodeBlock.Builder builder = CodeBlock.builder();
        if (isNullable && !isPrimitive && !isMono && !isFlux) {
            builder.beginControlFlow("if(_result != null) ", new Object[0]);
        }
        boolean isFailFast = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(VALIDATE_TYPE.canonicalName())).flatMap(a -> this.env.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)a).entrySet().stream().filter(e -> "failFast".equals(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(e -> Boolean.parseBoolean(((AnnotationValue)e.getValue()).getValue().toString()))).findFirst().orElse(false);
        builder.addStatement("var _returnValueContext = $T.builder().failFast($L).build()", new Object[]{ValidMeta.CONTEXT_TYPE, isFailFast});
        if (!isFailFast) {
            builder.addStatement("var _returnValueViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidMeta.VIOLATION_TYPE});
        }
        for (i = 1; i <= constraints.size(); ++i) {
            ValidMeta.Constraint constraint = constraints.get(i - 1);
            String constraintFactory = aspectContext.fieldFactory().constructorParam(constraint.factory().type().asMirror(this.env), List.of());
            TypeMirror constraintType = constraint.factory().validator().asMirror(this.env);
            CodeBlock createExec = CodeBlock.builder().add("$N.create", new Object[]{constraintFactory}).add((CodeBlock)constraint.factory().parameters().values().stream().map(fp -> CodeBlock.of((String)"$L", (Object[])new Object[]{fp})).collect(CodeBlock.joining((String)", ", (String)"(", (String)")"))).build();
            String constraintField = aspectContext.fieldFactory().constructorInitialized(constraintType, createExec);
            String constraintResultField = "_returnConstraintResult_" + i;
            builder.addStatement("var $N = $N.validate(_result, _returnValueContext)", new Object[]{constraintResultField, constraintField});
            if (isFailFast) {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField});
                if (MethodUtils.isFuture((ExecutableElement)method)) {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, constraintResultField});
                } else if (MethodUtils.isMono((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidMeta.EXCEPTION_TYPE, constraintResultField});
                    builder.addStatement("return", new Object[0]);
                } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidMeta.EXCEPTION_TYPE, constraintResultField});
                    builder.addStatement("return", new Object[0]);
                } else {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, constraintResultField});
                }
                builder.endControlFlow();
                continue;
            }
            builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField}).addStatement("_returnValueViolations.addAll($N)", new Object[]{constraintResultField}).endControlFlow();
        }
        for (i = 1; i <= validates.size(); ++i) {
            ValidMeta.Validated validated = (ValidMeta.Validated)validates.get(i - 1);
            TypeMirror validatorType = validated.validator().asMirror(this.env);
            String validatorField = aspectContext.fieldFactory().constructorParam(validatorType, List.of());
            String validatedResultField = "_returnValidatorResult_" + i;
            builder.addStatement("var $N = $N.validate(_result, _returnValueContext)", new Object[]{validatedResultField, validatorField});
            if (isFailFast) {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatedResultField});
                if (MethodUtils.isFuture((ExecutableElement)method)) {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, validatedResultField});
                } else if (MethodUtils.isMono((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidMeta.EXCEPTION_TYPE, validatedResultField});
                    builder.addStatement("return", new Object[0]);
                } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidMeta.EXCEPTION_TYPE, validatedResultField});
                    builder.addStatement("return", new Object[0]);
                } else {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, validatedResultField});
                }
                builder.endControlFlow();
                continue;
            }
            builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatedResultField}).addStatement("_returnValueViolations.addAll($N)", new Object[]{validatedResultField}).endControlFlow();
        }
        if (!isFailFast) {
            builder.beginControlFlow("if (!_returnValueViolations.isEmpty())", new Object[0]);
            if (MethodUtils.isFuture((ExecutableElement)method)) {
                builder.addStatement("throw new $T(_returnValueViolations)", new Object[]{ValidMeta.EXCEPTION_TYPE});
            } else if (MethodUtils.isMono((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnValueViolations))", new Object[]{ValidMeta.EXCEPTION_TYPE});
                builder.addStatement("return", new Object[0]);
            } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnValueViolations))", new Object[]{ValidMeta.EXCEPTION_TYPE});
                builder.addStatement("return", new Object[0]);
            } else {
                builder.addStatement("throw new $T(_returnValueViolations)", new Object[]{ValidMeta.EXCEPTION_TYPE});
            }
            builder.endControlFlow();
        }
        if (isNullable && !isPrimitive && !isMono && !isFlux) {
            builder.endControlFlow();
        }
        return Optional.of(builder.build());
    }

    private Optional<CodeBlock> buildValidationArgumentCode(ExecutableElement method, KoraAspect.AspectContext aspectContext) {
        boolean isAnyParameterValidated = method.getParameters().stream().anyMatch(this::isParameterValidatable);
        if (!isAnyParameterValidated) {
            return Optional.empty();
        }
        boolean isFailFast = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(VALIDATE_TYPE.canonicalName())).flatMap(a -> this.env.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)a).entrySet().stream().filter(e -> "failFast".equals(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(e -> Boolean.parseBoolean(((AnnotationValue)e.getValue()).getValue().toString()))).findFirst().orElse(false);
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("var _argumentsContext = $T.builder().failFast($L).build()", new Object[]{ValidMeta.CONTEXT_TYPE, isFailFast});
        if (!isFailFast) {
            builder.addStatement("var _argumentsViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidMeta.VIOLATION_TYPE});
        }
        for (VariableElement variableElement : method.getParameters()) {
            int i;
            boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)variableElement);
            boolean isPrimitive = variableElement.asType() instanceof PrimitiveType;
            if (!this.isParameterValidatable(variableElement)) continue;
            List<ValidMeta.Constraint> constraints = ValidUtils.getValidatedByConstraints(this.env, variableElement.asType(), variableElement.getAnnotationMirrors());
            List<ValidMeta.Validated> validates = this.getValidForArguments(variableElement);
            if (isNullable && !isPrimitive) {
                builder.beginControlFlow("if($N != null)", new Object[]{variableElement.getSimpleName()});
            }
            String argumentsContext = "_argumentContext_" + variableElement;
            builder.addStatement("var $N = _argumentsContext.addPath($S)", new Object[]{argumentsContext, variableElement.getSimpleName()});
            for (i = 1; i <= constraints.size(); ++i) {
                ValidMeta.Constraint constraint = constraints.get(i - 1);
                String constraintFactory = aspectContext.fieldFactory().constructorParam(constraint.factory().type().asMirror(this.env), List.of());
                TypeMirror constraintType = constraint.factory().validator().asMirror(this.env);
                CodeBlock createExec = CodeBlock.builder().add("$N.create", new Object[]{constraintFactory}).add((CodeBlock)constraint.factory().parameters().values().stream().map(fp -> CodeBlock.of((String)"$L", (Object[])new Object[]{fp})).collect(CodeBlock.joining((String)", ", (String)"(", (String)")"))).build();
                String constraintField = aspectContext.fieldFactory().constructorInitialized(constraintType, createExec);
                String constraintResultField = "_argumentConstraintResult_" + variableElement + "_" + i;
                builder.addStatement("var $N = $N.validate($N, $N)", new Object[]{constraintResultField, constraintField, variableElement.getSimpleName(), argumentsContext});
                if (isFailFast) {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField});
                    if (MethodUtils.isFuture((ExecutableElement)method)) {
                        builder.addStatement("$T.failedFuture(new $T($N))", new Object[]{CompletableFuture.class, ValidMeta.EXCEPTION_TYPE, constraintResultField});
                    } else {
                        builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, constraintResultField});
                    }
                    builder.endControlFlow();
                    continue;
                }
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField}).addStatement("_argumentsViolations.addAll($N)", new Object[]{constraintResultField}).endControlFlow();
            }
            for (i = 1; i <= validates.size(); ++i) {
                ValidMeta.Validated validated = validates.get(i - 1);
                TypeMirror validatorType = validated.validator().asMirror(this.env);
                String validatorField = aspectContext.fieldFactory().constructorParam(validatorType, List.of());
                String validatorResultField = "_argumentValidatorResult_" + variableElement + "_" + i;
                builder.addStatement("var $N = $N.validate($N, $N)", new Object[]{validatorResultField, validatorField, variableElement.getSimpleName(), argumentsContext});
                if (isFailFast) {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatorResultField});
                    if (MethodUtils.isFuture((ExecutableElement)method)) {
                        builder.addStatement("return $T.failedFuture(new $T($N))", new Object[]{CompletableFuture.class, ValidMeta.EXCEPTION_TYPE, validatorResultField});
                    } else {
                        builder.addStatement("throw new $T($N)", new Object[]{ValidMeta.EXCEPTION_TYPE, validatorResultField});
                    }
                    builder.endControlFlow();
                    continue;
                }
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatorResultField}).addStatement("_argumentsViolations.addAll($N)", new Object[]{validatorResultField}).endControlFlow();
            }
            if (!isNullable || isPrimitive) continue;
            builder.endControlFlow();
        }
        if (!isFailFast) {
            builder.beginControlFlow("if (!_argumentsViolations.isEmpty())", new Object[0]);
            if (MethodUtils.isFuture((ExecutableElement)method)) {
                builder.addStatement("return $T.failedFuture(new $T(_argumentsViolations))", new Object[]{CompletableFuture.class, ValidMeta.EXCEPTION_TYPE});
            } else {
                builder.addStatement("throw new $T(_argumentsViolations)", new Object[]{ValidMeta.EXCEPTION_TYPE});
            }
            builder.endControlFlow();
        }
        return Optional.of(builder.build());
    }

    private boolean isParameterValidatable(VariableElement parameter) {
        for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType.toString().equals(ValidMeta.VALID_TYPE.canonicalName())) {
                return true;
            }
            for (AnnotationMirror annotationMirror2 : annotationType.asElement().getAnnotationMirrors()) {
                if (!annotationMirror2.getAnnotationType().toString().equals(ValidMeta.VALIDATED_BY_TYPE.canonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    private List<ValidMeta.Validated> getValidForArguments(VariableElement parameter) {
        if (parameter.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals(ValidMeta.VALID_TYPE.canonicalName()))) {
            return List.of(new ValidMeta.Validated(ValidMeta.Type.ofType(parameter.asType())));
        }
        return Collections.emptyList();
    }

    private CodeBlock buildBodySync(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            if (validationArgumentCode != null) {
                builder.add(validationArgumentCode);
            }
            return builder.add("$L;\n", new Object[]{superMethod.toString()}).build();
        }
        if (validationArgumentCode != null) {
            builder.add(validationArgumentCode).add("\n", new Object[0]);
        }
        builder.add("var _result = $L;\n", new Object[]{superMethod.toString()});
        if (validationReturnCode != null) {
            builder.add(validationReturnCode);
        }
        return builder.add("return _result;", new Object[0]).build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (validationArgumentCode != null) {
            builder.add(validationArgumentCode).add("\n", new Object[0]);
        }
        if (validationReturnCode != null) {
            builder.beginControlFlow("return $L.thenApply(_result -> ", new Object[]{superMethod.toString()});
            builder.add(validationReturnCode);
            builder.addStatement("return _result", new Object[0]);
            builder.endControlFlow(")", new Object[0]);
        } else {
            builder.addStatement("return $L", new Object[]{superMethod.toString()});
        }
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, String superCall, ClassName reactorName, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (validationArgumentCode != null) {
            builder.beginControlFlow("return $T.defer(() -> ", new Object[]{reactorName});
            builder.add(validationArgumentCode);
        }
        if (validationReturnCode != null) {
            builder.add("return $L.handle((_result, _sink) -> {\n", new Object[]{superMethod.toString()});
            builder.indent().indent().indent().indent().add(validationReturnCode).add("_sink.next(_result);", new Object[0]).unindent().unindent().unindent().unindent().add("\n\n});\n", new Object[0]);
        } else {
            builder.addStatement("return $L", new Object[]{superMethod.toString()});
        }
        if (validationArgumentCode != null) {
            builder.endControlFlow(")", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        return this.buildBodyMono(method, superCall, CommonClassNames.flux, validationReturnCode, validationArgumentCode);
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }
}

