/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;
import ru.tinkoff.kora.validation.annotation.processor.ValidTypes;
import ru.tinkoff.kora.validation.annotation.processor.ValidatorGenerator;

public final class ValidAnnotationProcessor
extends AbstractKoraProcessor {
    private ValidatorGenerator generator;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(ValidTypes.VALID_TYPE);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = new ValidatorGenerator(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        List validatedElements = annotatedElements.getOrDefault(ValidTypes.VALID_TYPE, List.of());
        for (AbstractKoraProcessor.AnnotatedElement annotated : validatedElements) {
            Element element = annotated.element();
            if (element.getKind() == ElementKind.ENUM) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Validation can't be generated for enum", element);
                continue;
            }
            if (element.getKind() == ElementKind.INTERFACE && !element.getModifiers().contains((Object)Modifier.SEALED)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Validation can't be generated for non sealed interface", element);
                continue;
            }
            if (!(element instanceof TypeElement)) continue;
            TypeElement validatedElement = (TypeElement)element;
            try {
                this.generator.generateFor(validatedElement);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
        }
    }

    record ValidatorSpec(ValidMeta meta, TypeSpec spec, List<ParameterSpec> parameterSpecs) {
    }
}

