/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.validation.annotation.processor.ValidTypes;

public record ValidMeta(Type source, TypeElement sourceElement, List<Field> fields) {
    public ValidMeta(TypeElement sourceElement, List<Field> fields) {
        this(Type.ofElement(sourceElement, sourceElement.asType()), sourceElement, fields);
    }

    public String validatorImplementationName() {
        return NameUtils.generatedType((Element)this.sourceElement, (ClassName)ValidTypes.VALIDATOR_TYPE);
    }

    public Type validator(ProcessingEnvironment env) {
        TypeElement validatorElement = env.getElementUtils().getTypeElement(ValidTypes.VALIDATOR_TYPE.canonicalName());
        DeclaredType declaredType = env.getTypeUtils().getDeclaredType(validatorElement, this.source.typeMirror);
        return new Type(declaredType.asElement(), declaredType);
    }

    public record Type(Element element, TypeMirror typeMirror) {
        public static Type ofElement(Element element, TypeMirror typeMirror) {
            return new Type(element, typeMirror);
        }

        public TypeName asPoetType() {
            return TypeName.get((TypeMirror)this.typeMirror);
        }

        @Override
        public String toString() {
            return this.typeMirror.toString();
        }
    }

    public record Constraint(Type annotation, Factory factory) {

        public record Factory(Type type, Type validator, Map<String, Object> parameters) {
        }
    }

    public record Field(Type type, String name, boolean isRecord, boolean isNullable, boolean isNotNull, boolean isJsonNullable, boolean isPrimitive, List<Constraint> constraint, List<Validated> validates) {
        public String accessor() {
            return this.isRecord ? this.name + "()" : "get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + "()";
        }

        public String valueAccessor() {
            if (this.isJsonNullable) {
                return this.accessor() + ".value()";
            }
            return this.accessor();
        }
    }

    public record Validated(Type target) {
        public Type validator(ProcessingEnvironment env) {
            TypeElement validatorElement = env.getElementUtils().getTypeElement(ValidTypes.VALIDATOR_TYPE.canonicalName());
            DeclaredType declaredType = env.getTypeUtils().getDeclaredType(validatorElement, this.target.typeMirror);
            return new Type(declaredType.asElement(), declaredType);
        }
    }
}

