/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.validation.annotation.processor.ValidMeta;
import ru.tinkoff.kora.validation.annotation.processor.ValidTypes;
import ru.tinkoff.kora.validation.annotation.processor.ValidUtils;

public class ValidateMethodKoraAspect
implements KoraAspect {
    private static final ClassName VALIDATE_TYPE = ClassName.get((String)"ru.tinkoff.kora.validation.common.annotation", (String)"Validate", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public ValidateMethodKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(VALIDATE_TYPE.canonicalName());
    }

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(VALIDATE_TYPE);
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        boolean isMono = MethodUtils.isMono((ExecutableElement)method);
        boolean isFlux = MethodUtils.isFlux((ExecutableElement)method);
        boolean isFuture = MethodUtils.isFuture((ExecutableElement)method);
        TypeMirror returnType = isMono || isFlux || isFuture ? (TypeMirror)MethodUtils.getGenericType((TypeMirror)method.getReturnType()).orElseThrow() : method.getReturnType();
        Optional<CodeBlock> validationReturnCode = this.buildValidationReturnCode(method, returnType, aspectContext);
        Optional<CodeBlock> validationArgumentCode = this.buildValidationArgumentCode(method, aspectContext);
        if (validationReturnCode.isEmpty() && validationArgumentCode.isEmpty()) {
            return KoraAspect.ApplyResult.Noop.INSTANCE;
        }
        if (validationReturnCode.isPresent()) {
            if (MethodUtils.isVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@Validate for Return Value can't be applied for types assignable from " + String.valueOf(Void.class), (Element)method);
            }
            if ((isMono || isFlux || isFuture) && MethodUtils.getGenericType((TypeMirror)method.getReturnType()).filter(CommonUtils::isVoid).isPresent()) {
                throw new ProcessingErrorException("@Validate for Return Value can't be applied for types assignable from " + String.valueOf(Void.class), (Element)method);
            }
        }
        CodeBlock body = isMono ? this.buildBodyMono(method, superCall, CommonClassNames.mono, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : (isFlux ? this.buildBodyFlux(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : (isFuture ? this.buildBodyFuture(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null)) : this.buildBodySync(method, superCall, validationReturnCode.orElse(null), validationArgumentCode.orElse(null))));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    /*
     * Unable to fully structure code
     */
    private Optional<CodeBlock> buildValidationReturnCode(ExecutableElement method, TypeMirror returnType, KoraAspect.AspectContext aspectContext) {
        if (CommonUtils.isVoid((TypeMirror)returnType)) {
            return Optional.empty();
        }
        isMono = MethodUtils.isMono((ExecutableElement)method);
        isFlux = MethodUtils.isFlux((ExecutableElement)method);
        isFuture = MethodUtils.isFuture((ExecutableElement)method);
        isValid = method.getAnnotationMirrors().stream().anyMatch((Predicate<AnnotationMirror>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildValidationReturnCode$0(javax.lang.model.element.AnnotationMirror ), (Ljavax/lang/model/element/AnnotationMirror;)Z)());
        constraints = ValidUtils.getValidatedByConstraints(this.env, returnType, method.getAnnotationMirrors());
        validates = isValid != false ? List.of(new ValidMeta.Validated(ValidMeta.Type.ofElement(this.env.getTypeUtils().asElement(returnType), returnType))) : Collections.emptyList();
        isPrimitive = returnType instanceof PrimitiveType;
        if (isMono || isFlux || isFuture) {
            isNullable = MethodUtils.getGenericType((TypeMirror)method.getReturnType()).map((Function<TypeMirror, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isNullable(javax.lang.model.AnnotatedConstruct ), (Ljavax/lang/model/type/TypeMirror;)Ljava/lang/Boolean;)()).orElse(false) != false || CommonUtils.isNullable((AnnotatedConstruct)method) != false;
        } else {
            v0 = isNullable = CommonUtils.isNullable((AnnotatedConstruct)method) != false && isPrimitive == false;
        }
        isNotNull = isMono != false || isFlux != false || isFuture != false ? MethodUtils.getGenericType((TypeMirror)method.getReturnType()).map((Function<TypeMirror, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isNotNull(javax.lang.model.AnnotatedConstruct ), (Ljavax/lang/model/type/TypeMirror;)Ljava/lang/Boolean;)()).orElse(false) != false || ValidUtils.isNotNull(method) != false : ValidUtils.isNotNull(method);
        v1 = isNotNullable = (isValid != false || isNotNull != false) && isNullable == false && isPrimitive == false;
        if (!(returnType instanceof DeclaredType)) ** GOTO lbl-1000
        dt = (DeclaredType)returnType;
        if (ValidTypes.jsonNullable.canonicalName().equals(dt.asElement().toString())) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isJsonNullable = v2;
        v3 = haveValidators = constraints.isEmpty() == false || validates.isEmpty() == false;
        if (!haveValidators && !isNotNullable) {
            return Optional.empty();
        }
        builder = CodeBlock.builder();
        isFailFast = method.getAnnotationMirrors().stream().filter((Predicate<AnnotationMirror>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildValidationReturnCode$1(javax.lang.model.element.AnnotationMirror ), (Ljavax/lang/model/element/AnnotationMirror;)Z)()).flatMap((Function<AnnotationMirror, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildValidationReturnCode$4(javax.lang.model.element.AnnotationMirror ), (Ljavax/lang/model/element/AnnotationMirror;)Ljava/util/stream/Stream;)((ValidateMethodKoraAspect)this)).findFirst().orElse(false);
        resultCtxBlock = isFailFast != false ? CodeBlock.of((String)"var _returnCtx = $T.failFast();\n", (Object[])new Object[]{ValidTypes.CONTEXT_TYPE}) : CodeBlock.of((String)"var _returnCtx = $T.full();\n", (Object[])new Object[]{ValidTypes.CONTEXT_TYPE});
        v4 = resultAccessor = isJsonNullable != false ? "_result.value()" : "_result";
        if (isJsonNullable && isNotNull && !isNullable || isNotNullable) {
            if (isJsonNullable && isNotNull) {
                builder.beginControlFlow("if (_result == null || !_result.isDefined() || _result.isNull())", new Object[0]);
            } else {
                builder.beginControlFlow("if (_result == null)", new Object[0]);
            }
            builder.add(resultCtxBlock);
            if (MethodUtils.isFuture((ExecutableElement)method)) {
                builder.addStatement("throw new $T(_returnCtx.violates(\"Result must be non null, but was null\"))", new Object[]{ValidTypes.violationException});
            } else if (MethodUtils.isMono((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnCtx.violates(\"Result must be non null, but was null\")))", new Object[]{ValidTypes.violationException});
                builder.addStatement("return", new Object[0]);
            } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnCtx.violates(\"Result must be non null, but was null\")))", new Object[]{ValidTypes.violationException});
                builder.addStatement("return", new Object[0]);
            } else {
                builder.addStatement("throw new $T(_returnCtx.violates(\"Result must be non null, but was null\"))", new Object[]{ValidTypes.violationException});
            }
            if (haveValidators) {
                if (isJsonNullable) {
                    builder.nextControlFlow("else if(_result.isDefined())", new Object[0]);
                } else {
                    builder.nextControlFlow("else", new Object[0]);
                }
                builder.add(resultCtxBlock);
                if (!isFailFast) {
                    builder.addStatement("var _returnViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidTypes.VIOLATION_TYPE});
                }
            }
        } else if (isJsonNullable) {
            builder.beginControlFlow("if(_result != null && _result.isDefined())", new Object[0]);
            builder.add(resultCtxBlock);
            if (!isFailFast) {
                builder.addStatement("var _returnViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidTypes.VIOLATION_TYPE});
            }
        } else {
            builder.beginControlFlow("if(_result != null)", new Object[0]);
            builder.add(resultCtxBlock);
            if (!isFailFast) {
                builder.addStatement("var _returnViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidTypes.VIOLATION_TYPE});
            }
        }
        for (i = 1; i <= constraints.size(); ++i) {
            constraint = constraints.get(i - 1);
            constraintFactory = aspectContext.fieldFactory().constructorParam(constraint.factory().type().typeMirror(), List.of());
            constraintType = constraint.factory().validator().typeMirror();
            createExec = CodeBlock.builder().add("$N.create", new Object[]{constraintFactory}).add((CodeBlock)constraint.factory().parameters().values().stream().map((Function<Object, CodeBlock>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildValidationReturnCode$5(java.lang.Object ), (Ljava/lang/Object;)Lcom/squareup/javapoet/CodeBlock;)()).collect(CodeBlock.joining((String)", ", (String)"(", (String)")"))).build();
            constraintField = aspectContext.fieldFactory().constructorInitialized(constraintType, createExec);
            constraintResultField = "_returnConstResult_" + i;
            builder.addStatement("var $N = $N.validate($L, _returnCtx)", new Object[]{constraintResultField, constraintField, resultAccessor});
            if (isFailFast) {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField});
                if (MethodUtils.isFuture((ExecutableElement)method)) {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, constraintResultField});
                } else if (MethodUtils.isMono((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidTypes.EXCEPTION_TYPE, constraintResultField});
                    builder.addStatement("return", new Object[0]);
                } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidTypes.EXCEPTION_TYPE, constraintResultField});
                    builder.addStatement("return", new Object[0]);
                } else {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, constraintResultField});
                }
                builder.endControlFlow();
            } else {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField}).addStatement("_returnViolations.addAll($N)", new Object[]{constraintResultField}).endControlFlow();
            }
            if (i + 1 >= constraints.size()) continue;
            builder.add("\n", new Object[0]);
        }
        for (i = 1; i <= validates.size(); ++i) {
            validated = (ValidMeta.Validated)validates.get(i - 1);
            validatorType = validated.validator(this.env).typeMirror();
            validatorField = aspectContext.fieldFactory().constructorParam(validatorType, List.of());
            validatedResultField = "_returnValidatorResult_" + i;
            builder.addStatement("var $N = $N.validate($L, _returnCtx)", new Object[]{validatedResultField, validatorField, resultAccessor});
            if (isFailFast) {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatedResultField});
                if (MethodUtils.isFuture((ExecutableElement)method)) {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, validatedResultField});
                } else if (MethodUtils.isMono((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidTypes.EXCEPTION_TYPE, validatedResultField});
                    builder.addStatement("return", new Object[0]);
                } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                    builder.addStatement("_sink.error(new $T($N))", new Object[]{ValidTypes.EXCEPTION_TYPE, validatedResultField});
                    builder.addStatement("return", new Object[0]);
                } else {
                    builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, validatedResultField});
                }
                builder.endControlFlow();
            } else {
                builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatedResultField}).addStatement("_returnViolations.addAll($N)", new Object[]{validatedResultField}).endControlFlow();
            }
            if (i + 1 >= validates.size()) continue;
            builder.add("\n", new Object[0]);
        }
        if (haveValidators && !isFailFast) {
            builder.add("\n", new Object[0]);
            builder.beginControlFlow("if (!_returnViolations.isEmpty())", new Object[0]);
            if (MethodUtils.isFuture((ExecutableElement)method)) {
                builder.addStatement("throw new $T(_returnViolations)", new Object[]{ValidTypes.EXCEPTION_TYPE});
            } else if (MethodUtils.isMono((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnViolations))", new Object[]{ValidTypes.EXCEPTION_TYPE});
                builder.addStatement("return", new Object[0]);
            } else if (MethodUtils.isFlux((ExecutableElement)method)) {
                builder.addStatement("_sink.error(new $T(_returnViolations))", new Object[]{ValidTypes.EXCEPTION_TYPE});
                builder.addStatement("return", new Object[0]);
            } else {
                builder.addStatement("throw new $T(_returnViolations)", new Object[]{ValidTypes.EXCEPTION_TYPE});
            }
            builder.endControlFlow();
        }
        if (isJsonNullable && isNotNull && !isNullable || isNotNullable) {
            builder.endControlFlow();
        }
        if (!isNotNullable) {
            builder.endControlFlow();
        }
        return Optional.of(builder.build());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Optional<CodeBlock> buildValidationArgumentCode(ExecutableElement method, KoraAspect.AspectContext aspectContext) {
        haveNoValidatable = method.getParameters().stream().noneMatch((Predicate<VariableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isParameterValidatable(javax.lang.model.element.VariableElement ), (Ljavax/lang/model/element/VariableElement;)Z)((ValidateMethodKoraAspect)this));
        allParamsNullable = method.getParameters().stream().allMatch((Predicate<VariableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNullable(javax.lang.model.AnnotatedConstruct ), (Ljavax/lang/model/element/VariableElement;)Z)());
        if (allParamsNullable && haveNoValidatable) {
            return Optional.empty();
        }
        isFailFast = method.getAnnotationMirrors().stream().filter((Predicate<AnnotationMirror>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildValidationArgumentCode$6(javax.lang.model.element.AnnotationMirror ), (Ljavax/lang/model/element/AnnotationMirror;)Z)()).flatMap((Function<AnnotationMirror, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildValidationArgumentCode$9(javax.lang.model.element.AnnotationMirror ), (Ljavax/lang/model/element/AnnotationMirror;)Ljava/util/stream/Stream;)((ValidateMethodKoraAspect)this)).findFirst().orElse(false);
        builder = CodeBlock.builder().addStatement("var _argCtx = $T.builder().failFast($L).build()", new Object[]{ValidTypes.CONTEXT_TYPE, isFailFast});
        if (!isFailFast) {
            builder.addStatement("var _argViolations = new $T<$T>()", new Object[]{ArrayList.class, ValidTypes.VIOLATION_TYPE});
            builder.add("\n", new Object[0]);
        }
        for (VariableElement parameter : method.getParameters()) {
            isPrimitive = parameter.asType() instanceof PrimitiveType;
            isNullable = CommonUtils.isNullable((AnnotatedConstruct)parameter) != false && isPrimitive == false;
            isNotNullable = CommonUtils.isNullable((AnnotatedConstruct)parameter) == false && isPrimitive == false;
            isNotNull = ValidUtils.isNotNull(parameter);
            var15_15 = parameter.asType();
            if (!(var15_15 instanceof DeclaredType)) ** GOTO lbl-1000
            dt = (DeclaredType)var15_15;
            if (ValidTypes.jsonNullable.canonicalName().equals(dt.asElement().toString())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            isJsonNullable = v0;
            constraints = ValidUtils.getValidatedByConstraints(this.env, parameter.asType(), parameter.getAnnotationMirrors());
            validates = this.getValidForArguments(parameter);
            v1 = haveValidators = constraints.isEmpty() == false || validates.isEmpty() == false;
            if (!haveValidators && !isJsonNullable && !isNotNullable) continue;
            paramName = parameter.getSimpleName().toString();
            v2 = paramAccessor = isJsonNullable != false ? paramName + ".value()" : paramName;
            if (isJsonNullable && isNotNull) {
                builder.beginControlFlow("if ($L == null || !$L.isDefined() || $L.isNull())", new Object[]{paramName, paramName, paramName});
            } else if (isNotNullable) {
                builder.beginControlFlow("if ($L == null)", new Object[]{paramName});
            }
            argumentContext = "_argCtx_" + String.valueOf(parameter);
            if (isJsonNullable && isNotNull || isNotNullable) {
                builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
                if (isFailFast) {
                    if (MethodUtils.isFuture((ExecutableElement)method)) {
                        builder.addStatement("return $T.failedFuture(new $T($L.violates(\"Parameter '$L' must be non null, but was null\")))", new Object[]{CompletableFuture.class, ValidTypes.violationException, argumentContext, paramName});
                    } else {
                        builder.addStatement("throw new $T($L.violates(\"Parameter '$L' must be non null, but was null\"))", new Object[]{ValidTypes.violationException, argumentContext, paramName});
                    }
                } else {
                    builder.addStatement("_argViolations.add($L.violates(\"Parameter '$L' must be non null, but was null\"))", new Object[]{argumentContext, paramName});
                }
                if (haveValidators) {
                    if (isJsonNullable) {
                        builder.nextControlFlow("else if($N.isDefined())", new Object[]{paramName});
                        builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
                    } else {
                        builder.nextControlFlow("else", new Object[0]);
                        builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
                    }
                }
            } else if (isJsonNullable) {
                builder.beginControlFlow("if($N != null && $N.isDefined())", new Object[]{paramName});
                builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
            } else if (isNullable) {
                builder.beginControlFlow("if($N != null)", new Object[]{paramName});
                builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
            } else {
                builder.addStatement("var $N = _argCtx.addPath($S)", new Object[]{argumentContext, paramName});
            }
            for (i = 1; i <= constraints.size(); ++i) {
                constraint = constraints.get(i - 1);
                constraintFactory = aspectContext.fieldFactory().constructorParam(constraint.factory().type().typeMirror(), List.of());
                constraintType = constraint.factory().validator().typeMirror();
                createExec = CodeBlock.builder().add("$N.create", new Object[]{constraintFactory}).add((CodeBlock)constraint.factory().parameters().values().stream().map((Function<Object, CodeBlock>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildValidationArgumentCode$10(java.lang.Object ), (Ljava/lang/Object;)Lcom/squareup/javapoet/CodeBlock;)()).collect(CodeBlock.joining((String)", ", (String)"(", (String)")"))).build();
                constraintField = aspectContext.fieldFactory().constructorInitialized(constraintType, createExec);
                constraintResultField = "_argConstResult_" + String.valueOf(parameter) + "_" + i;
                builder.addStatement("var $N = $N.validate($N, $N)", new Object[]{constraintResultField, constraintField, paramAccessor, argumentContext});
                if (isFailFast) {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField});
                    if (MethodUtils.isFuture((ExecutableElement)method)) {
                        builder.addStatement("return $T.failedFuture(new $T($N))", new Object[]{CompletableFuture.class, ValidTypes.EXCEPTION_TYPE, constraintResultField});
                    } else {
                        builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, constraintResultField});
                    }
                    builder.endControlFlow();
                } else {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{constraintResultField}).addStatement("_argViolations.addAll($N)", new Object[]{constraintResultField}).endControlFlow();
                }
                if (i + 1 >= constraints.size()) continue;
                builder.add("\n", new Object[0]);
            }
            for (i = 1; i <= validates.size(); ++i) {
                validated = validates.get(i - 1);
                validatorType = validated.validator(this.env).typeMirror();
                validatorField = aspectContext.fieldFactory().constructorParam(validatorType, List.of());
                validatorResultField = "_argValidatorResult_" + String.valueOf(parameter) + "_" + i;
                builder.addStatement("var $N = $N.validate($N, $N)", new Object[]{validatorResultField, validatorField, paramAccessor, argumentContext});
                if (isFailFast) {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatorResultField});
                    if (MethodUtils.isFuture((ExecutableElement)method)) {
                        builder.addStatement("return $T.failedFuture(new $T($N))", new Object[]{CompletableFuture.class, ValidTypes.EXCEPTION_TYPE, validatorResultField});
                    } else {
                        builder.addStatement("throw new $T($N)", new Object[]{ValidTypes.EXCEPTION_TYPE, validatorResultField});
                    }
                    builder.endControlFlow();
                } else {
                    builder.beginControlFlow("if (!$N.isEmpty())", new Object[]{validatorResultField}).addStatement("_argViolations.addAll($N)", new Object[]{validatorResultField}).endControlFlow();
                }
                if (i + 1 >= validates.size()) continue;
                builder.add("\n", new Object[0]);
            }
            if (isJsonNullable && isNotNull || isNotNullable) {
                builder.endControlFlow();
            }
            if (!isNullable) continue;
            builder.endControlFlow();
        }
        if (!isFailFast) {
            builder.add("\n", new Object[0]);
            builder.beginControlFlow("if (!_argViolations.isEmpty())", new Object[0]);
            if (MethodUtils.isFuture((ExecutableElement)method)) {
                builder.addStatement("return $T.failedFuture(new $T(_argViolations))", new Object[]{CompletableFuture.class, ValidTypes.EXCEPTION_TYPE});
            } else {
                builder.addStatement("throw new $T(_argViolations)", new Object[]{ValidTypes.EXCEPTION_TYPE});
            }
            builder.endControlFlow();
        }
        return Optional.of(builder.build());
    }

    private boolean isParameterValidatable(VariableElement parameter) {
        for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType.toString().equals(ValidTypes.VALID_TYPE.canonicalName())) {
                return true;
            }
            for (AnnotationMirror annotationMirror2 : annotationType.asElement().getAnnotationMirrors()) {
                if (!annotationMirror2.getAnnotationType().toString().equals(ValidTypes.VALIDATED_BY_TYPE.canonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    private List<ValidMeta.Validated> getValidForArguments(VariableElement parameter) {
        if (parameter.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals(ValidTypes.VALID_TYPE.canonicalName()))) {
            return List.of(new ValidMeta.Validated(ValidMeta.Type.ofElement(parameter, parameter.asType())));
        }
        return Collections.emptyList();
    }

    private CodeBlock buildBodySync(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            if (validationArgumentCode != null) {
                builder.add(validationArgumentCode);
            }
            return builder.add("$L;\n", new Object[]{superMethod.toString()}).build();
        }
        if (validationArgumentCode != null) {
            builder.add(validationArgumentCode).add("\n", new Object[0]);
        }
        builder.add("var _result = $L;\n", new Object[]{superMethod.toString()});
        if (validationReturnCode != null) {
            builder.add(validationReturnCode);
        }
        return builder.add("return _result;", new Object[0]).build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (validationArgumentCode != null) {
            builder.add(validationArgumentCode).add("\n", new Object[0]);
        }
        if (validationReturnCode != null) {
            builder.beginControlFlow("return $L.thenApply(_result -> ", new Object[]{superMethod.toString()});
            builder.add(validationReturnCode);
            builder.addStatement("return _result", new Object[0]);
            builder.endControlFlow(")", new Object[0]);
        } else {
            builder.addStatement("return $L", new Object[]{superMethod.toString()});
        }
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, String superCall, ClassName reactorName, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (validationArgumentCode != null) {
            builder.beginControlFlow("return $T.defer(() -> ", new Object[]{reactorName});
            builder.add(validationArgumentCode);
        }
        if (validationReturnCode != null) {
            builder.add("return $L.handle((_result, _sink) -> {\n", new Object[]{superMethod.toString()});
            builder.indent().indent().indent().indent().add(validationReturnCode).add("_sink.next(_result);", new Object[0]).unindent().unindent().unindent().unindent().add("\n\n});\n", new Object[0]);
        } else {
            builder.addStatement("return $L", new Object[]{superMethod.toString()});
        }
        if (validationArgumentCode != null) {
            builder.endControlFlow(")", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, String superCall, @Nullable CodeBlock validationReturnCode, @Nullable CodeBlock validationArgumentCode) {
        return this.buildBodyMono(method, superCall, CommonClassNames.flux, validationReturnCode, validationArgumentCode);
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }

    private static /* synthetic */ CodeBlock lambda$buildValidationArgumentCode$10(Object fp) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{fp});
    }

    private /* synthetic */ Stream lambda$buildValidationArgumentCode$9(AnnotationMirror a) {
        return this.env.getElementUtils().getElementValuesWithDefaults(a).entrySet().stream().filter(e -> "failFast".equals(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(e -> Boolean.parseBoolean(((AnnotationValue)e.getValue()).getValue().toString()));
    }

    private static /* synthetic */ boolean lambda$buildValidationArgumentCode$6(AnnotationMirror a) {
        return a.getAnnotationType().toString().equals(VALIDATE_TYPE.canonicalName());
    }

    private static /* synthetic */ CodeBlock lambda$buildValidationReturnCode$5(Object fp) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{fp});
    }

    private /* synthetic */ Stream lambda$buildValidationReturnCode$4(AnnotationMirror a) {
        return this.env.getElementUtils().getElementValuesWithDefaults(a).entrySet().stream().filter(e -> "failFast".equals(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(e -> Boolean.parseBoolean(((AnnotationValue)e.getValue()).getValue().toString()));
    }

    private static /* synthetic */ boolean lambda$buildValidationReturnCode$1(AnnotationMirror a) {
        return a.getAnnotationType().toString().equals(VALIDATE_TYPE.canonicalName());
    }

    private static /* synthetic */ boolean lambda$buildValidationReturnCode$0(AnnotationMirror a) {
        return a.getAnnotationType().toString().equals(ValidTypes.VALID_TYPE.canonicalName());
    }
}

