/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.annotation.processor.extension;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;
import ru.tinkoff.kora.validation.annotation.processor.ValidTypes;
import ru.tinkoff.kora.validation.annotation.processor.ValidatorGenerator;

public final class ValidKoraExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final TypeMirror validatorType;
    private final ValidatorGenerator generator;
    private final ProcessingEnvironment processingEnv;

    public ValidKoraExtension(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.validatorType = this.types.erasure(this.elements.getTypeElement("ru.tinkoff.kora.validation.common.Validator").asType());
        this.generator = new ValidatorGenerator(processingEnv);
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        String validatorName;
        if (!tags.isEmpty()) {
            return null;
        }
        TypeMirror erasure = this.types.erasure(typeMirror);
        if (!this.types.isSameType(erasure, this.validatorType)) {
            return null;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)typeMirror;
        TypeMirror validatorArgumentType = dt.getTypeArguments().get(0);
        if (validatorArgumentType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element validatedTypeElement = this.types.asElement(validatorArgumentType);
        String packageElement = this.elements.getPackageOf(validatedTypeElement).getQualifiedName().toString();
        TypeElement componentElement = this.elements.getTypeElement(packageElement + "." + (validatorName = NameUtils.generatedType((Element)validatedTypeElement, (ClassName)ValidTypes.VALIDATOR_TYPE)));
        if (componentElement != null) {
            return () -> this.buildExtensionResult((DeclaredType)validatorArgumentType, componentElement);
        }
        if (AnnotationUtils.findAnnotation((Element)validatedTypeElement, (ClassName)ValidTypes.VALID_TYPE) != null) {
            return ExtensionResult::nextRound;
        }
        try {
            this.generator.generateFor((TypeElement)validatedTypeElement);
        }
        catch (ProcessingErrorException e) {
            for (ProcessingError error : e.getErrors()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, error.message(), error.element(), error.a(), error.v());
            }
            return null;
        }
        return null;
    }

    private ExtensionResult buildExtensionResult(DeclaredType componentArgumentType, TypeElement componentElement) {
        ExecutableElement constructor = this.findDefaultConstructor(componentElement);
        if (componentElement.getTypeParameters().isEmpty()) {
            return ExtensionResult.fromExecutable((ExecutableElement)constructor);
        }
        List<? extends TypeMirror> typeTypeParameters = componentArgumentType.getTypeArguments();
        DeclaredType declaredType = this.types.getDeclaredType(componentElement, typeTypeParameters.toArray(new TypeMirror[0]));
        ExecutableType constructorType = (ExecutableType)this.types.asMemberOf(declaredType, constructor);
        return ExtensionResult.fromExecutable((ExecutableElement)constructor, (ExecutableType)constructorType);
    }

    private ExecutableElement findDefaultConstructor(TypeElement componentElement) {
        return componentElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).findFirst().orElseThrow();
    }
}

