/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;
import ru.tinkoff.kora.validation.common.annotation.Range;

final class RangeBigIntegerValidator
implements Validator<BigInteger> {
    private final BigInteger from;
    private final BigInteger to;
    private final Range.Boundary boundary;
    private final Predicate<BigInteger> fromPredicate;
    private final Predicate<BigInteger> toPredicate;

    RangeBigIntegerValidator(double fromDouble, double toDouble, Range.Boundary boundary) {
        if (toDouble < fromDouble) {
            throw new IllegalArgumentException("From can't be less than To, but From was " + fromDouble + " and To was " + toDouble);
        }
        this.from = BigDecimal.valueOf(fromDouble).toBigInteger();
        this.to = BigDecimal.valueOf(toDouble).toBigInteger();
        this.boundary = boundary;
        this.fromPredicate = switch (boundary) {
            default -> throw new IncompatibleClassChangeError();
            case Range.Boundary.INCLUSIVE_INCLUSIVE, Range.Boundary.INCLUSIVE_EXCLUSIVE -> v -> v.compareTo(this.from) >= 0;
            case Range.Boundary.EXCLUSIVE_INCLUSIVE, Range.Boundary.EXCLUSIVE_EXCLUSIVE -> v -> v.compareTo(this.from) > 0;
        };
        this.toPredicate = switch (boundary) {
            default -> throw new IncompatibleClassChangeError();
            case Range.Boundary.INCLUSIVE_EXCLUSIVE, Range.Boundary.EXCLUSIVE_EXCLUSIVE -> v -> v.compareTo(this.to) < 0;
            case Range.Boundary.INCLUSIVE_INCLUSIVE, Range.Boundary.EXCLUSIVE_INCLUSIVE -> v -> v.compareTo(this.to) <= 0;
        };
    }

    @Override
    @Nonnull
    public List<Violation> validate(BigInteger value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should be in range from '" + String.valueOf(this.from) + "' to '" + String.valueOf(this.to) + "', but was null"));
        }
        if (!this.fromPredicate.test(value)) {
            return List.of(context.violates("Should be in range from '" + String.valueOf(this.from) + "' to '" + String.valueOf(this.to) + "', but was smaller: " + String.valueOf(value)));
        }
        if (!this.toPredicate.test(value)) {
            return List.of(context.violates("Should be in range from '" + String.valueOf(this.from) + "' to '" + String.valueOf(this.to) + "', but was greater: " + String.valueOf(value)));
        }
        return Collections.emptyList();
    }
}

