/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.constraint.IterableValidator;
import ru.tinkoff.kora.validation.common.constraint.NotBlankStringValidator;
import ru.tinkoff.kora.validation.common.constraint.NotEmptyIterableValidator;
import ru.tinkoff.kora.validation.common.constraint.NotEmptyMapValidator;
import ru.tinkoff.kora.validation.common.constraint.NotEmptyStringValidator;
import ru.tinkoff.kora.validation.common.constraint.PatternValidator;
import ru.tinkoff.kora.validation.common.constraint.RangeBigDecimalValidator;
import ru.tinkoff.kora.validation.common.constraint.RangeBigIntegerValidator;
import ru.tinkoff.kora.validation.common.constraint.RangeDoubleNumberValidator;
import ru.tinkoff.kora.validation.common.constraint.RangeLongNumberValidator;
import ru.tinkoff.kora.validation.common.constraint.SizeCollectionValidator;
import ru.tinkoff.kora.validation.common.constraint.SizeMapValidator;
import ru.tinkoff.kora.validation.common.constraint.SizeStringValidator;
import ru.tinkoff.kora.validation.common.constraint.factory.NotBlankValidatorFactory;
import ru.tinkoff.kora.validation.common.constraint.factory.NotEmptyValidatorFactory;
import ru.tinkoff.kora.validation.common.constraint.factory.PatternValidatorFactory;
import ru.tinkoff.kora.validation.common.constraint.factory.RangeValidatorFactory;
import ru.tinkoff.kora.validation.common.constraint.factory.SizeValidatorFactory;

public interface ValidatorModule {
    default public <T> Validator<List<T>> listValidator(Validator<T> validator, TypeRef<T> valueRef) {
        return new IterableValidator(validator);
    }

    default public <T> Validator<Set<T>> setValidator(Validator<T> validator, TypeRef<T> valueRef) {
        return new IterableValidator(validator);
    }

    default public <T> Validator<Collection<T>> collectionValidator(Validator<T> validator, TypeRef<T> valueRef) {
        return new IterableValidator(validator);
    }

    default public <K, V> NotEmptyValidatorFactory<Map<K, V>> notEmptyMapConstraintFactory(TypeRef<K> keyRef, TypeRef<V> valueRef) {
        return NotEmptyMapValidator::new;
    }

    default public <T> NotEmptyValidatorFactory<Iterable<T>> notEmptyIterableConstraintFactory(TypeRef<T> valueRef) {
        return NotEmptyIterableValidator::new;
    }

    default public <T> NotEmptyValidatorFactory<List<T>> notEmptyListConstraintFactory(TypeRef<T> valueRef) {
        return NotEmptyIterableValidator::new;
    }

    default public <T> NotEmptyValidatorFactory<Set<T>> notEmptySetConstraintFactory(TypeRef<T> valueRef) {
        return NotEmptyIterableValidator::new;
    }

    default public <T> NotEmptyValidatorFactory<Collection<T>> notEmptyCollectionConstraintFactory(TypeRef<T> valueRef) {
        return NotEmptyIterableValidator::new;
    }

    default public NotEmptyValidatorFactory<String> notEmptyStringConstraintFactory() {
        return NotEmptyStringValidator::new;
    }

    default public NotEmptyValidatorFactory<CharSequence> notEmptyCharSequenceConstraintFactory() {
        return NotEmptyStringValidator::new;
    }

    default public NotBlankValidatorFactory<String> notBlankStringConstraintFactory() {
        return NotBlankStringValidator::new;
    }

    default public NotBlankValidatorFactory<CharSequence> notBlankCharSequenceConstraintFactory() {
        return NotBlankStringValidator::new;
    }

    default public RangeValidatorFactory<Short> rangeShortConstraintFactory() {
        return RangeLongNumberValidator::new;
    }

    default public RangeValidatorFactory<Integer> rangeIntegerConstraintFactory() {
        return RangeLongNumberValidator::new;
    }

    default public RangeValidatorFactory<Long> rangeLongConstraintFactory() {
        return RangeLongNumberValidator::new;
    }

    default public RangeValidatorFactory<Float> rangeFloatConstraintFactory() {
        return RangeDoubleNumberValidator::new;
    }

    default public RangeValidatorFactory<Double> rangeDoubleConstraintFactory() {
        return RangeDoubleNumberValidator::new;
    }

    default public RangeValidatorFactory<BigInteger> rangeBigIntegerConstraintFactory() {
        return RangeBigIntegerValidator::new;
    }

    default public RangeValidatorFactory<BigDecimal> rangeBigDecimalConstraintFactory() {
        return RangeBigDecimalValidator::new;
    }

    default public SizeValidatorFactory<String> sizeStringConstraintFactory() {
        return SizeStringValidator::new;
    }

    default public SizeValidatorFactory<CharSequence> sizeCharSequenceConstraintFactory() {
        return SizeStringValidator::new;
    }

    default public <K, V> SizeValidatorFactory<Map<K, V>> sizeDoubleConstraintFactory(TypeRef<K> keyRef, TypeRef<V> valueRef) {
        return SizeMapValidator::new;
    }

    default public <V> SizeValidatorFactory<Collection<V>> sizeIterableConstraintFactory(TypeRef<V> valueRef) {
        return SizeCollectionValidator::new;
    }

    default public <V> SizeValidatorFactory<List<V>> sizeListConstraintFactory(TypeRef<V> valueRef) {
        return SizeCollectionValidator::new;
    }

    default public <V> SizeValidatorFactory<Set<V>> sizeSetConstraintFactory(TypeRef<V> valueRef) {
        return SizeCollectionValidator::new;
    }

    default public PatternValidatorFactory<String> patternStringConstraintFactory() {
        return PatternValidator::new;
    }

    default public PatternValidatorFactory<CharSequence> patternCharSequenceConstraintFactory() {
        return PatternValidator::new;
    }
}

