/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.module.http.server;

import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.server.common.HttpServerInterceptor;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.validation.common.ViolationException;
import ru.tinkoff.kora.validation.module.http.server.ViolationExceptionHttpServerResponseMapper;

public final class ValidationHttpServerInterceptor
implements HttpServerInterceptor {
    @Nullable
    private final ViolationExceptionHttpServerResponseMapper mapper;

    public ValidationHttpServerInterceptor(@Nullable ViolationExceptionHttpServerResponseMapper mapper) {
        this.mapper = mapper;
    }

    public CompletionStage<HttpServerResponse> intercept(Context context, HttpServerRequest request, HttpServerInterceptor.InterceptChain chain) throws Exception {
        try {
            return chain.process(context, request).exceptionallyCompose(e -> {
                CompletionException ce;
                Throwable patt1391$temp;
                if (e instanceof ViolationException) {
                    ViolationException ve = (ViolationException)((Object)e);
                    return CompletableFuture.completedFuture(this.toResponse(context, request, ve));
                }
                if (e instanceof CompletionException && (patt1391$temp = (ce = (CompletionException)e).getCause()) instanceof ViolationException) {
                    ViolationException ve = (ViolationException)patt1391$temp;
                    return CompletableFuture.completedFuture(this.toResponse(context, request, ve));
                }
                return CompletableFuture.failedFuture(e);
            });
        }
        catch (CompletionException ce) {
            Throwable throwable = ce.getCause();
            if (throwable instanceof ViolationException) {
                ViolationException ve = (ViolationException)throwable;
                return CompletableFuture.completedFuture(this.toResponse(context, request, ve));
            }
            throw ce;
        }
        catch (ViolationException e2) {
            return CompletableFuture.completedFuture(this.toResponse(context, request, e2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServerResponse toResponse(Context contextFromChain, HttpServerRequest request, ViolationException exception) {
        if (this.mapper != null) {
            Context current = Context.current();
            try {
                contextFromChain.inject();
                HttpServerResponse response = this.mapper.apply(request, exception);
                if (response != null) {
                    HttpServerResponse httpServerResponse = response;
                    return httpServerResponse;
                }
            }
            finally {
                current.inject();
            }
        }
        String message = exception.getMessage();
        return HttpServerResponseException.of((int)400, (String)message);
    }
}

