/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.vertx.common;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.VertxThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.vertx.common.VertxEventLoopGroupTransport;

public abstract class VertxUtil {
    private static final AtomicInteger threadCounter = new AtomicInteger(0);

    private VertxUtil() {
    }

    public static Vertx customEventLoopVertx(EventLoopGroup eventLoopGroup) {
        return new VertxBuilder(new VertxOptions().setWorkerPoolSize(1).setMetricsOptions(new MetricsOptions().setEnabled(false))).executorServiceFactory((threadFactory, concurrency, maxConcurrency) -> eventLoopGroup).transport((Transport)new VertxEventLoopGroupTransport(eventLoopGroup)).vertx();
    }

    public static ThreadFactory vertxThreadFactory() {
        return r -> {
            int i = threadCounter.incrementAndGet();
            return VertxThreadFactory.INSTANCE.newVertxThread(r, "netty-event-loop-" + i, false, 1488L, TimeUnit.SECONDS);
        };
    }
}

