package ru.tinkoff.piapi.contract.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 *Сервис предназначен для получения:&lt;/br&gt; **1**.  списка операций по счёту;&lt;/br&gt; **2**.
 *портфеля по счёту;&lt;/br&gt; **3**. позиций ценных бумаг на счёте;&lt;/br&gt; **4**.
 *доступного остатка для вывода средств;&lt;/br&gt; **5**. получения различных отчётов.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.44.0)",
    comments = "Source: operations.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class OperationsServiceGrpc {

  private OperationsServiceGrpc() {}

  public static final String SERVICE_NAME = "tinkoff.public.invest.api.contract.v1.OperationsService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.OperationsRequest,
      ru.tinkoff.piapi.contract.v1.OperationsResponse> getGetOperationsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetOperations",
      requestType = ru.tinkoff.piapi.contract.v1.OperationsRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.OperationsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.OperationsRequest,
      ru.tinkoff.piapi.contract.v1.OperationsResponse> getGetOperationsMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.OperationsRequest, ru.tinkoff.piapi.contract.v1.OperationsResponse> getGetOperationsMethod;
    if ((getGetOperationsMethod = OperationsServiceGrpc.getGetOperationsMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetOperationsMethod = OperationsServiceGrpc.getGetOperationsMethod) == null) {
          OperationsServiceGrpc.getGetOperationsMethod = getGetOperationsMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.OperationsRequest, ru.tinkoff.piapi.contract.v1.OperationsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetOperations"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.OperationsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.OperationsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetOperations"))
              .build();
        }
      }
    }
    return getGetOperationsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PortfolioRequest,
      ru.tinkoff.piapi.contract.v1.PortfolioResponse> getGetPortfolioMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPortfolio",
      requestType = ru.tinkoff.piapi.contract.v1.PortfolioRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.PortfolioResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PortfolioRequest,
      ru.tinkoff.piapi.contract.v1.PortfolioResponse> getGetPortfolioMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PortfolioRequest, ru.tinkoff.piapi.contract.v1.PortfolioResponse> getGetPortfolioMethod;
    if ((getGetPortfolioMethod = OperationsServiceGrpc.getGetPortfolioMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetPortfolioMethod = OperationsServiceGrpc.getGetPortfolioMethod) == null) {
          OperationsServiceGrpc.getGetPortfolioMethod = getGetPortfolioMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.PortfolioRequest, ru.tinkoff.piapi.contract.v1.PortfolioResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetPortfolio"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PortfolioRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PortfolioResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetPortfolio"))
              .build();
        }
      }
    }
    return getGetPortfolioMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PositionsRequest,
      ru.tinkoff.piapi.contract.v1.PositionsResponse> getGetPositionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPositions",
      requestType = ru.tinkoff.piapi.contract.v1.PositionsRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.PositionsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PositionsRequest,
      ru.tinkoff.piapi.contract.v1.PositionsResponse> getGetPositionsMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PositionsRequest, ru.tinkoff.piapi.contract.v1.PositionsResponse> getGetPositionsMethod;
    if ((getGetPositionsMethod = OperationsServiceGrpc.getGetPositionsMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetPositionsMethod = OperationsServiceGrpc.getGetPositionsMethod) == null) {
          OperationsServiceGrpc.getGetPositionsMethod = getGetPositionsMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.PositionsRequest, ru.tinkoff.piapi.contract.v1.PositionsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetPositions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PositionsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PositionsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetPositions"))
              .build();
        }
      }
    }
    return getGetPositionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest,
      ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> getGetWithdrawLimitsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetWithdrawLimits",
      requestType = ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest,
      ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> getGetWithdrawLimitsMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest, ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> getGetWithdrawLimitsMethod;
    if ((getGetWithdrawLimitsMethod = OperationsServiceGrpc.getGetWithdrawLimitsMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetWithdrawLimitsMethod = OperationsServiceGrpc.getGetWithdrawLimitsMethod) == null) {
          OperationsServiceGrpc.getGetWithdrawLimitsMethod = getGetWithdrawLimitsMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest, ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetWithdrawLimits"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetWithdrawLimits"))
              .build();
        }
      }
    }
    return getGetWithdrawLimitsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.BrokerReportRequest,
      ru.tinkoff.piapi.contract.v1.BrokerReportResponse> getGetBrokerReportMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetBrokerReport",
      requestType = ru.tinkoff.piapi.contract.v1.BrokerReportRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.BrokerReportResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.BrokerReportRequest,
      ru.tinkoff.piapi.contract.v1.BrokerReportResponse> getGetBrokerReportMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.BrokerReportRequest, ru.tinkoff.piapi.contract.v1.BrokerReportResponse> getGetBrokerReportMethod;
    if ((getGetBrokerReportMethod = OperationsServiceGrpc.getGetBrokerReportMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetBrokerReportMethod = OperationsServiceGrpc.getGetBrokerReportMethod) == null) {
          OperationsServiceGrpc.getGetBrokerReportMethod = getGetBrokerReportMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.BrokerReportRequest, ru.tinkoff.piapi.contract.v1.BrokerReportResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetBrokerReport"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.BrokerReportRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.BrokerReportResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetBrokerReport"))
              .build();
        }
      }
    }
    return getGetBrokerReportMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest,
      ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> getGetDividendsForeignIssuerMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetDividendsForeignIssuer",
      requestType = ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest,
      ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> getGetDividendsForeignIssuerMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest, ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> getGetDividendsForeignIssuerMethod;
    if ((getGetDividendsForeignIssuerMethod = OperationsServiceGrpc.getGetDividendsForeignIssuerMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetDividendsForeignIssuerMethod = OperationsServiceGrpc.getGetDividendsForeignIssuerMethod) == null) {
          OperationsServiceGrpc.getGetDividendsForeignIssuerMethod = getGetDividendsForeignIssuerMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest, ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetDividendsForeignIssuer"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetDividendsForeignIssuer"))
              .build();
        }
      }
    }
    return getGetDividendsForeignIssuerMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest,
      ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> getGetOperationsByCursorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetOperationsByCursor",
      requestType = ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest,
      ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> getGetOperationsByCursorMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest, ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> getGetOperationsByCursorMethod;
    if ((getGetOperationsByCursorMethod = OperationsServiceGrpc.getGetOperationsByCursorMethod) == null) {
      synchronized (OperationsServiceGrpc.class) {
        if ((getGetOperationsByCursorMethod = OperationsServiceGrpc.getGetOperationsByCursorMethod) == null) {
          OperationsServiceGrpc.getGetOperationsByCursorMethod = getGetOperationsByCursorMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest, ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetOperationsByCursor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperationsServiceMethodDescriptorSupplier("GetOperationsByCursor"))
              .build();
        }
      }
    }
    return getGetOperationsByCursorMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OperationsServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperationsServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperationsServiceStub>() {
        @java.lang.Override
        public OperationsServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperationsServiceStub(channel, callOptions);
        }
      };
    return OperationsServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OperationsServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperationsServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperationsServiceBlockingStub>() {
        @java.lang.Override
        public OperationsServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperationsServiceBlockingStub(channel, callOptions);
        }
      };
    return OperationsServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OperationsServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperationsServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperationsServiceFutureStub>() {
        @java.lang.Override
        public OperationsServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperationsServiceFutureStub(channel, callOptions);
        }
      };
    return OperationsServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   *Сервис предназначен для получения:&lt;/br&gt; **1**.  списка операций по счёту;&lt;/br&gt; **2**.
   *портфеля по счёту;&lt;/br&gt; **3**. позиций ценных бумаг на счёте;&lt;/br&gt; **4**.
   *доступного остатка для вывода средств;&lt;/br&gt; **5**. получения различных отчётов.
   * </pre>
   */
  public static abstract class OperationsServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     *Метод получения списка операций по счёту.При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public void getOperations(ru.tinkoff.piapi.contract.v1.OperationsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OperationsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetOperationsMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения портфеля по счёту.
     * </pre>
     */
    public void getPortfolio(ru.tinkoff.piapi.contract.v1.PortfolioRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PortfolioResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetPortfolioMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка позиций по счёту.
     * </pre>
     */
    public void getPositions(ru.tinkoff.piapi.contract.v1.PositionsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PositionsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetPositionsMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения доступного остатка для вывода средств.
     * </pre>
     */
    public void getWithdrawLimits(ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetWithdrawLimitsMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения брокерского отчёта.
     * </pre>
     */
    public void getBrokerReport(ru.tinkoff.piapi.contract.v1.BrokerReportRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.BrokerReportResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetBrokerReportMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения отчёта "Справка о доходах за пределами РФ".
     * </pre>
     */
    public void getDividendsForeignIssuer(ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetDividendsForeignIssuerMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту с пагинацией. При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public void getOperationsByCursor(ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetOperationsByCursorMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetOperationsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.OperationsRequest,
                ru.tinkoff.piapi.contract.v1.OperationsResponse>(
                  this, METHODID_GET_OPERATIONS)))
          .addMethod(
            getGetPortfolioMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.PortfolioRequest,
                ru.tinkoff.piapi.contract.v1.PortfolioResponse>(
                  this, METHODID_GET_PORTFOLIO)))
          .addMethod(
            getGetPositionsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.PositionsRequest,
                ru.tinkoff.piapi.contract.v1.PositionsResponse>(
                  this, METHODID_GET_POSITIONS)))
          .addMethod(
            getGetWithdrawLimitsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest,
                ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse>(
                  this, METHODID_GET_WITHDRAW_LIMITS)))
          .addMethod(
            getGetBrokerReportMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.BrokerReportRequest,
                ru.tinkoff.piapi.contract.v1.BrokerReportResponse>(
                  this, METHODID_GET_BROKER_REPORT)))
          .addMethod(
            getGetDividendsForeignIssuerMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest,
                ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse>(
                  this, METHODID_GET_DIVIDENDS_FOREIGN_ISSUER)))
          .addMethod(
            getGetOperationsByCursorMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest,
                ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse>(
                  this, METHODID_GET_OPERATIONS_BY_CURSOR)))
          .build();
    }
  }

  /**
   * <pre>
   *Сервис предназначен для получения:&lt;/br&gt; **1**.  списка операций по счёту;&lt;/br&gt; **2**.
   *портфеля по счёту;&lt;/br&gt; **3**. позиций ценных бумаг на счёте;&lt;/br&gt; **4**.
   *доступного остатка для вывода средств;&lt;/br&gt; **5**. получения различных отчётов.
   * </pre>
   */
  public static final class OperationsServiceStub extends io.grpc.stub.AbstractAsyncStub<OperationsServiceStub> {
    private OperationsServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperationsServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperationsServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту.При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public void getOperations(ru.tinkoff.piapi.contract.v1.OperationsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OperationsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetOperationsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения портфеля по счёту.
     * </pre>
     */
    public void getPortfolio(ru.tinkoff.piapi.contract.v1.PortfolioRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PortfolioResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetPortfolioMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка позиций по счёту.
     * </pre>
     */
    public void getPositions(ru.tinkoff.piapi.contract.v1.PositionsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PositionsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetPositionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения доступного остатка для вывода средств.
     * </pre>
     */
    public void getWithdrawLimits(ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetWithdrawLimitsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения брокерского отчёта.
     * </pre>
     */
    public void getBrokerReport(ru.tinkoff.piapi.contract.v1.BrokerReportRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.BrokerReportResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetBrokerReportMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения отчёта "Справка о доходах за пределами РФ".
     * </pre>
     */
    public void getDividendsForeignIssuer(ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetDividendsForeignIssuerMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту с пагинацией. При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public void getOperationsByCursor(ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetOperationsByCursorMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   *Сервис предназначен для получения:&lt;/br&gt; **1**.  списка операций по счёту;&lt;/br&gt; **2**.
   *портфеля по счёту;&lt;/br&gt; **3**. позиций ценных бумаг на счёте;&lt;/br&gt; **4**.
   *доступного остатка для вывода средств;&lt;/br&gt; **5**. получения различных отчётов.
   * </pre>
   */
  public static final class OperationsServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<OperationsServiceBlockingStub> {
    private OperationsServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperationsServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperationsServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту.При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.OperationsResponse getOperations(ru.tinkoff.piapi.contract.v1.OperationsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetOperationsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения портфеля по счёту.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.PortfolioResponse getPortfolio(ru.tinkoff.piapi.contract.v1.PortfolioRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetPortfolioMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения списка позиций по счёту.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.PositionsResponse getPositions(ru.tinkoff.piapi.contract.v1.PositionsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetPositionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения доступного остатка для вывода средств.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse getWithdrawLimits(ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetWithdrawLimitsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения брокерского отчёта.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.BrokerReportResponse getBrokerReport(ru.tinkoff.piapi.contract.v1.BrokerReportRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetBrokerReportMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения отчёта "Справка о доходах за пределами РФ".
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse getDividendsForeignIssuer(ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetDividendsForeignIssuerMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту с пагинацией. При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse getOperationsByCursor(ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetOperationsByCursorMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   *Сервис предназначен для получения:&lt;/br&gt; **1**.  списка операций по счёту;&lt;/br&gt; **2**.
   *портфеля по счёту;&lt;/br&gt; **3**. позиций ценных бумаг на счёте;&lt;/br&gt; **4**.
   *доступного остатка для вывода средств;&lt;/br&gt; **5**. получения различных отчётов.
   * </pre>
   */
  public static final class OperationsServiceFutureStub extends io.grpc.stub.AbstractFutureStub<OperationsServiceFutureStub> {
    private OperationsServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperationsServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperationsServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту.При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.OperationsResponse> getOperations(
        ru.tinkoff.piapi.contract.v1.OperationsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetOperationsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения портфеля по счёту.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.PortfolioResponse> getPortfolio(
        ru.tinkoff.piapi.contract.v1.PortfolioRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetPortfolioMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения списка позиций по счёту.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.PositionsResponse> getPositions(
        ru.tinkoff.piapi.contract.v1.PositionsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetPositionsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения доступного остатка для вывода средств.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse> getWithdrawLimits(
        ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetWithdrawLimitsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения брокерского отчёта.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.BrokerReportResponse> getBrokerReport(
        ru.tinkoff.piapi.contract.v1.BrokerReportRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetBrokerReportMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения отчёта "Справка о доходах за пределами РФ".
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse> getDividendsForeignIssuer(
        ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetDividendsForeignIssuerMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения списка операций по счёту с пагинацией. При работе с данным методом необходимо учитывать
     * [особенности взаимодействия](/investAPI/operations_problems) с данным методом.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse> getOperationsByCursor(
        ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetOperationsByCursorMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_OPERATIONS = 0;
  private static final int METHODID_GET_PORTFOLIO = 1;
  private static final int METHODID_GET_POSITIONS = 2;
  private static final int METHODID_GET_WITHDRAW_LIMITS = 3;
  private static final int METHODID_GET_BROKER_REPORT = 4;
  private static final int METHODID_GET_DIVIDENDS_FOREIGN_ISSUER = 5;
  private static final int METHODID_GET_OPERATIONS_BY_CURSOR = 6;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final OperationsServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(OperationsServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_OPERATIONS:
          serviceImpl.getOperations((ru.tinkoff.piapi.contract.v1.OperationsRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OperationsResponse>) responseObserver);
          break;
        case METHODID_GET_PORTFOLIO:
          serviceImpl.getPortfolio((ru.tinkoff.piapi.contract.v1.PortfolioRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PortfolioResponse>) responseObserver);
          break;
        case METHODID_GET_POSITIONS:
          serviceImpl.getPositions((ru.tinkoff.piapi.contract.v1.PositionsRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PositionsResponse>) responseObserver);
          break;
        case METHODID_GET_WITHDRAW_LIMITS:
          serviceImpl.getWithdrawLimits((ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse>) responseObserver);
          break;
        case METHODID_GET_BROKER_REPORT:
          serviceImpl.getBrokerReport((ru.tinkoff.piapi.contract.v1.BrokerReportRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.BrokerReportResponse>) responseObserver);
          break;
        case METHODID_GET_DIVIDENDS_FOREIGN_ISSUER:
          serviceImpl.getDividendsForeignIssuer((ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetDividendsForeignIssuerResponse>) responseObserver);
          break;
        case METHODID_GET_OPERATIONS_BY_CURSOR:
          serviceImpl.getOperationsByCursor((ru.tinkoff.piapi.contract.v1.GetOperationsByCursorRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOperationsByCursorResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class OperationsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OperationsServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return ru.tinkoff.piapi.contract.v1.Operations.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OperationsService");
    }
  }

  private static final class OperationsServiceFileDescriptorSupplier
      extends OperationsServiceBaseDescriptorSupplier {
    OperationsServiceFileDescriptorSupplier() {}
  }

  private static final class OperationsServiceMethodDescriptorSupplier
      extends OperationsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    OperationsServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OperationsServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OperationsServiceFileDescriptorSupplier())
              .addMethod(getGetOperationsMethod())
              .addMethod(getGetPortfolioMethod())
              .addMethod(getGetPositionsMethod())
              .addMethod(getGetWithdrawLimitsMethod())
              .addMethod(getGetBrokerReportMethod())
              .addMethod(getGetDividendsForeignIssuerMethod())
              .addMethod(getGetOperationsByCursorMethod())
              .build();
        }
      }
    }
    return result;
  }
}
