/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.contract.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.tinkoff.piapi.contract.v1.MoneyValue;
import ru.tinkoff.piapi.contract.v1.MoneyValueOrBuilder;
import ru.tinkoff.piapi.contract.v1.OrderDirection;
import ru.tinkoff.piapi.contract.v1.OrderExecutionReportStatus;
import ru.tinkoff.piapi.contract.v1.OrderStage;
import ru.tinkoff.piapi.contract.v1.OrderStageOrBuilder;
import ru.tinkoff.piapi.contract.v1.OrderStateOrBuilder;
import ru.tinkoff.piapi.contract.v1.OrderType;
import ru.tinkoff.piapi.contract.v1.Orders;

public final class OrderState
extends GeneratedMessageV3
implements OrderStateOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int ORDER_ID_FIELD_NUMBER = 1;
    private volatile Object orderId_ = "";
    public static final int EXECUTION_REPORT_STATUS_FIELD_NUMBER = 2;
    private int executionReportStatus_ = 0;
    public static final int LOTS_REQUESTED_FIELD_NUMBER = 3;
    private long lotsRequested_ = 0L;
    public static final int LOTS_EXECUTED_FIELD_NUMBER = 4;
    private long lotsExecuted_ = 0L;
    public static final int INITIAL_ORDER_PRICE_FIELD_NUMBER = 5;
    private MoneyValue initialOrderPrice_;
    public static final int EXECUTED_ORDER_PRICE_FIELD_NUMBER = 6;
    private MoneyValue executedOrderPrice_;
    public static final int TOTAL_ORDER_AMOUNT_FIELD_NUMBER = 7;
    private MoneyValue totalOrderAmount_;
    public static final int AVERAGE_POSITION_PRICE_FIELD_NUMBER = 8;
    private MoneyValue averagePositionPrice_;
    public static final int INITIAL_COMMISSION_FIELD_NUMBER = 9;
    private MoneyValue initialCommission_;
    public static final int EXECUTED_COMMISSION_FIELD_NUMBER = 10;
    private MoneyValue executedCommission_;
    public static final int FIGI_FIELD_NUMBER = 11;
    private volatile Object figi_ = "";
    public static final int DIRECTION_FIELD_NUMBER = 12;
    private int direction_ = 0;
    public static final int INITIAL_SECURITY_PRICE_FIELD_NUMBER = 13;
    private MoneyValue initialSecurityPrice_;
    public static final int STAGES_FIELD_NUMBER = 14;
    private List<OrderStage> stages_;
    public static final int SERVICE_COMMISSION_FIELD_NUMBER = 15;
    private MoneyValue serviceCommission_;
    public static final int CURRENCY_FIELD_NUMBER = 16;
    private volatile Object currency_ = "";
    public static final int ORDER_TYPE_FIELD_NUMBER = 17;
    private int orderType_ = 0;
    public static final int ORDER_DATE_FIELD_NUMBER = 18;
    private Timestamp orderDate_;
    public static final int INSTRUMENT_UID_FIELD_NUMBER = 19;
    private volatile Object instrumentUid_ = "";
    public static final int ORDER_REQUEST_ID_FIELD_NUMBER = 20;
    private volatile Object orderRequestId_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final OrderState DEFAULT_INSTANCE = new OrderState();
    private static final Parser<OrderState> PARSER = new AbstractParser<OrderState>(){

        public OrderState parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = OrderState.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private OrderState(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private OrderState() {
        this.orderId_ = "";
        this.executionReportStatus_ = 0;
        this.figi_ = "";
        this.direction_ = 0;
        this.stages_ = Collections.emptyList();
        this.currency_ = "";
        this.orderType_ = 0;
        this.instrumentUid_ = "";
        this.orderRequestId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new OrderState();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Orders.internal_static_tinkoff_public_invest_api_contract_v1_OrderState_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Orders.internal_static_tinkoff_public_invest_api_contract_v1_OrderState_fieldAccessorTable.ensureFieldAccessorsInitialized(OrderState.class, Builder.class);
    }

    @Override
    public String getOrderId() {
        Object ref = this.orderId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orderId_ = s;
        return s;
    }

    @Override
    public ByteString getOrderIdBytes() {
        Object ref = this.orderId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orderId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getExecutionReportStatusValue() {
        return this.executionReportStatus_;
    }

    @Override
    public OrderExecutionReportStatus getExecutionReportStatus() {
        OrderExecutionReportStatus result = OrderExecutionReportStatus.forNumber(this.executionReportStatus_);
        return result == null ? OrderExecutionReportStatus.UNRECOGNIZED : result;
    }

    @Override
    public long getLotsRequested() {
        return this.lotsRequested_;
    }

    @Override
    public long getLotsExecuted() {
        return this.lotsExecuted_;
    }

    @Override
    public boolean hasInitialOrderPrice() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public MoneyValue getInitialOrderPrice() {
        return this.initialOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialOrderPrice_;
    }

    @Override
    public MoneyValueOrBuilder getInitialOrderPriceOrBuilder() {
        return this.initialOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialOrderPrice_;
    }

    @Override
    public boolean hasExecutedOrderPrice() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public MoneyValue getExecutedOrderPrice() {
        return this.executedOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.executedOrderPrice_;
    }

    @Override
    public MoneyValueOrBuilder getExecutedOrderPriceOrBuilder() {
        return this.executedOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.executedOrderPrice_;
    }

    @Override
    public boolean hasTotalOrderAmount() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public MoneyValue getTotalOrderAmount() {
        return this.totalOrderAmount_ == null ? MoneyValue.getDefaultInstance() : this.totalOrderAmount_;
    }

    @Override
    public MoneyValueOrBuilder getTotalOrderAmountOrBuilder() {
        return this.totalOrderAmount_ == null ? MoneyValue.getDefaultInstance() : this.totalOrderAmount_;
    }

    @Override
    public boolean hasAveragePositionPrice() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public MoneyValue getAveragePositionPrice() {
        return this.averagePositionPrice_ == null ? MoneyValue.getDefaultInstance() : this.averagePositionPrice_;
    }

    @Override
    public MoneyValueOrBuilder getAveragePositionPriceOrBuilder() {
        return this.averagePositionPrice_ == null ? MoneyValue.getDefaultInstance() : this.averagePositionPrice_;
    }

    @Override
    public boolean hasInitialCommission() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public MoneyValue getInitialCommission() {
        return this.initialCommission_ == null ? MoneyValue.getDefaultInstance() : this.initialCommission_;
    }

    @Override
    public MoneyValueOrBuilder getInitialCommissionOrBuilder() {
        return this.initialCommission_ == null ? MoneyValue.getDefaultInstance() : this.initialCommission_;
    }

    @Override
    public boolean hasExecutedCommission() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public MoneyValue getExecutedCommission() {
        return this.executedCommission_ == null ? MoneyValue.getDefaultInstance() : this.executedCommission_;
    }

    @Override
    public MoneyValueOrBuilder getExecutedCommissionOrBuilder() {
        return this.executedCommission_ == null ? MoneyValue.getDefaultInstance() : this.executedCommission_;
    }

    @Override
    public String getFigi() {
        Object ref = this.figi_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.figi_ = s;
        return s;
    }

    @Override
    public ByteString getFigiBytes() {
        Object ref = this.figi_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.figi_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getDirectionValue() {
        return this.direction_;
    }

    @Override
    public OrderDirection getDirection() {
        OrderDirection result = OrderDirection.forNumber(this.direction_);
        return result == null ? OrderDirection.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasInitialSecurityPrice() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public MoneyValue getInitialSecurityPrice() {
        return this.initialSecurityPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialSecurityPrice_;
    }

    @Override
    public MoneyValueOrBuilder getInitialSecurityPriceOrBuilder() {
        return this.initialSecurityPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialSecurityPrice_;
    }

    @Override
    public List<OrderStage> getStagesList() {
        return this.stages_;
    }

    @Override
    public List<? extends OrderStageOrBuilder> getStagesOrBuilderList() {
        return this.stages_;
    }

    @Override
    public int getStagesCount() {
        return this.stages_.size();
    }

    @Override
    public OrderStage getStages(int index) {
        return this.stages_.get(index);
    }

    @Override
    public OrderStageOrBuilder getStagesOrBuilder(int index) {
        return this.stages_.get(index);
    }

    @Override
    public boolean hasServiceCommission() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public MoneyValue getServiceCommission() {
        return this.serviceCommission_ == null ? MoneyValue.getDefaultInstance() : this.serviceCommission_;
    }

    @Override
    public MoneyValueOrBuilder getServiceCommissionOrBuilder() {
        return this.serviceCommission_ == null ? MoneyValue.getDefaultInstance() : this.serviceCommission_;
    }

    @Override
    public String getCurrency() {
        Object ref = this.currency_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currency_ = s;
        return s;
    }

    @Override
    public ByteString getCurrencyBytes() {
        Object ref = this.currency_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currency_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getOrderTypeValue() {
        return this.orderType_;
    }

    @Override
    public OrderType getOrderType() {
        OrderType result = OrderType.forNumber(this.orderType_);
        return result == null ? OrderType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasOrderDate() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public Timestamp getOrderDate() {
        return this.orderDate_ == null ? Timestamp.getDefaultInstance() : this.orderDate_;
    }

    @Override
    public TimestampOrBuilder getOrderDateOrBuilder() {
        return this.orderDate_ == null ? Timestamp.getDefaultInstance() : this.orderDate_;
    }

    @Override
    public String getInstrumentUid() {
        Object ref = this.instrumentUid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.instrumentUid_ = s;
        return s;
    }

    @Override
    public ByteString getInstrumentUidBytes() {
        Object ref = this.instrumentUid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.instrumentUid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOrderRequestId() {
        Object ref = this.orderRequestId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orderRequestId_ = s;
        return s;
    }

    @Override
    public ByteString getOrderRequestIdBytes() {
        Object ref = this.orderRequestId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orderRequestId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orderId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.orderId_);
        }
        if (this.executionReportStatus_ != OrderExecutionReportStatus.EXECUTION_REPORT_STATUS_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.executionReportStatus_);
        }
        if (this.lotsRequested_ != 0L) {
            output.writeInt64(3, this.lotsRequested_);
        }
        if (this.lotsExecuted_ != 0L) {
            output.writeInt64(4, this.lotsExecuted_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getInitialOrderPrice());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(6, (MessageLite)this.getExecutedOrderPrice());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(7, (MessageLite)this.getTotalOrderAmount());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(8, (MessageLite)this.getAveragePositionPrice());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(9, (MessageLite)this.getInitialCommission());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(10, (MessageLite)this.getExecutedCommission());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.figi_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.figi_);
        }
        if (this.direction_ != OrderDirection.ORDER_DIRECTION_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.direction_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(13, (MessageLite)this.getInitialSecurityPrice());
        }
        for (int i = 0; i < this.stages_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.stages_.get(i));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(15, (MessageLite)this.getServiceCommission());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currency_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.currency_);
        }
        if (this.orderType_ != OrderType.ORDER_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(17, this.orderType_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeMessage(18, (MessageLite)this.getOrderDate());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.instrumentUid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.instrumentUid_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orderRequestId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.orderRequestId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orderId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.orderId_);
        }
        if (this.executionReportStatus_ != OrderExecutionReportStatus.EXECUTION_REPORT_STATUS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.executionReportStatus_);
        }
        if (this.lotsRequested_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.lotsRequested_);
        }
        if (this.lotsExecuted_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.lotsExecuted_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getInitialOrderPrice());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getExecutedOrderPrice());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getTotalOrderAmount());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getAveragePositionPrice());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getInitialCommission());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getExecutedCommission());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.figi_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.figi_);
        }
        if (this.direction_ != OrderDirection.ORDER_DIRECTION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.direction_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getInitialSecurityPrice());
        }
        for (int i = 0; i < this.stages_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.stages_.get(i)));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getServiceCommission());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currency_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.currency_);
        }
        if (this.orderType_ != OrderType.ORDER_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)17, (int)this.orderType_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getOrderDate());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.instrumentUid_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.instrumentUid_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orderRequestId_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.orderRequestId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderState)) {
            return super.equals(obj);
        }
        OrderState other = (OrderState)obj;
        if (!this.getOrderId().equals(other.getOrderId())) {
            return false;
        }
        if (this.executionReportStatus_ != other.executionReportStatus_) {
            return false;
        }
        if (this.getLotsRequested() != other.getLotsRequested()) {
            return false;
        }
        if (this.getLotsExecuted() != other.getLotsExecuted()) {
            return false;
        }
        if (this.hasInitialOrderPrice() != other.hasInitialOrderPrice()) {
            return false;
        }
        if (this.hasInitialOrderPrice() && !this.getInitialOrderPrice().equals(other.getInitialOrderPrice())) {
            return false;
        }
        if (this.hasExecutedOrderPrice() != other.hasExecutedOrderPrice()) {
            return false;
        }
        if (this.hasExecutedOrderPrice() && !this.getExecutedOrderPrice().equals(other.getExecutedOrderPrice())) {
            return false;
        }
        if (this.hasTotalOrderAmount() != other.hasTotalOrderAmount()) {
            return false;
        }
        if (this.hasTotalOrderAmount() && !this.getTotalOrderAmount().equals(other.getTotalOrderAmount())) {
            return false;
        }
        if (this.hasAveragePositionPrice() != other.hasAveragePositionPrice()) {
            return false;
        }
        if (this.hasAveragePositionPrice() && !this.getAveragePositionPrice().equals(other.getAveragePositionPrice())) {
            return false;
        }
        if (this.hasInitialCommission() != other.hasInitialCommission()) {
            return false;
        }
        if (this.hasInitialCommission() && !this.getInitialCommission().equals(other.getInitialCommission())) {
            return false;
        }
        if (this.hasExecutedCommission() != other.hasExecutedCommission()) {
            return false;
        }
        if (this.hasExecutedCommission() && !this.getExecutedCommission().equals(other.getExecutedCommission())) {
            return false;
        }
        if (!this.getFigi().equals(other.getFigi())) {
            return false;
        }
        if (this.direction_ != other.direction_) {
            return false;
        }
        if (this.hasInitialSecurityPrice() != other.hasInitialSecurityPrice()) {
            return false;
        }
        if (this.hasInitialSecurityPrice() && !this.getInitialSecurityPrice().equals(other.getInitialSecurityPrice())) {
            return false;
        }
        if (!this.getStagesList().equals(other.getStagesList())) {
            return false;
        }
        if (this.hasServiceCommission() != other.hasServiceCommission()) {
            return false;
        }
        if (this.hasServiceCommission() && !this.getServiceCommission().equals(other.getServiceCommission())) {
            return false;
        }
        if (!this.getCurrency().equals(other.getCurrency())) {
            return false;
        }
        if (this.orderType_ != other.orderType_) {
            return false;
        }
        if (this.hasOrderDate() != other.hasOrderDate()) {
            return false;
        }
        if (this.hasOrderDate() && !this.getOrderDate().equals((Object)other.getOrderDate())) {
            return false;
        }
        if (!this.getInstrumentUid().equals(other.getInstrumentUid())) {
            return false;
        }
        if (!this.getOrderRequestId().equals(other.getOrderRequestId())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + OrderState.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getOrderId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.executionReportStatus_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getLotsRequested());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)this.getLotsExecuted());
        if (this.hasInitialOrderPrice()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getInitialOrderPrice().hashCode();
        }
        if (this.hasExecutedOrderPrice()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getExecutedOrderPrice().hashCode();
        }
        if (this.hasTotalOrderAmount()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getTotalOrderAmount().hashCode();
        }
        if (this.hasAveragePositionPrice()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAveragePositionPrice().hashCode();
        }
        if (this.hasInitialCommission()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getInitialCommission().hashCode();
        }
        if (this.hasExecutedCommission()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getExecutedCommission().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getFigi().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.direction_;
        if (this.hasInitialSecurityPrice()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getInitialSecurityPrice().hashCode();
        }
        if (this.getStagesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getStagesList().hashCode();
        }
        if (this.hasServiceCommission()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getServiceCommission().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getCurrency().hashCode();
        hash = 37 * hash + 17;
        hash = 53 * hash + this.orderType_;
        if (this.hasOrderDate()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getOrderDate().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getInstrumentUid().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getOrderRequestId().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static OrderState parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data);
    }

    public static OrderState parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OrderState parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data);
    }

    public static OrderState parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OrderState parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data);
    }

    public static OrderState parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrderState)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OrderState parseFrom(InputStream input) throws IOException {
        return (OrderState)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static OrderState parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrderState)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrderState parseDelimitedFrom(InputStream input) throws IOException {
        return (OrderState)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static OrderState parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrderState)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrderState parseFrom(CodedInputStream input) throws IOException {
        return (OrderState)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static OrderState parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrderState)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return OrderState.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OrderState prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static OrderState getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OrderState> parser() {
        return PARSER;
    }

    public Parser<OrderState> getParserForType() {
        return PARSER;
    }

    public OrderState getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements OrderStateOrBuilder {
        private int bitField0_;
        private Object orderId_ = "";
        private int executionReportStatus_ = 0;
        private long lotsRequested_;
        private long lotsExecuted_;
        private MoneyValue initialOrderPrice_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> initialOrderPriceBuilder_;
        private MoneyValue executedOrderPrice_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> executedOrderPriceBuilder_;
        private MoneyValue totalOrderAmount_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> totalOrderAmountBuilder_;
        private MoneyValue averagePositionPrice_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> averagePositionPriceBuilder_;
        private MoneyValue initialCommission_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> initialCommissionBuilder_;
        private MoneyValue executedCommission_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> executedCommissionBuilder_;
        private Object figi_ = "";
        private int direction_ = 0;
        private MoneyValue initialSecurityPrice_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> initialSecurityPriceBuilder_;
        private List<OrderStage> stages_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OrderStage, OrderStage.Builder, OrderStageOrBuilder> stagesBuilder_;
        private MoneyValue serviceCommission_;
        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> serviceCommissionBuilder_;
        private Object currency_ = "";
        private int orderType_ = 0;
        private Timestamp orderDate_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> orderDateBuilder_;
        private Object instrumentUid_ = "";
        private Object orderRequestId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return Orders.internal_static_tinkoff_public_invest_api_contract_v1_OrderState_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Orders.internal_static_tinkoff_public_invest_api_contract_v1_OrderState_fieldAccessorTable.ensureFieldAccessorsInitialized(OrderState.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getInitialOrderPriceFieldBuilder();
                this.getExecutedOrderPriceFieldBuilder();
                this.getTotalOrderAmountFieldBuilder();
                this.getAveragePositionPriceFieldBuilder();
                this.getInitialCommissionFieldBuilder();
                this.getExecutedCommissionFieldBuilder();
                this.getInitialSecurityPriceFieldBuilder();
                this.getStagesFieldBuilder();
                this.getServiceCommissionFieldBuilder();
                this.getOrderDateFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.orderId_ = "";
            this.executionReportStatus_ = 0;
            this.lotsRequested_ = 0L;
            this.lotsExecuted_ = 0L;
            this.initialOrderPrice_ = null;
            if (this.initialOrderPriceBuilder_ != null) {
                this.initialOrderPriceBuilder_.dispose();
                this.initialOrderPriceBuilder_ = null;
            }
            this.executedOrderPrice_ = null;
            if (this.executedOrderPriceBuilder_ != null) {
                this.executedOrderPriceBuilder_.dispose();
                this.executedOrderPriceBuilder_ = null;
            }
            this.totalOrderAmount_ = null;
            if (this.totalOrderAmountBuilder_ != null) {
                this.totalOrderAmountBuilder_.dispose();
                this.totalOrderAmountBuilder_ = null;
            }
            this.averagePositionPrice_ = null;
            if (this.averagePositionPriceBuilder_ != null) {
                this.averagePositionPriceBuilder_.dispose();
                this.averagePositionPriceBuilder_ = null;
            }
            this.initialCommission_ = null;
            if (this.initialCommissionBuilder_ != null) {
                this.initialCommissionBuilder_.dispose();
                this.initialCommissionBuilder_ = null;
            }
            this.executedCommission_ = null;
            if (this.executedCommissionBuilder_ != null) {
                this.executedCommissionBuilder_.dispose();
                this.executedCommissionBuilder_ = null;
            }
            this.figi_ = "";
            this.direction_ = 0;
            this.initialSecurityPrice_ = null;
            if (this.initialSecurityPriceBuilder_ != null) {
                this.initialSecurityPriceBuilder_.dispose();
                this.initialSecurityPriceBuilder_ = null;
            }
            if (this.stagesBuilder_ == null) {
                this.stages_ = Collections.emptyList();
            } else {
                this.stages_ = null;
                this.stagesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            this.serviceCommission_ = null;
            if (this.serviceCommissionBuilder_ != null) {
                this.serviceCommissionBuilder_.dispose();
                this.serviceCommissionBuilder_ = null;
            }
            this.currency_ = "";
            this.orderType_ = 0;
            this.orderDate_ = null;
            if (this.orderDateBuilder_ != null) {
                this.orderDateBuilder_.dispose();
                this.orderDateBuilder_ = null;
            }
            this.instrumentUid_ = "";
            this.orderRequestId_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Orders.internal_static_tinkoff_public_invest_api_contract_v1_OrderState_descriptor;
        }

        public OrderState getDefaultInstanceForType() {
            return OrderState.getDefaultInstance();
        }

        public OrderState build() {
            OrderState result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public OrderState buildPartial() {
            OrderState result = new OrderState(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(OrderState result) {
            if (this.stagesBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.stages_ = Collections.unmodifiableList(this.stages_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.stages_ = this.stages_;
            } else {
                result.stages_ = this.stagesBuilder_.build();
            }
        }

        private void buildPartial0(OrderState result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.orderId_ = this.orderId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.executionReportStatus_ = this.executionReportStatus_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.lotsRequested_ = this.lotsRequested_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.lotsExecuted_ = this.lotsExecuted_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.initialOrderPrice_ = this.initialOrderPriceBuilder_ == null ? this.initialOrderPrice_ : (MoneyValue)this.initialOrderPriceBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.executedOrderPrice_ = this.executedOrderPriceBuilder_ == null ? this.executedOrderPrice_ : (MoneyValue)this.executedOrderPriceBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.totalOrderAmount_ = this.totalOrderAmountBuilder_ == null ? this.totalOrderAmount_ : (MoneyValue)this.totalOrderAmountBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.averagePositionPrice_ = this.averagePositionPriceBuilder_ == null ? this.averagePositionPrice_ : (MoneyValue)this.averagePositionPriceBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.initialCommission_ = this.initialCommissionBuilder_ == null ? this.initialCommission_ : (MoneyValue)this.initialCommissionBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.executedCommission_ = this.executedCommissionBuilder_ == null ? this.executedCommission_ : (MoneyValue)this.executedCommissionBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.figi_ = this.figi_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.direction_ = this.direction_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.initialSecurityPrice_ = this.initialSecurityPriceBuilder_ == null ? this.initialSecurityPrice_ : (MoneyValue)this.initialSecurityPriceBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.serviceCommission_ = this.serviceCommissionBuilder_ == null ? this.serviceCommission_ : (MoneyValue)this.serviceCommissionBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.currency_ = this.currency_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.orderType_ = this.orderType_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.orderDate_ = this.orderDateBuilder_ == null ? this.orderDate_ : (Timestamp)this.orderDateBuilder_.build();
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.instrumentUid_ = this.instrumentUid_;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.orderRequestId_ = this.orderRequestId_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof OrderState) {
                return this.mergeFrom((OrderState)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(OrderState other) {
            if (other == OrderState.getDefaultInstance()) {
                return this;
            }
            if (!other.getOrderId().isEmpty()) {
                this.orderId_ = other.orderId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.executionReportStatus_ != 0) {
                this.setExecutionReportStatusValue(other.getExecutionReportStatusValue());
            }
            if (other.getLotsRequested() != 0L) {
                this.setLotsRequested(other.getLotsRequested());
            }
            if (other.getLotsExecuted() != 0L) {
                this.setLotsExecuted(other.getLotsExecuted());
            }
            if (other.hasInitialOrderPrice()) {
                this.mergeInitialOrderPrice(other.getInitialOrderPrice());
            }
            if (other.hasExecutedOrderPrice()) {
                this.mergeExecutedOrderPrice(other.getExecutedOrderPrice());
            }
            if (other.hasTotalOrderAmount()) {
                this.mergeTotalOrderAmount(other.getTotalOrderAmount());
            }
            if (other.hasAveragePositionPrice()) {
                this.mergeAveragePositionPrice(other.getAveragePositionPrice());
            }
            if (other.hasInitialCommission()) {
                this.mergeInitialCommission(other.getInitialCommission());
            }
            if (other.hasExecutedCommission()) {
                this.mergeExecutedCommission(other.getExecutedCommission());
            }
            if (!other.getFigi().isEmpty()) {
                this.figi_ = other.figi_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.direction_ != 0) {
                this.setDirectionValue(other.getDirectionValue());
            }
            if (other.hasInitialSecurityPrice()) {
                this.mergeInitialSecurityPrice(other.getInitialSecurityPrice());
            }
            if (this.stagesBuilder_ == null) {
                if (!other.stages_.isEmpty()) {
                    if (this.stages_.isEmpty()) {
                        this.stages_ = other.stages_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureStagesIsMutable();
                        this.stages_.addAll(other.stages_);
                    }
                    this.onChanged();
                }
            } else if (!other.stages_.isEmpty()) {
                if (this.stagesBuilder_.isEmpty()) {
                    this.stagesBuilder_.dispose();
                    this.stagesBuilder_ = null;
                    this.stages_ = other.stages_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.stagesBuilder_ = alwaysUseFieldBuilders ? this.getStagesFieldBuilder() : null;
                } else {
                    this.stagesBuilder_.addAllMessages(other.stages_);
                }
            }
            if (other.hasServiceCommission()) {
                this.mergeServiceCommission(other.getServiceCommission());
            }
            if (!other.getCurrency().isEmpty()) {
                this.currency_ = other.currency_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.orderType_ != 0) {
                this.setOrderTypeValue(other.getOrderTypeValue());
            }
            if (other.hasOrderDate()) {
                this.mergeOrderDate(other.getOrderDate());
            }
            if (!other.getInstrumentUid().isEmpty()) {
                this.instrumentUid_ = other.instrumentUid_;
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            if (!other.getOrderRequestId().isEmpty()) {
                this.orderRequestId_ = other.orderRequestId_;
                this.bitField0_ |= 0x80000;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block28: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block28;
                        }
                        case 10: {
                            this.orderId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block28;
                        }
                        case 16: {
                            this.executionReportStatus_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block28;
                        }
                        case 24: {
                            this.lotsRequested_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block28;
                        }
                        case 32: {
                            this.lotsExecuted_ = input.readInt64();
                            this.bitField0_ |= 8;
                            continue block28;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getInitialOrderPriceFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block28;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getExecutedOrderPriceFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block28;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getTotalOrderAmountFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block28;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getAveragePositionPriceFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block28;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getInitialCommissionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block28;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getExecutedCommissionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block28;
                        }
                        case 90: {
                            this.figi_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block28;
                        }
                        case 96: {
                            this.direction_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block28;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getInitialSecurityPriceFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block28;
                        }
                        case 114: {
                            OrderStage m = (OrderStage)input.readMessage(OrderStage.parser(), extensionRegistry);
                            if (this.stagesBuilder_ == null) {
                                this.ensureStagesIsMutable();
                                this.stages_.add(m);
                                continue block28;
                            }
                            this.stagesBuilder_.addMessage((AbstractMessage)m);
                            continue block28;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getServiceCommissionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block28;
                        }
                        case 130: {
                            this.currency_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block28;
                        }
                        case 136: {
                            this.orderType_ = input.readEnum();
                            this.bitField0_ |= 0x10000;
                            continue block28;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getOrderDateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block28;
                        }
                        case 154: {
                            this.instrumentUid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40000;
                            continue block28;
                        }
                        case 162: {
                            this.orderRequestId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80000;
                            continue block28;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getOrderId() {
            Object ref = this.orderId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orderId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrderIdBytes() {
            Object ref = this.orderId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orderId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrderId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orderId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearOrderId() {
            this.orderId_ = OrderState.getDefaultInstance().getOrderId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setOrderIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OrderState.checkByteStringIsUtf8((ByteString)value);
            this.orderId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getExecutionReportStatusValue() {
            return this.executionReportStatus_;
        }

        public Builder setExecutionReportStatusValue(int value) {
            this.executionReportStatus_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public OrderExecutionReportStatus getExecutionReportStatus() {
            OrderExecutionReportStatus result = OrderExecutionReportStatus.forNumber(this.executionReportStatus_);
            return result == null ? OrderExecutionReportStatus.UNRECOGNIZED : result;
        }

        public Builder setExecutionReportStatus(OrderExecutionReportStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.executionReportStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearExecutionReportStatus() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.executionReportStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getLotsRequested() {
            return this.lotsRequested_;
        }

        public Builder setLotsRequested(long value) {
            this.lotsRequested_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearLotsRequested() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.lotsRequested_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getLotsExecuted() {
            return this.lotsExecuted_;
        }

        public Builder setLotsExecuted(long value) {
            this.lotsExecuted_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearLotsExecuted() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.lotsExecuted_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasInitialOrderPrice() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public MoneyValue getInitialOrderPrice() {
            if (this.initialOrderPriceBuilder_ == null) {
                return this.initialOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialOrderPrice_;
            }
            return (MoneyValue)this.initialOrderPriceBuilder_.getMessage();
        }

        public Builder setInitialOrderPrice(MoneyValue value) {
            if (this.initialOrderPriceBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.initialOrderPrice_ = value;
            } else {
                this.initialOrderPriceBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setInitialOrderPrice(MoneyValue.Builder builderForValue) {
            if (this.initialOrderPriceBuilder_ == null) {
                this.initialOrderPrice_ = builderForValue.build();
            } else {
                this.initialOrderPriceBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeInitialOrderPrice(MoneyValue value) {
            if (this.initialOrderPriceBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.initialOrderPrice_ != null && this.initialOrderPrice_ != MoneyValue.getDefaultInstance()) {
                    this.getInitialOrderPriceBuilder().mergeFrom(value);
                } else {
                    this.initialOrderPrice_ = value;
                }
            } else {
                this.initialOrderPriceBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.initialOrderPrice_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInitialOrderPrice() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.initialOrderPrice_ = null;
            if (this.initialOrderPriceBuilder_ != null) {
                this.initialOrderPriceBuilder_.dispose();
                this.initialOrderPriceBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getInitialOrderPriceBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (MoneyValue.Builder)this.getInitialOrderPriceFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getInitialOrderPriceOrBuilder() {
            if (this.initialOrderPriceBuilder_ != null) {
                return (MoneyValueOrBuilder)this.initialOrderPriceBuilder_.getMessageOrBuilder();
            }
            return this.initialOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialOrderPrice_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getInitialOrderPriceFieldBuilder() {
            if (this.initialOrderPriceBuilder_ == null) {
                this.initialOrderPriceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInitialOrderPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.initialOrderPrice_ = null;
            }
            return this.initialOrderPriceBuilder_;
        }

        @Override
        public boolean hasExecutedOrderPrice() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public MoneyValue getExecutedOrderPrice() {
            if (this.executedOrderPriceBuilder_ == null) {
                return this.executedOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.executedOrderPrice_;
            }
            return (MoneyValue)this.executedOrderPriceBuilder_.getMessage();
        }

        public Builder setExecutedOrderPrice(MoneyValue value) {
            if (this.executedOrderPriceBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.executedOrderPrice_ = value;
            } else {
                this.executedOrderPriceBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setExecutedOrderPrice(MoneyValue.Builder builderForValue) {
            if (this.executedOrderPriceBuilder_ == null) {
                this.executedOrderPrice_ = builderForValue.build();
            } else {
                this.executedOrderPriceBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeExecutedOrderPrice(MoneyValue value) {
            if (this.executedOrderPriceBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.executedOrderPrice_ != null && this.executedOrderPrice_ != MoneyValue.getDefaultInstance()) {
                    this.getExecutedOrderPriceBuilder().mergeFrom(value);
                } else {
                    this.executedOrderPrice_ = value;
                }
            } else {
                this.executedOrderPriceBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.executedOrderPrice_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExecutedOrderPrice() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.executedOrderPrice_ = null;
            if (this.executedOrderPriceBuilder_ != null) {
                this.executedOrderPriceBuilder_.dispose();
                this.executedOrderPriceBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getExecutedOrderPriceBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (MoneyValue.Builder)this.getExecutedOrderPriceFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getExecutedOrderPriceOrBuilder() {
            if (this.executedOrderPriceBuilder_ != null) {
                return (MoneyValueOrBuilder)this.executedOrderPriceBuilder_.getMessageOrBuilder();
            }
            return this.executedOrderPrice_ == null ? MoneyValue.getDefaultInstance() : this.executedOrderPrice_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getExecutedOrderPriceFieldBuilder() {
            if (this.executedOrderPriceBuilder_ == null) {
                this.executedOrderPriceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExecutedOrderPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.executedOrderPrice_ = null;
            }
            return this.executedOrderPriceBuilder_;
        }

        @Override
        public boolean hasTotalOrderAmount() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public MoneyValue getTotalOrderAmount() {
            if (this.totalOrderAmountBuilder_ == null) {
                return this.totalOrderAmount_ == null ? MoneyValue.getDefaultInstance() : this.totalOrderAmount_;
            }
            return (MoneyValue)this.totalOrderAmountBuilder_.getMessage();
        }

        public Builder setTotalOrderAmount(MoneyValue value) {
            if (this.totalOrderAmountBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.totalOrderAmount_ = value;
            } else {
                this.totalOrderAmountBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setTotalOrderAmount(MoneyValue.Builder builderForValue) {
            if (this.totalOrderAmountBuilder_ == null) {
                this.totalOrderAmount_ = builderForValue.build();
            } else {
                this.totalOrderAmountBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeTotalOrderAmount(MoneyValue value) {
            if (this.totalOrderAmountBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.totalOrderAmount_ != null && this.totalOrderAmount_ != MoneyValue.getDefaultInstance()) {
                    this.getTotalOrderAmountBuilder().mergeFrom(value);
                } else {
                    this.totalOrderAmount_ = value;
                }
            } else {
                this.totalOrderAmountBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.totalOrderAmount_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTotalOrderAmount() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.totalOrderAmount_ = null;
            if (this.totalOrderAmountBuilder_ != null) {
                this.totalOrderAmountBuilder_.dispose();
                this.totalOrderAmountBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getTotalOrderAmountBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (MoneyValue.Builder)this.getTotalOrderAmountFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getTotalOrderAmountOrBuilder() {
            if (this.totalOrderAmountBuilder_ != null) {
                return (MoneyValueOrBuilder)this.totalOrderAmountBuilder_.getMessageOrBuilder();
            }
            return this.totalOrderAmount_ == null ? MoneyValue.getDefaultInstance() : this.totalOrderAmount_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getTotalOrderAmountFieldBuilder() {
            if (this.totalOrderAmountBuilder_ == null) {
                this.totalOrderAmountBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTotalOrderAmount(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.totalOrderAmount_ = null;
            }
            return this.totalOrderAmountBuilder_;
        }

        @Override
        public boolean hasAveragePositionPrice() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public MoneyValue getAveragePositionPrice() {
            if (this.averagePositionPriceBuilder_ == null) {
                return this.averagePositionPrice_ == null ? MoneyValue.getDefaultInstance() : this.averagePositionPrice_;
            }
            return (MoneyValue)this.averagePositionPriceBuilder_.getMessage();
        }

        public Builder setAveragePositionPrice(MoneyValue value) {
            if (this.averagePositionPriceBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.averagePositionPrice_ = value;
            } else {
                this.averagePositionPriceBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setAveragePositionPrice(MoneyValue.Builder builderForValue) {
            if (this.averagePositionPriceBuilder_ == null) {
                this.averagePositionPrice_ = builderForValue.build();
            } else {
                this.averagePositionPriceBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeAveragePositionPrice(MoneyValue value) {
            if (this.averagePositionPriceBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.averagePositionPrice_ != null && this.averagePositionPrice_ != MoneyValue.getDefaultInstance()) {
                    this.getAveragePositionPriceBuilder().mergeFrom(value);
                } else {
                    this.averagePositionPrice_ = value;
                }
            } else {
                this.averagePositionPriceBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.averagePositionPrice_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAveragePositionPrice() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.averagePositionPrice_ = null;
            if (this.averagePositionPriceBuilder_ != null) {
                this.averagePositionPriceBuilder_.dispose();
                this.averagePositionPriceBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getAveragePositionPriceBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (MoneyValue.Builder)this.getAveragePositionPriceFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getAveragePositionPriceOrBuilder() {
            if (this.averagePositionPriceBuilder_ != null) {
                return (MoneyValueOrBuilder)this.averagePositionPriceBuilder_.getMessageOrBuilder();
            }
            return this.averagePositionPrice_ == null ? MoneyValue.getDefaultInstance() : this.averagePositionPrice_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getAveragePositionPriceFieldBuilder() {
            if (this.averagePositionPriceBuilder_ == null) {
                this.averagePositionPriceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAveragePositionPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.averagePositionPrice_ = null;
            }
            return this.averagePositionPriceBuilder_;
        }

        @Override
        public boolean hasInitialCommission() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public MoneyValue getInitialCommission() {
            if (this.initialCommissionBuilder_ == null) {
                return this.initialCommission_ == null ? MoneyValue.getDefaultInstance() : this.initialCommission_;
            }
            return (MoneyValue)this.initialCommissionBuilder_.getMessage();
        }

        public Builder setInitialCommission(MoneyValue value) {
            if (this.initialCommissionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.initialCommission_ = value;
            } else {
                this.initialCommissionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setInitialCommission(MoneyValue.Builder builderForValue) {
            if (this.initialCommissionBuilder_ == null) {
                this.initialCommission_ = builderForValue.build();
            } else {
                this.initialCommissionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeInitialCommission(MoneyValue value) {
            if (this.initialCommissionBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.initialCommission_ != null && this.initialCommission_ != MoneyValue.getDefaultInstance()) {
                    this.getInitialCommissionBuilder().mergeFrom(value);
                } else {
                    this.initialCommission_ = value;
                }
            } else {
                this.initialCommissionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.initialCommission_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInitialCommission() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.initialCommission_ = null;
            if (this.initialCommissionBuilder_ != null) {
                this.initialCommissionBuilder_.dispose();
                this.initialCommissionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getInitialCommissionBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (MoneyValue.Builder)this.getInitialCommissionFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getInitialCommissionOrBuilder() {
            if (this.initialCommissionBuilder_ != null) {
                return (MoneyValueOrBuilder)this.initialCommissionBuilder_.getMessageOrBuilder();
            }
            return this.initialCommission_ == null ? MoneyValue.getDefaultInstance() : this.initialCommission_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getInitialCommissionFieldBuilder() {
            if (this.initialCommissionBuilder_ == null) {
                this.initialCommissionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInitialCommission(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.initialCommission_ = null;
            }
            return this.initialCommissionBuilder_;
        }

        @Override
        public boolean hasExecutedCommission() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public MoneyValue getExecutedCommission() {
            if (this.executedCommissionBuilder_ == null) {
                return this.executedCommission_ == null ? MoneyValue.getDefaultInstance() : this.executedCommission_;
            }
            return (MoneyValue)this.executedCommissionBuilder_.getMessage();
        }

        public Builder setExecutedCommission(MoneyValue value) {
            if (this.executedCommissionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.executedCommission_ = value;
            } else {
                this.executedCommissionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setExecutedCommission(MoneyValue.Builder builderForValue) {
            if (this.executedCommissionBuilder_ == null) {
                this.executedCommission_ = builderForValue.build();
            } else {
                this.executedCommissionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeExecutedCommission(MoneyValue value) {
            if (this.executedCommissionBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.executedCommission_ != null && this.executedCommission_ != MoneyValue.getDefaultInstance()) {
                    this.getExecutedCommissionBuilder().mergeFrom(value);
                } else {
                    this.executedCommission_ = value;
                }
            } else {
                this.executedCommissionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.executedCommission_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExecutedCommission() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.executedCommission_ = null;
            if (this.executedCommissionBuilder_ != null) {
                this.executedCommissionBuilder_.dispose();
                this.executedCommissionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getExecutedCommissionBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (MoneyValue.Builder)this.getExecutedCommissionFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getExecutedCommissionOrBuilder() {
            if (this.executedCommissionBuilder_ != null) {
                return (MoneyValueOrBuilder)this.executedCommissionBuilder_.getMessageOrBuilder();
            }
            return this.executedCommission_ == null ? MoneyValue.getDefaultInstance() : this.executedCommission_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getExecutedCommissionFieldBuilder() {
            if (this.executedCommissionBuilder_ == null) {
                this.executedCommissionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExecutedCommission(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.executedCommission_ = null;
            }
            return this.executedCommissionBuilder_;
        }

        @Override
        public String getFigi() {
            Object ref = this.figi_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.figi_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFigiBytes() {
            Object ref = this.figi_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.figi_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFigi(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.figi_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearFigi() {
            this.figi_ = OrderState.getDefaultInstance().getFigi();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setFigiBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OrderState.checkByteStringIsUtf8((ByteString)value);
            this.figi_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public int getDirectionValue() {
            return this.direction_;
        }

        public Builder setDirectionValue(int value) {
            this.direction_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public OrderDirection getDirection() {
            OrderDirection result = OrderDirection.forNumber(this.direction_);
            return result == null ? OrderDirection.UNRECOGNIZED : result;
        }

        public Builder setDirection(OrderDirection value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.direction_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDirection() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.direction_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasInitialSecurityPrice() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public MoneyValue getInitialSecurityPrice() {
            if (this.initialSecurityPriceBuilder_ == null) {
                return this.initialSecurityPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialSecurityPrice_;
            }
            return (MoneyValue)this.initialSecurityPriceBuilder_.getMessage();
        }

        public Builder setInitialSecurityPrice(MoneyValue value) {
            if (this.initialSecurityPriceBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.initialSecurityPrice_ = value;
            } else {
                this.initialSecurityPriceBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setInitialSecurityPrice(MoneyValue.Builder builderForValue) {
            if (this.initialSecurityPriceBuilder_ == null) {
                this.initialSecurityPrice_ = builderForValue.build();
            } else {
                this.initialSecurityPriceBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeInitialSecurityPrice(MoneyValue value) {
            if (this.initialSecurityPriceBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.initialSecurityPrice_ != null && this.initialSecurityPrice_ != MoneyValue.getDefaultInstance()) {
                    this.getInitialSecurityPriceBuilder().mergeFrom(value);
                } else {
                    this.initialSecurityPrice_ = value;
                }
            } else {
                this.initialSecurityPriceBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.initialSecurityPrice_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInitialSecurityPrice() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.initialSecurityPrice_ = null;
            if (this.initialSecurityPriceBuilder_ != null) {
                this.initialSecurityPriceBuilder_.dispose();
                this.initialSecurityPriceBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getInitialSecurityPriceBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (MoneyValue.Builder)this.getInitialSecurityPriceFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getInitialSecurityPriceOrBuilder() {
            if (this.initialSecurityPriceBuilder_ != null) {
                return (MoneyValueOrBuilder)this.initialSecurityPriceBuilder_.getMessageOrBuilder();
            }
            return this.initialSecurityPrice_ == null ? MoneyValue.getDefaultInstance() : this.initialSecurityPrice_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getInitialSecurityPriceFieldBuilder() {
            if (this.initialSecurityPriceBuilder_ == null) {
                this.initialSecurityPriceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInitialSecurityPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.initialSecurityPrice_ = null;
            }
            return this.initialSecurityPriceBuilder_;
        }

        private void ensureStagesIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.stages_ = new ArrayList<OrderStage>(this.stages_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<OrderStage> getStagesList() {
            if (this.stagesBuilder_ == null) {
                return Collections.unmodifiableList(this.stages_);
            }
            return this.stagesBuilder_.getMessageList();
        }

        @Override
        public int getStagesCount() {
            if (this.stagesBuilder_ == null) {
                return this.stages_.size();
            }
            return this.stagesBuilder_.getCount();
        }

        @Override
        public OrderStage getStages(int index) {
            if (this.stagesBuilder_ == null) {
                return this.stages_.get(index);
            }
            return (OrderStage)this.stagesBuilder_.getMessage(index);
        }

        public Builder setStages(int index, OrderStage value) {
            if (this.stagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStagesIsMutable();
                this.stages_.set(index, value);
                this.onChanged();
            } else {
                this.stagesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setStages(int index, OrderStage.Builder builderForValue) {
            if (this.stagesBuilder_ == null) {
                this.ensureStagesIsMutable();
                this.stages_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.stagesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStages(OrderStage value) {
            if (this.stagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStagesIsMutable();
                this.stages_.add(value);
                this.onChanged();
            } else {
                this.stagesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addStages(int index, OrderStage value) {
            if (this.stagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStagesIsMutable();
                this.stages_.add(index, value);
                this.onChanged();
            } else {
                this.stagesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addStages(OrderStage.Builder builderForValue) {
            if (this.stagesBuilder_ == null) {
                this.ensureStagesIsMutable();
                this.stages_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.stagesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStages(int index, OrderStage.Builder builderForValue) {
            if (this.stagesBuilder_ == null) {
                this.ensureStagesIsMutable();
                this.stages_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.stagesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllStages(Iterable<? extends OrderStage> values) {
            if (this.stagesBuilder_ == null) {
                this.ensureStagesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.stages_);
                this.onChanged();
            } else {
                this.stagesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearStages() {
            if (this.stagesBuilder_ == null) {
                this.stages_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.stagesBuilder_.clear();
            }
            return this;
        }

        public Builder removeStages(int index) {
            if (this.stagesBuilder_ == null) {
                this.ensureStagesIsMutable();
                this.stages_.remove(index);
                this.onChanged();
            } else {
                this.stagesBuilder_.remove(index);
            }
            return this;
        }

        public OrderStage.Builder getStagesBuilder(int index) {
            return (OrderStage.Builder)this.getStagesFieldBuilder().getBuilder(index);
        }

        @Override
        public OrderStageOrBuilder getStagesOrBuilder(int index) {
            if (this.stagesBuilder_ == null) {
                return this.stages_.get(index);
            }
            return (OrderStageOrBuilder)this.stagesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OrderStageOrBuilder> getStagesOrBuilderList() {
            if (this.stagesBuilder_ != null) {
                return this.stagesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.stages_);
        }

        public OrderStage.Builder addStagesBuilder() {
            return (OrderStage.Builder)this.getStagesFieldBuilder().addBuilder((AbstractMessage)OrderStage.getDefaultInstance());
        }

        public OrderStage.Builder addStagesBuilder(int index) {
            return (OrderStage.Builder)this.getStagesFieldBuilder().addBuilder(index, (AbstractMessage)OrderStage.getDefaultInstance());
        }

        public List<OrderStage.Builder> getStagesBuilderList() {
            return this.getStagesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OrderStage, OrderStage.Builder, OrderStageOrBuilder> getStagesFieldBuilder() {
            if (this.stagesBuilder_ == null) {
                this.stagesBuilder_ = new RepeatedFieldBuilderV3(this.stages_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.stages_ = null;
            }
            return this.stagesBuilder_;
        }

        @Override
        public boolean hasServiceCommission() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public MoneyValue getServiceCommission() {
            if (this.serviceCommissionBuilder_ == null) {
                return this.serviceCommission_ == null ? MoneyValue.getDefaultInstance() : this.serviceCommission_;
            }
            return (MoneyValue)this.serviceCommissionBuilder_.getMessage();
        }

        public Builder setServiceCommission(MoneyValue value) {
            if (this.serviceCommissionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.serviceCommission_ = value;
            } else {
                this.serviceCommissionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setServiceCommission(MoneyValue.Builder builderForValue) {
            if (this.serviceCommissionBuilder_ == null) {
                this.serviceCommission_ = builderForValue.build();
            } else {
                this.serviceCommissionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergeServiceCommission(MoneyValue value) {
            if (this.serviceCommissionBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.serviceCommission_ != null && this.serviceCommission_ != MoneyValue.getDefaultInstance()) {
                    this.getServiceCommissionBuilder().mergeFrom(value);
                } else {
                    this.serviceCommission_ = value;
                }
            } else {
                this.serviceCommissionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.serviceCommission_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearServiceCommission() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.serviceCommission_ = null;
            if (this.serviceCommissionBuilder_ != null) {
                this.serviceCommissionBuilder_.dispose();
                this.serviceCommissionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MoneyValue.Builder getServiceCommissionBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (MoneyValue.Builder)this.getServiceCommissionFieldBuilder().getBuilder();
        }

        @Override
        public MoneyValueOrBuilder getServiceCommissionOrBuilder() {
            if (this.serviceCommissionBuilder_ != null) {
                return (MoneyValueOrBuilder)this.serviceCommissionBuilder_.getMessageOrBuilder();
            }
            return this.serviceCommission_ == null ? MoneyValue.getDefaultInstance() : this.serviceCommission_;
        }

        private SingleFieldBuilderV3<MoneyValue, MoneyValue.Builder, MoneyValueOrBuilder> getServiceCommissionFieldBuilder() {
            if (this.serviceCommissionBuilder_ == null) {
                this.serviceCommissionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getServiceCommission(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.serviceCommission_ = null;
            }
            return this.serviceCommissionBuilder_;
        }

        @Override
        public String getCurrency() {
            Object ref = this.currency_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currency_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrencyBytes() {
            Object ref = this.currency_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currency_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrency(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currency_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearCurrency() {
            this.currency_ = OrderState.getDefaultInstance().getCurrency();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setCurrencyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OrderState.checkByteStringIsUtf8((ByteString)value);
            this.currency_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public int getOrderTypeValue() {
            return this.orderType_;
        }

        public Builder setOrderTypeValue(int value) {
            this.orderType_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        @Override
        public OrderType getOrderType() {
            OrderType result = OrderType.forNumber(this.orderType_);
            return result == null ? OrderType.UNRECOGNIZED : result;
        }

        public Builder setOrderType(OrderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10000;
            this.orderType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearOrderType() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.orderType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasOrderDate() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public Timestamp getOrderDate() {
            if (this.orderDateBuilder_ == null) {
                return this.orderDate_ == null ? Timestamp.getDefaultInstance() : this.orderDate_;
            }
            return (Timestamp)this.orderDateBuilder_.getMessage();
        }

        public Builder setOrderDate(Timestamp value) {
            if (this.orderDateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.orderDate_ = value;
            } else {
                this.orderDateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setOrderDate(Timestamp.Builder builderForValue) {
            if (this.orderDateBuilder_ == null) {
                this.orderDate_ = builderForValue.build();
            } else {
                this.orderDateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeOrderDate(Timestamp value) {
            if (this.orderDateBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.orderDate_ != null && this.orderDate_ != Timestamp.getDefaultInstance()) {
                    this.getOrderDateBuilder().mergeFrom(value);
                } else {
                    this.orderDate_ = value;
                }
            } else {
                this.orderDateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.orderDate_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearOrderDate() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.orderDate_ = null;
            if (this.orderDateBuilder_ != null) {
                this.orderDateBuilder_.dispose();
                this.orderDateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getOrderDateBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (Timestamp.Builder)this.getOrderDateFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getOrderDateOrBuilder() {
            if (this.orderDateBuilder_ != null) {
                return (TimestampOrBuilder)this.orderDateBuilder_.getMessageOrBuilder();
            }
            return this.orderDate_ == null ? Timestamp.getDefaultInstance() : this.orderDate_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getOrderDateFieldBuilder() {
            if (this.orderDateBuilder_ == null) {
                this.orderDateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOrderDate(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.orderDate_ = null;
            }
            return this.orderDateBuilder_;
        }

        @Override
        public String getInstrumentUid() {
            Object ref = this.instrumentUid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.instrumentUid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getInstrumentUidBytes() {
            Object ref = this.instrumentUid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.instrumentUid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setInstrumentUid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.instrumentUid_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearInstrumentUid() {
            this.instrumentUid_ = OrderState.getDefaultInstance().getInstrumentUid();
            this.bitField0_ &= 0xFFFBFFFF;
            this.onChanged();
            return this;
        }

        public Builder setInstrumentUidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OrderState.checkByteStringIsUtf8((ByteString)value);
            this.instrumentUid_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Override
        public String getOrderRequestId() {
            Object ref = this.orderRequestId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orderRequestId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrderRequestIdBytes() {
            Object ref = this.orderRequestId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orderRequestId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrderRequestId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orderRequestId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder clearOrderRequestId() {
            this.orderRequestId_ = OrderState.getDefaultInstance().getOrderRequestId();
            this.bitField0_ &= 0xFFF7FFFF;
            this.onChanged();
            return this;
        }

        public Builder setOrderRequestIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OrderState.checkByteStringIsUtf8((ByteString)value);
            this.orderRequestId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

