/*
 * Decompiled with CFR 0.152.
 */
package ru.trylogic.maven.plugins.redis;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import redis.server.netty.RedisCommandDecoder;
import redis.server.netty.RedisCommandHandler;
import redis.server.netty.RedisReplyEncoder;
import redis.server.netty.RedisServer;
import redis.server.netty.SimpleRedisServer;

@Mojo(name="run", defaultPhase=LifecyclePhase.NONE)
public class RunRedisMojo
extends AbstractMojo {
    public static final String REDIS_GROUP_CONTEXT_PROPERTY_NAME = RunRedisMojo.class.getName() + ":redisGroup";
    @Parameter(property="redis.server.port", defaultValue="6379")
    public Integer port;
    @Parameter(property="redis.server.forked", defaultValue="false")
    public boolean forked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        final RedisCommandHandler commandHandler = new RedisCommandHandler((RedisServer)new SimpleRedisServer());
        final DefaultEventExecutorGroup redisGroup = new DefaultEventExecutorGroup(1);
        this.getPluginContext().put(REDIS_GROUP_CONTEXT_PROPERTY_NAME, redisGroup);
        ServerBootstrap redisServerBootstrap = new ServerBootstrap();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)redisServerBootstrap.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).localAddress(this.port.intValue())).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new RedisCommandDecoder()});
                    p.addLast(new ChannelHandler[]{new RedisReplyEncoder()});
                    p.addLast((EventExecutorGroup)redisGroup, new ChannelHandler[]{commandHandler});
                }
            });
            this.getLog().info((CharSequence)("Starting Redis(forked=" + this.forked + ", port=" + this.port + ") server..."));
            ChannelFuture future = redisServerBootstrap.bind();
            try {
                if (!this.forked) {
                    ChannelFuture syncFuture = future.sync();
                    syncFuture.channel().closeFuture().sync();
                }
            }
            catch (InterruptedException e) {
                this.getLog().info((Throwable)e);
                redisGroup.shutdownGracefully();
            }
        }
        finally {
            if (!this.forked) {
                redisGroup.shutdownGracefully();
            }
        }
    }
}

