/*
 * Decompiled with CFR 0.152.
 */
package ru.vasiand.spring.boot.log4jdbc;

import jakarta.annotation.PostConstruct;
import javax.sql.DataSource;
import net.sf.log4jdbc.log.slf4j.Slf4jSpyLogDelegator;
import net.sf.log4jdbc.sql.jdbcapi.DataSourceSpy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.env.Environment;
import ru.vasiand.spring.boot.log4jdbc.Log4jdbcProperties;

public class Log4jdbcBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            return new DataSourceSpy((DataSource)bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @PostConstruct
    public void postConstruct() {
        for (String property : Log4jdbcProperties.PROPERTIES) {
            if (!this.environment.containsProperty(property)) continue;
            System.setProperty(property, this.environment.getRequiredProperty(property));
        }
        System.setProperty("log4jdbc.spylogdelegator.name", this.environment.getProperty("log4jdbc.spylogdelegator.name", Slf4jSpyLogDelegator.class.getName()));
    }
}

