/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.hook;

import java.util.LinkedHashSet;
import java.util.Set;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;

public final class ConfigurationHooksSupport {
    private static final ThreadLocal<Set<GuiceyConfigurationHook>> HOOKS = new ThreadLocal();

    private ConfigurationHooksSupport() {
    }

    public static void register(GuiceyConfigurationHook hook) {
        if (HOOKS.get() == null) {
            HOOKS.set(new LinkedHashSet());
        }
        HOOKS.get().add(hook);
    }

    public static void reset() {
        HOOKS.remove();
    }

    public static Set<GuiceyConfigurationHook> run(GuiceBundle.Builder builder) {
        Set<GuiceyConfigurationHook> hooks = HOOKS.get();
        if (hooks != null) {
            hooks.forEach(l -> l.configure(builder));
        }
        ConfigurationHooksSupport.reset();
        return hooks;
    }

    public static int count() {
        return HOOKS.get() != null ? HOOKS.get().size() : 0;
    }
}

