/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.common.collect.Sets;
import com.google.inject.Module;
import io.dropwizard.cli.Command;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.option.OptionsInfo;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsInfo;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyConfigurationInfo {
    private final ConfigurationInfo context;
    private final StatsInfo stats;
    private final OptionsInfo options;
    private final ExtensionsHolder holder;
    private final ConfigurationTree configurationTree;

    @Inject
    public GuiceyConfigurationInfo(ConfigurationInfo context, StatsInfo stats, OptionsInfo options, ExtensionsHolder holder, ConfigurationTree configurationTree) {
        this.context = context;
        this.stats = stats;
        this.options = options;
        this.holder = holder;
        this.configurationTree = configurationTree;
    }

    public ConfigurationInfo getData() {
        return this.context;
    }

    public StatsInfo getStats() {
        return this.stats;
    }

    public OptionsInfo getOptions() {
        return this.options;
    }

    public ConfigurationTree getConfigurationTree() {
        return this.configurationTree;
    }

    public List<Class<Object>> getItemsByScope(ConfigScope specialScope) {
        return this.getItemsByScope(specialScope.getType());
    }

    public List<Class<Object>> getItemsByScope(Class<?> scope) {
        return this.context.getItems(Filters.enabled().and(Filters.registeredBy(scope)));
    }

    public Set<Class<?>> getActiveScopes() {
        return this.getActiveScopes(true);
    }

    public Set<Class<?>> getActiveScopes(boolean countDisables) {
        HashSet res = Sets.newHashSet();
        this.context.getItems(it -> {
            res.addAll(it.getRegisteredBy());
            if (countDisables && it instanceof DisableSupport) {
                res.addAll(((DisableSupport)((Object)it)).getDisabledBy());
            }
            return true;
        });
        return res;
    }

    public List<Class<Command>> getCommands() {
        return this.context.getItems(ConfigItem.Command);
    }

    public List<Class<GuiceyBundle>> getBundles() {
        return this.context.getItems(ConfigItem.Bundle, Filters.enabled());
    }

    public List<Class<GuiceyBundle>> getBundlesFromLookup() {
        return this.context.getItems(ConfigItem.Bundle, Filters.lookupBundles());
    }

    public List<Class<GuiceyBundle>> getBundlesFromDw() {
        return this.context.getItems(ConfigItem.Bundle, Filters.dwBundles());
    }

    public List<Class<GuiceyBundle>> getDirectBundles() {
        return this.context.getItems(ConfigItem.Bundle, Filters.enabled().and(Filters.transitiveBundles().negate()));
    }

    public List<Class<GuiceyBundle>> getBundlesDisabled() {
        return this.context.getItems(ConfigItem.Bundle, Filters.enabled().negate());
    }

    public List<Class<Module>> getModules() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled());
    }

    public List<Class<Module>> getNormalModules() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled().and(Filters.overridingModule().negate()));
    }

    public List<Class<Module>> getOverridingModules() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled().and(Filters.overridingModule()));
    }

    public List<Class<Module>> getModulesDisabled() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled().negate());
    }

    public List<Class<FeatureInstaller>> getInstallers() {
        return this.context.getItems(ConfigItem.Installer, Filters.enabled());
    }

    public List<Class<FeatureInstaller>> getInstallersFromScan() {
        return this.context.getItems(ConfigItem.Installer, Filters.enabled().and(Filters.fromScan()));
    }

    public List<Class<FeatureInstaller>> getInstallersDisabled() {
        return this.context.getItems(ConfigItem.Installer, Filters.enabled().negate());
    }

    public List<Class<FeatureInstaller>> getInstallersOrdered() {
        return this.holder.getInstallerTypes();
    }

    public List<Class<Object>> getExtensions() {
        return this.context.getItems(ConfigItem.Extension, Filters.enabled());
    }

    public List<Class<Object>> getExtensions(Class<? extends FeatureInstaller> installer) {
        return this.context.getItems(ConfigItem.Extension, Filters.installedBy(installer));
    }

    public List<Class<Object>> getExtensionsFromScan() {
        return this.context.getItems(ConfigItem.Extension, Filters.enabled().and(Filters.fromScan()));
    }

    public List<Class<Object>> getExtensionsOrdered(Class<? extends FeatureInstaller> installer) {
        List<Class<?>> extensions = this.holder.getExtensions(installer);
        return extensions == null ? Collections.emptyList() : extensions;
    }

    public List<Class<Object>> getExtensionsDisabled() {
        return this.context.getItems(ConfigItem.Extension, Filters.enabled().negate());
    }
}

