/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import io.dropwizard.Application;
import io.dropwizard.Bundle;
import java.util.Arrays;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;

public enum ConfigScope {
    Application(Application.class),
    BundleLookup(GuiceyBundleLookup.class),
    DropwizardBundle(Bundle.class),
    ClasspathScan(ClasspathScanner.class),
    Hook(GuiceyConfigurationHook.class),
    GuiceyBundle(GuiceyBundle.class);

    private final Class<?> type;

    private ConfigScope(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static Class[] allExcept(ConfigScope scope) {
        return (Class[])Arrays.stream(ConfigScope.values()).filter(s -> s != scope && s != GuiceyBundle).map(ConfigScope::getType).toArray(Class[]::new);
    }

    public static ConfigScope recognize(Class<?> type) {
        for (ConfigScope scope : ConfigScope.values()) {
            if (!scope.getType().isAssignableFrom(type)) continue;
            return scope;
        }
        throw new IllegalStateException("Type " + type.getName() + " does not represent configuration scope");
    }
}

