/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import java.util.Arrays;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;

public final class Disables {
    private Disables() {
    }

    public static Predicate<ItemInfo> registeredBy(ConfigScope ... types) {
        return Disables.registeredBy((Class[])Arrays.stream(types).map(ConfigScope::getType).toArray(Class[]::new));
    }

    public static Predicate<ItemInfo> registeredBy(Class<?> ... types) {
        return input -> Arrays.asList(types).contains(input.getRegistrationScope());
    }

    public static Predicate<ItemInfo> itemType(ConfigItem ... types) {
        return Filters.type(types);
    }

    public static Predicate<ItemInfo> extension() {
        return Disables.itemType(ConfigItem.Extension);
    }

    public static Predicate<ItemInfo> module() {
        return Disables.itemType(ConfigItem.Module);
    }

    public static Predicate<ItemInfo> bundle() {
        return Disables.itemType(ConfigItem.Bundle);
    }

    public static Predicate<ItemInfo> installer() {
        return Disables.itemType(ConfigItem.Installer);
    }

    public static Predicate<ItemInfo> type(Class<?> ... types) {
        return input -> Arrays.asList(types).contains(input.getType());
    }

    public static Predicate<ItemInfo> inPackage(String ... pkgs) {
        return input -> {
            String typePkg = input.getType().getPackage().getName();
            return Arrays.stream(pkgs).anyMatch(typePkg::startsWith);
        };
    }
}

