/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import io.dropwizard.cli.Command;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.CommandItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstallerItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Singleton
public class DiagnosticRenderer
implements ReportRenderer<DiagnosticConfig> {
    private static final int SINGLE = 1;
    private final GuiceyConfigurationInfo service;

    @Inject
    public DiagnosticRenderer(GuiceyConfigurationInfo service) {
        this.service = service;
    }

    @Override
    public String renderReport(DiagnosticConfig config) {
        StringBuilder res = new StringBuilder();
        this.printCommands(config, res);
        this.printBundles(config, res);
        if (config.isPrintInstallers()) {
            this.printInstallers(config, res);
            this.printDisabledExtensions(config, res, true);
        } else {
            this.printExtensionsOnly(config, res);
        }
        this.printModules(config, res);
        return res.toString();
    }

    private void printCommands(DiagnosticConfig config, StringBuilder res) {
        List<Class<Command>> commands = this.service.getCommands();
        if (!config.isPrintCommands() || commands.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("COMMANDS = ").append(Reporter.NEWLINE);
        ArrayList markers = Lists.newArrayList();
        for (Class<Command> command : commands) {
            markers.clear();
            CommandItemInfo info = (CommandItemInfo)this.service.getData().getInfo(command);
            this.commonMarkers(markers, info);
            if (info.isEnvironmentCommand()) {
                markers.add("GUICE_ENABLED");
            }
            res.append("    ").append("    ").append(RenderUtils.renderClassLine(command, markers)).append(Reporter.NEWLINE);
        }
    }

    private void printBundles(DiagnosticConfig config, StringBuilder res) {
        List<Class<GuiceyBundle>> bundles = this.service.getDirectBundles();
        if (!config.isPrintBundles() || bundles.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("BUNDLES = ").append(Reporter.NEWLINE);
        for (Class<GuiceyBundle> bundle : bundles) {
            this.renderBundleRecursive(res, bundle, 1);
        }
        if (config.isPrintDisabledItems()) {
            for (Class<GuiceyBundle> bundle : this.service.getBundlesDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(bundle)).append(Reporter.NEWLINE);
            }
        }
    }

    private void renderBundleRecursive(StringBuilder res, Class<GuiceyBundle> bundle, int level) {
        BundleItemInfo info = (BundleItemInfo)this.service.getData().getInfo(bundle);
        ArrayList markers = Lists.newArrayList();
        if (info.isFromLookup()) {
            markers.add("LOOKUP");
        }
        if (info.isFromDwBundle()) {
            markers.add("DW");
        }
        this.commonMarkers(markers, info);
        for (int i = 0; i <= level; ++i) {
            res.append("    ");
        }
        res.append(RenderUtils.renderClassLine(bundle, markers)).append(Reporter.NEWLINE);
        List bundles = this.service.getData().getItems(ConfigItem.Bundle, Filters.enabled().and(Filters.registrationScope(bundle)));
        for (Class<GuiceyBundle> clazz : bundles) {
            this.renderBundleRecursive(res, clazz, level + 1);
        }
    }

    private void printInstallers(DiagnosticConfig config, StringBuilder res) {
        List<Class<FeatureInstaller>> installers = this.service.getInstallersOrdered();
        if (installers.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("INSTALLERS ");
        if (config.isPrintExtensions()) {
            res.append("and EXTENSIONS ");
        }
        res.append("in processing order = ").append(Reporter.NEWLINE);
        this.renderInstallers(config, res, installers);
        if (config.isPrintDisabledItems()) {
            for (Class<FeatureInstaller> installer : this.service.getInstallersDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledInstaller(installer)).append(Reporter.NEWLINE);
            }
        }
    }

    private void renderInstallers(DiagnosticConfig config, StringBuilder res, List<Class<FeatureInstaller>> installers) {
        ArrayList markers = Lists.newArrayList();
        for (Class<FeatureInstaller> installer : installers) {
            List<Class<Object>> extensions = this.service.getExtensionsOrdered(installer);
            if (extensions.isEmpty() && !config.isPrintNotUsedInstallers()) continue;
            InstallerItemInfo info = (InstallerItemInfo)this.service.getData().getInfo(installer);
            markers.clear();
            this.commonMarkers(markers, info);
            res.append("    ").append("    ").append(RenderUtils.renderInstaller(installer, markers)).append(Reporter.NEWLINE);
            if (!config.isPrintExtensions()) continue;
            for (Class<Object> ext : extensions) {
                res.append("    ").append("    ").append("    ").append(this.renderExtension(ext)).append(Reporter.NEWLINE);
            }
        }
    }

    private void printExtensionsOnly(DiagnosticConfig config, StringBuilder res) {
        List<Class<Object>> extensions = this.service.getExtensions();
        if (!config.isPrintExtensions() || extensions.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("EXTENSIONS = ").append(Reporter.NEWLINE);
        for (Class<Object> ext : extensions) {
            res.append("    ").append("    ").append(this.renderExtension(ext)).append(Reporter.NEWLINE);
        }
        this.printDisabledExtensions(config, res, false);
    }

    private void printDisabledExtensions(DiagnosticConfig config, StringBuilder res, boolean section) {
        List<Class<Object>> extensions = this.service.getExtensionsDisabled();
        if (!config.isPrintExtensions() || !config.isPrintDisabledItems() || extensions.isEmpty()) {
            return;
        }
        if (section) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("DISABLED EXTENSIONS = ").append(Reporter.NEWLINE);
        }
        for (Class<Object> ext : extensions) {
            res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(ext)).append(Reporter.NEWLINE);
        }
    }

    private String renderExtension(Class<Object> extension) {
        ExtensionItemInfo einfo = (ExtensionItemInfo)this.service.getData().getInfo(extension);
        ArrayList markers = Lists.newArrayList();
        this.commonMarkers(markers, einfo);
        if (einfo.isLazy()) {
            markers.add("LAZY");
        }
        if (einfo.isHk2Managed()) {
            markers.add("HK2");
        }
        return RenderUtils.renderClassLine(extension, markers);
    }

    private void printModules(DiagnosticConfig config, StringBuilder res) {
        List<Class<Module>> modules = this.service.getModules();
        if (!config.isPrintModules() || modules.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("GUICE MODULES = ").append(Reporter.NEWLINE);
        ArrayList markers = Lists.newArrayList();
        for (Class<Module> module : modules) {
            markers.clear();
            ModuleItemInfo info = (ModuleItemInfo)this.service.getData().getInfo(module);
            this.commonMarkers(markers, info);
            if (info.isOverriding()) {
                markers.add("OVERRIDE");
            }
            res.append("    ").append("    ").append(RenderUtils.renderClassLine(module, markers)).append(Reporter.NEWLINE);
        }
        if (config.isPrintDisabledItems()) {
            for (Class<Module> module : this.service.getModulesDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(module)).append(Reporter.NEWLINE);
            }
        }
    }

    private void commonMarkers(List<String> markers, ItemInfo item) {
        if (item.getRegisteredBy().contains(ConfigScope.ClasspathScan.getType())) {
            markers.add("SCAN");
        }
        if (item.getRegisteredBy().contains(ConfigScope.Hook.getType())) {
            markers.add("HOOK");
        }
        if (item.getRegistrationAttempts() > 1) {
            markers.add("REG(" + item.getRegistrationAttempts() + ")");
        }
    }
}

