/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.TypeInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public class FeatureInstallerExecutor {
    private final Logger logger = LoggerFactory.getLogger(FeatureInstallerExecutor.class);
    private final ExtensionsHolder holder;
    private final Environment environment;
    private final Injector injector;

    @Inject
    public FeatureInstallerExecutor(ExtensionsHolder holder, Environment environment, Injector injector) {
        this.holder = holder;
        this.environment = environment;
        this.injector = injector;
        this.installFeatures();
    }

    private void installFeatures() {
        Stopwatch timer = this.holder.stat().timer(Stat.ExtensionsInstallationTime);
        this.holder.order();
        ArrayList allInstalled = new ArrayList();
        this.holder.lifecycle().injectorPhase(this.injector);
        for (FeatureInstaller installer : this.holder.getInstallers()) {
            List<Class<?>> res = this.holder.getExtensions(installer.getClass());
            if (res != null) {
                for (Class<?> inst : res) {
                    if (installer instanceof TypeInstaller) {
                        ((TypeInstaller)((Object)installer)).install(this.environment, inst);
                    }
                    if (installer instanceof InstanceInstaller) {
                        ((InstanceInstaller)((Object)installer)).install(this.environment, this.injector.getInstance(inst));
                    }
                    this.logger.trace("{} extension installed: {}", (Object)FeatureUtils.getInstallerExtName(installer.getClass()), (Object)inst.getName());
                }
            }
            if (installer instanceof JerseyInstaller) continue;
            installer.report();
            this.holder.lifecycle().extensionsInstalled(installer.getClass(), res);
            if (res == null) continue;
            allInstalled.addAll(res);
        }
        this.holder.lifecycle().extensionsInstalled(allInstalled);
        timer.stop();
    }
}

