/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.jersey;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Priority;
import org.glassfish.jersey.internal.inject.InjectionManager;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.jersey.JerseyConfig;
import ru.vyarus.dropwizard.guice.debug.report.jersey.util.ProviderRenderUtil;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.LazyBinding;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class JerseyConfigRenderer
implements ReportRenderer<JerseyConfig> {
    private final InjectionManager manager;
    private final boolean guiceFirstMode;

    public JerseyConfigRenderer(InjectionManager manager, boolean guiceFirstMode) {
        this.manager = manager;
        this.guiceFirstMode = guiceFirstMode;
    }

    @Override
    public String renderReport(JerseyConfig config) {
        StringBuilder res = new StringBuilder(Reporter.NEWLINE);
        for (Class<?> ext : config.getRequiredTypes()) {
            this.renderGroup(ext, res);
        }
        return res.toString();
    }

    private void renderGroup(Class<?> ext, StringBuilder res) {
        List providers = this.manager.getAllInstances(ext);
        if (providers.isEmpty()) {
            return;
        }
        providers.sort(Comparator.comparing(it -> {
            Priority priority = it.getClass().getAnnotation(Priority.class);
            return priority == null ? 5000 : priority.value();
        }).thenComparing(it -> {
            Class<?> type = it.getClass();
            return type.isMemberClass() ? type.getDeclaringClass().getSimpleName() : type.getSimpleName();
        }).thenComparing(it -> it.getClass().getPackage().getName()));
        res.append(Reporter.NEWLINE).append("    ").append(ProviderRenderUtil.getTypeName(ext)).append(Reporter.NEWLINE);
        providers.forEach(it -> {
            Class<?> type = it.getClass();
            boolean hkManaged = JerseyBinding.isJerseyManaged(type, this.guiceFirstMode);
            boolean lazy = type.isAnnotationPresent(LazyBinding.class);
            res.append("    ").append("    ").append(ProviderRenderUtil.render(ext, it, hkManaged, lazy)).append(Reporter.NEWLINE);
        });
    }
}

