/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.internal.CommandSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ModulesSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;

public class GuiceyRunner {
    private final Stopwatch guiceyTime;
    private final Stopwatch runTime;
    private final ConfigurationContext context;
    private Injector injector;

    public GuiceyRunner(ConfigurationContext context, Configuration configuration, Environment environment) {
        this.guiceyTime = context.stat().timer(Stat.GuiceyTime);
        this.runTime = context.stat().timer(Stat.RunTime);
        context.runPhaseStarted(configuration, environment);
        this.context = context;
    }

    public void runBundles() throws Exception {
        Stopwatch timer = this.context.stat().timer(Stat.BundleTime);
        BundleSupport.runBundles(this.context);
        timer.stop();
    }

    public void prepareModules() {
        Stopwatch timer = this.context.stat().timer(Stat.ModulesProcessingTime);
        this.context.registerModules(new Module[]{new GuiceBootstrapModule(this.context)});
        ModulesSupport.configureModules(this.context);
        timer.stop();
    }

    public Iterable<Module> analyzeAndRepackageBindings() {
        Iterable<Module> res = ModulesSupport.prepareModules(this.context);
        this.context.finalizeConfiguration();
        this.context.lifecycle().extensionsResolved(this.context.getEnabledExtensions(), this.context.getDisabledExtensions());
        return res;
    }

    public void createInjector(InjectorFactory injectorFactory, Iterable<Module> modules) {
        Stopwatch timer = this.context.stat().timer(Stat.InjectorCreationTime);
        this.context.lifecycle().injectorCreation(new ArrayList<Module>(this.context.getNormalModules()), new ArrayList<Module>(this.context.getOverridingModules()), this.context.getDisabledModules(), this.context.getIgnoredItems(ConfigItem.Module));
        this.context.stat().getGuiceStats().injectLogsInterceptor();
        this.injector = injectorFactory.createInjector((Stage)this.context.option(GuiceyOptions.InjectorStage), modules);
        this.context.stat().getGuiceStats().resetStatsLogger();
        InjectorLookup.registerInjector(this.context.getBootstrap().getApplication(), this.injector);
        timer.stop();
    }

    public void installExtensions() {
        Stopwatch timer = this.context.stat().timer(Stat.ExtensionsInstallationTime);
        ExtensionsSupport.installExtensions(this.context, this.injector);
        timer.stop();
    }

    public void injectCommands() {
        Stopwatch timer = this.context.stat().timer(Stat.CommandTime);
        CommandSupport.initCommands(this.context.getBootstrap().getCommands(), this.injector);
        timer.stop();
    }

    public void runFinished() {
        this.context.lifecycle().applicationRun();
        this.runTime.stop();
        this.guiceyTime.stop();
    }
}

