/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.setup.Environment;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.AdminContext;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.util.WebUtils;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.option.InstallerOptionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=90)
public class WebServletInstaller
extends InstallerOptionsSupport
implements FeatureInstaller,
InstanceInstaller<HttpServlet>,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(WebServletInstaller.class);
    private final Reporter reporter = new Reporter(WebServletInstaller.class, "servlets =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, HttpServlet.class) && FeatureUtils.hasAnnotation(type, WebServlet.class);
    }

    @Override
    public void install(Environment environment, HttpServlet instance) {
        Class<HttpServlet> extType = FeatureUtils.getInstanceClass(instance);
        WebServlet annotation = FeatureUtils.getAnnotation(extType, WebServlet.class);
        Object[] patterns = annotation.urlPatterns().length > 0 ? annotation.urlPatterns() : annotation.value();
        Preconditions.checkArgument((patterns.length > 0 ? 1 : 0) != 0, (String)"Servlet %s not specified url pattern for mapping", (Object)extType.getName());
        AdminContext context = FeatureUtils.getAnnotation(extType, AdminContext.class);
        String name = WebUtils.getServletName(annotation, extType);
        this.reporter.line("%-25s %-8s %-4s %s   %s", Joiner.on((String)",").join(patterns), WebUtils.getAsyncMarker(annotation), WebUtils.getContextMarkers(context), RenderUtils.renderClassLine(extType), name);
        if (WebUtils.isForMain(context)) {
            this.configure(environment.servlets(), instance, extType, name, annotation);
        }
        if (WebUtils.isForAdmin(context)) {
            this.configure((ServletEnvironment)environment.admin(), instance, extType, name, annotation);
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    private void configure(ServletEnvironment environment, HttpServlet servlet, Class<? extends HttpServlet> type, String name, WebServlet annotation) {
        ServletRegistration.Dynamic mapping = environment.addServlet(name, (Servlet)servlet);
        Set clash = mapping.addMapping(annotation.urlPatterns().length > 0 ? annotation.urlPatterns() : annotation.value());
        if (clash != null && !clash.isEmpty()) {
            String msg = String.format("Servlet registration %s clash with already installed servlets on paths: %s", type.getSimpleName(), Joiner.on((char)',').join((Iterable)clash));
            if (((Boolean)this.option(InstallersOptions.DenyServletRegistrationWithClash)).booleanValue()) {
                throw new IllegalStateException(msg);
            }
            this.logger.warn(msg);
        }
        if (annotation.initParams().length > 0) {
            for (WebInitParam param : annotation.initParams()) {
                mapping.setInitParameter(param.name(), param.value());
            }
        }
        mapping.setAsyncSupported(annotation.asyncSupported());
    }
}

