/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.regex.Pattern;

public final class PathUtils {
    public static final String SLASH = "/";
    private static final Pattern PATH_DIRTY_SLASHES = Pattern.compile("\\s*/\\s*(/+\\s*)?");
    private static final CharMatcher TRIM_SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher TRIM_STAR = CharMatcher.is((char)'*');

    private PathUtils() {
    }

    public static String path(String ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = Strings.emptyToNull((String)parts[i]);
        }
        return PathUtils.normalize(Joiner.on((String)SLASH).skipNulls().join((Object[])parts));
    }

    public static String normalize(String path) {
        String fixedBackslashes = path.replace('\\', '/');
        return PATH_DIRTY_SLASHES.matcher(fixedBackslashes).replaceAll(SLASH).trim();
    }

    public static String leadingSlash(String path) {
        return path.startsWith(SLASH) ? path : SLASH + path;
    }

    public static String trailingSlash(String path) {
        if (path.isEmpty()) {
            return path;
        }
        return path.endsWith(SLASH) ? path : path + SLASH;
    }

    public static String trimStars(String path) {
        return TRIM_STAR.trimFrom((CharSequence)path);
    }

    public static String trimSlashes(String path) {
        return TRIM_SLASH.trimFrom((CharSequence)path);
    }

    public static String trimLeadingSlash(String path) {
        return TRIM_SLASH.trimLeadingFrom((CharSequence)path);
    }

    public static String trimTrailingSlash(String path) {
        return TRIM_SLASH.trimTrailingFrom((CharSequence)path);
    }

    public static String relativize(String path) {
        return PathUtils.trimLeadingSlash(PathUtils.normalize(path));
    }

    public static String packagePath(Class cls) {
        return PathUtils.trailingSlash(cls.getPackage().getName().replace(".", SLASH));
    }

    public static String normalizeRelativePath(String path) {
        String cleanPath = PathUtils.normalize(path);
        return cleanPath.isEmpty() ? cleanPath : PathUtils.trailingSlash(PathUtils.trimSlashes(cleanPath));
    }

    public static String normalizeClasspathPath(String path) {
        return PathUtils.normalizeRelativePath(path.replace('.', '/'));
    }
}

