/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import org.junit.contrib.java.lang.system.ExpectedSystemExit;
import org.junit.contrib.java.lang.system.SystemErrRule;
import org.junit.contrib.java.lang.system.SystemOutRule;
import org.junit.contrib.java.lang.system.internal.CheckExitCalled;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class StartupErrorRule
implements TestRule {
    private final ExpectedSystemExit exit = ExpectedSystemExit.none();
    private final SystemErrRule systemErr = new SystemErrRule();
    private final SystemOutRule systemOut = new SystemOutRule();

    private StartupErrorRule() {
        this.exit.expectSystemExitWithStatus(1);
        this.systemErr.enableLog();
        this.systemOut.enableLog();
    }

    public static StartupErrorRule create() {
        return new StartupErrorRule();
    }

    public static StartupErrorRule create(AfterExitAssertion check) {
        return StartupErrorRule.create().checkAfterExit(check);
    }

    public StartupErrorRule checkAfterExit(AfterExitAssertion check) {
        this.exit.checkAssertionAfterwards(() -> check.check(this.getOutput(), this.getError()));
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return this.systemOut.apply(this.systemErr.apply(this.exit.apply(base, description), description), description);
    }

    public String getOutput() {
        return this.clearString(this.systemOut.getLog());
    }

    public String getError() {
        return this.clearString(this.systemErr.getLog());
    }

    public Class<? extends Exception> getIndicatorExceptionType() {
        return CheckExitCalled.class;
    }

    private String clearString(String message) {
        return message.trim().replaceAll("\r", "");
    }

    @FunctionalInterface
    public static interface AfterExitAssertion {
        public void check(String var1, String var2) throws Exception;
    }
}

