/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.util;

import com.google.common.base.Preconditions;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.ServletModule;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.PrivateElements;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.ModuleDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.GuiceElementVisitor;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.GuiceScopingVisitor;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.PrivateModuleException;
import ru.vyarus.dropwizard.guice.module.installer.feature.eager.EagerSingleton;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;

public final class GuiceModelParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceModelParser.class);
    private static final GuiceScopingVisitor SCOPE_DETECTOR = new GuiceScopingVisitor();
    private static final GuiceElementVisitor ELEMENT_VISITOR = new GuiceElementVisitor();

    private GuiceModelParser() {
    }

    public static List<ModuleDeclaration> parse(Injector injector, Collection<? extends Element> elements) {
        Map<String, ModuleDeclaration> index = GuiceModelParser.indexElements(injector, elements);
        ArrayList<ModuleDeclaration> res = new ArrayList<ModuleDeclaration>();
        for (ModuleDeclaration mod : index.values()) {
            if (mod.getParent() != null) {
                index.get(mod.getParent()).getChildren().add(mod);
            } else {
                res.add(mod);
            }
            mod.getDeclarations().sort(Comparator.comparingInt(BindingDeclaration::getSourceLine).thenComparing(BindingDeclaration::getType).thenComparing(it -> it.getScope() != null ? it.getScope().getSimpleName() : "").thenComparing(it -> it.getKey() != null ? GuiceModelUtils.renderKey(it.getKey()) : ""));
        }
        Comparator<ModuleDeclaration> moduleComparator = Comparator.comparing(ModuleDeclaration::isJitModule).thenComparing(it -> it.getType().getName());
        res.sort(moduleComparator);
        GuiceModelUtils.visit(res, it -> it.getChildren().sort(moduleComparator));
        return res;
    }

    public static BindingDeclaration parseElement(Injector injector, Element element) {
        BindingDeclaration dec = (BindingDeclaration)element.acceptVisitor((ElementVisitor)ELEMENT_VISITOR);
        if (dec != null) {
            Class ann;
            GuiceModelParser.fillDeclaration(dec, injector);
            GuiceModelParser.fillSource(dec, element);
            dec.setModule(BindingUtils.getModules(element).get(0));
            if (dec.getKey() != null && (ann = dec.getKey().getAnnotationType()) != null) {
                if (ann.getName().equals("com.google.inject.internal.Element")) {
                    dec.setSpecial(Collections.singletonList("multibinding"));
                }
                if (ann.getName().startsWith("com.google.inject.internal.RealOptionalBinder")) {
                    dec.setSpecial(Collections.singletonList("optional binding"));
                }
            }
        }
        return dec;
    }

    private static Map<String, ModuleDeclaration> indexElements(Injector injector, Collection<? extends Element> elements) {
        LinkedHashMap<String, ModuleDeclaration> index = new LinkedHashMap<String, ModuleDeclaration>();
        for (Element element : elements) {
            try {
                BindingDeclaration dec = GuiceModelParser.parseElement(injector, element);
                if (dec == null) continue;
                ModuleDeclaration mod = GuiceModelParser.initModules(index, BindingUtils.getModules(element));
                mod.getDeclarations().add(dec);
            }
            catch (PrivateModuleException ex) {
                GuiceModelParser.indexPrivate(index, injector, ex.getElements());
            }
        }
        return index;
    }

    private static void indexPrivate(Map<String, ModuleDeclaration> index, Injector injector, PrivateElements elements) {
        String declaringModule = (String)((ElementSource)elements.getSource()).getModuleClassNames().get(0);
        Map<String, ModuleDeclaration> privateIndex = GuiceModelParser.indexElements(injector, elements.getElements());
        Set exposed = elements.getExposedKeys();
        for (Map.Entry<String, ModuleDeclaration> entry : privateIndex.entrySet()) {
            String key = entry.getKey();
            if (index.containsKey(key)) continue;
            ModuleDeclaration mod = entry.getValue();
            if (declaringModule.equals(key)) {
                mod.setPrivateModule(true);
                mod.getMarkers().add("PRIVATE");
            }
            GuiceModelUtils.visitBindings(Collections.singletonList(mod), it -> {
                if (it.getKey() != null && exposed.contains(it.getKey())) {
                    it.getMarkers().add("EXPOSED");
                }
            });
            index.put(key, mod);
        }
        for (Key key : exposed) {
            Binding existingBinding = injector.getExistingBinding(key);
            if (existingBinding == null) continue;
            BindingDeclaration dec = GuiceModelParser.parseElement(injector, (Element)existingBinding);
            index.get(dec.getModule()).getDeclarations().add(dec);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    private static ModuleDeclaration initModules(Map<String, ModuleDeclaration> index, List<String> path) {
        ModuleDeclaration res = null;
        for (int i = 0; i < path.size(); ++i) {
            String name = path.get(i);
            String parent = i < path.size() - 1 ? path.get(i + 1) : null;
            ModuleDeclaration mod = GuiceModelParser.initModule(index, name);
            mod.setParent(parent);
            Preconditions.checkState((mod.getParent() == null || Objects.equals(mod.getParent(), parent) ? 1 : 0) != 0, (String)"Parents don't match for module %s: '%s' and '%s' in path (%s)", (Object)name, (Object)mod.getParent(), (Object)parent, (Object)String.join((CharSequence)"-", path));
            if (res != null) continue;
            res = mod;
        }
        return res;
    }

    private static ModuleDeclaration initModule(Map<String, ModuleDeclaration> index, String name) {
        ModuleDeclaration mod = index.get(name);
        if (mod == null) {
            mod = new ModuleDeclaration();
            mod.setType(BindingUtils.getModuleClass(name));
            if (ServletModule.class.isAssignableFrom(mod.getType())) {
                mod.getMarkers().add("WEB");
            }
            index.put(name, mod);
        }
        return mod;
    }

    private static void fillDeclaration(BindingDeclaration dec, Injector injector) {
        if (dec.getKey() != null) {
            int aops;
            Class<Singleton> scope;
            Binding existingBinding = injector.getExistingBinding(dec.getKey());
            if (existingBinding == null) {
                if (dec.getElement() instanceof Binding) {
                    existingBinding = (Binding)dec.getElement();
                } else {
                    return;
                }
            }
            if ((scope = (Class<Singleton>)existingBinding.acceptScopingVisitor((BindingScopingVisitor)SCOPE_DETECTOR)) != null && scope.equals(EagerSingleton.class)) {
                scope = Singleton.class;
            }
            dec.setScope((Class<? extends Annotation>)scope);
            if (existingBinding instanceof ConstructorBinding && (aops = ((ConstructorBinding)existingBinding).getMethodInterceptors().size()) > 0) {
                dec.getMarkers().add("AOP");
            }
        }
    }

    private static void fillSource(BindingDeclaration dec, Element element) {
        StackTraceElement trace = GuiceModelUtils.getDeclarationSource(element);
        if (trace != null) {
            dec.setSource(trace.toString());
            dec.setSourceLine(trace.getLineNumber());
        } else {
            Object source = element.getSource();
            if (source instanceof Class) {
                dec.setSource(((Class)source).getName());
            } else {
                LOGGER.warn("Unknown element '{}' source: {}", (Object)dec, source);
            }
        }
    }
}

