/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.util;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.ModuleDeclaration;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;

public final class GuiceModelUtils {
    private GuiceModelUtils() {
    }

    public static List<Class> getModules(List<ModuleDeclaration> modules) {
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Class> res = new ArrayList<Class>();
        GuiceModelUtils.visit(modules, it -> res.add(it.getType()));
        res.remove(Module.class);
        return res;
    }

    public static Map<Key, BindingDeclaration> index(List<ModuleDeclaration> modules) {
        if (modules.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Key, BindingDeclaration> res = new HashMap<Key, BindingDeclaration>();
        GuiceModelUtils.visitBindings(modules, it -> {
            if (it.getKey() != null) {
                res.put(it.getKey(), (BindingDeclaration)it);
            }
        });
        return res;
    }

    public static void visit(List<ModuleDeclaration> modules, Consumer<ModuleDeclaration> consumer) {
        for (ModuleDeclaration mod : modules) {
            consumer.accept(mod);
            GuiceModelUtils.visit(mod.getChildren(), consumer);
        }
    }

    public static void visitBindings(List<ModuleDeclaration> modules, Consumer<BindingDeclaration> consumer) {
        GuiceModelUtils.visit(modules, it -> it.getDeclarations().forEach(consumer));
    }

    public static String renderKey(Key key) {
        if (key == null) {
            return "-";
        }
        StringBuilder res = new StringBuilder();
        if (key.getAnnotationType() != null) {
            res.append('@').append(key.getAnnotationType().getSimpleName());
            for (Method method : key.getAnnotationType().getMethods()) {
                if (!method.getName().equals("value") || !method.getReturnType().equals(String.class)) continue;
                boolean accessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    String qualifier = (String)method.invoke((Object)key.getAnnotation(), new Object[0]);
                    if (qualifier == null || qualifier.isEmpty()) break;
                    res.append("(\"").append(qualifier).append("\")");
                    break;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to inspect annotation", e);
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
            res.append(' ');
        }
        res.append(TypeToStringUtils.toStringType((Type)key.getTypeLiteral().getType(), (Map)EmptyGenericsMap.getInstance()));
        return res.toString();
    }

    public static StackTraceElement getDeclarationSource(Element element) {
        Object source = element.getSource();
        StackTraceElement traceElement = null;
        if (source instanceof ElementSource) {
            ElementSource src = (ElementSource)source;
            if (src.getDeclaringSource() instanceof StackTraceElement) {
                traceElement = (StackTraceElement)src.getDeclaringSource();
            } else if (src.getDeclaringSource() instanceof Method) {
                traceElement = (StackTraceElement)StackTraceElements.forMember((Member)((Method)src.getDeclaringSource()));
            }
        }
        return traceElement;
    }
}

