/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.util;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import com.google.common.base.Joiner;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public final class RenderUtils {
    private static final TargetLengthBasedClassNameAbbreviator PACKAGE_FORMATTER = new TargetLengthBasedClassNameAbbreviator(20);
    private static final TargetLengthBasedClassNameAbbreviator CLASS_FORMATTER = new TargetLengthBasedClassNameAbbreviator(36);

    private RenderUtils() {
    }

    public static String renderInstaller(Class<FeatureInstaller> type, List<String> markers) {
        return String.format("%-20s %-38s %s", FeatureUtils.getInstallerExtName(type), RenderUtils.brackets(RenderUtils.renderClass(type)), RenderUtils.markers(markers));
    }

    public static String renderDisabledInstaller(Class<FeatureInstaller> type) {
        return String.format("-%-19s %-38s", FeatureUtils.getInstallerExtName(type), RenderUtils.brackets(RenderUtils.renderClass(type)));
    }

    public static String renderClassLine(Class<?> type, List<String> markers) {
        return RenderUtils.renderClassLine(type, 0, markers);
    }

    public static String renderClassLine(Class<?> type) {
        return RenderUtils.renderClassLine(type, null);
    }

    public static String renderClassLine(Class<?> type, int pos, List<String> markers) {
        return String.format("%-28s %-26s %s", RenderUtils.getClassName(type) + RenderUtils.renderPositionPostfix(pos), RenderUtils.brackets(RenderUtils.renderPackage(type)), RenderUtils.markers(markers));
    }

    public static String renderDisabledClassLine(Class<?> type) {
        return RenderUtils.renderDisabledClassLine(type, 0, null);
    }

    public static String renderDisabledClassLine(Class<?> type, int pos, List<String> markers) {
        return String.format("-%-27s %-26s %s", RenderUtils.getClassName(type) + RenderUtils.renderPositionPostfix(pos), RenderUtils.brackets(RenderUtils.renderPackage(type)), RenderUtils.markers(markers));
    }

    public static String renderClass(Class<?> type) {
        return CLASS_FORMATTER.abbreviate(type.getName());
    }

    public static String renderPackage(Class<?> type) {
        return PACKAGE_FORMATTER.abbreviate(type.isMemberClass() && !type.isAnonymousClass() ? (type.getDeclaringClass() != null ? type.getDeclaringClass().getName() : type.getName()) : (type.getPackage() != null ? type.getPackage().getName() : type.getName()));
    }

    public static String brackets(String string) {
        return "(" + string + ")";
    }

    public static String markers(List<String> markers) {
        String signs = "";
        if (markers != null && !markers.isEmpty()) {
            signs = "*" + Joiner.on((String)", ").join(markers);
        }
        return signs;
    }

    public static String getClassName(Class<?> type) {
        String name = type.getSimpleName();
        if (name.isEmpty()) {
            name = type.getName().substring(type.getName().lastIndexOf(46) + 1);
        }
        return name;
    }

    private static String renderPositionPostfix(int pos) {
        return pos > 1 ? "#" + pos : "";
    }
}

