/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.dropwizard.Application;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class SharedConfigurationState {
    public static final String CONTEXT_APPLICATION_PROPERTY = "guicey.context.application";
    private static final Map<Application, SharedConfigurationState> STATE = Maps.newConcurrentMap();
    private final Map<String, Object> state = new HashMap<String, Object>();
    private Application application;

    public <V> V get(Class<?> key) {
        return (V)this.state.get(key.getName());
    }

    public <V> V get(Class<?> key, Supplier<V> defaultValue) {
        V res = this.get(key);
        if (res == null && defaultValue != null) {
            res = defaultValue.get();
            this.put(key, res);
        }
        return res;
    }

    public <V> V getOrFail(Class<?> key, String message, Object ... args) {
        V res = this.get(key);
        if (res == null) {
            throw new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args));
        }
        return res;
    }

    public void put(Class<?> key, Object value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Shared state key can't be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Shared state does not accept null values");
        String name = key.getName();
        Preconditions.checkState((!this.state.containsKey(name) ? 1 : 0) != 0, (String)"Shared state for key %s already defined", (Object)name);
        this.state.put(name, value);
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.state.keySet());
    }

    public String toString() {
        return "Shared state with " + this.state.size() + " objects: " + String.join((CharSequence)", ", this.getKeys());
    }

    protected void assignTo(Application application) {
        this.application = application;
        Preconditions.checkState((!STATE.containsKey(application) ? 1 : 0) != 0, (String)"Shared state already associated with application %s", (Object)application.getClass().getName());
        STATE.put(application, this);
    }

    protected void listen(Environment environment) {
        environment.getApplicationContext().setAttribute(CONTEXT_APPLICATION_PROPERTY, (Object)this.application);
        environment.lifecycle().manage((Managed)new RegistryShutdown(this.application));
    }

    public static <V> Optional<V> lookup(Application application, Class<?> key) {
        return SharedConfigurationState.get(application).map(value -> value.get(key));
    }

    public static <V> Optional<V> lookup(Environment environment, Class<?> key) {
        return SharedConfigurationState.get(environment).map(value -> value.get(key));
    }

    public static <V> V lookupOrFail(Application application, Class<?> key, String message, Object ... args) {
        return SharedConfigurationState.lookup(application, key).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static <V> V lookupOrFail(Environment environment, Class<?> key, String message, Object ... args) {
        return SharedConfigurationState.lookup(environment, key).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static Optional<SharedConfigurationState> get(Application application) {
        return Optional.ofNullable(STATE.get(application));
    }

    public static Optional<SharedConfigurationState> get(Environment environment) {
        Application application = (Application)environment.getApplicationContext().getAttribute(CONTEXT_APPLICATION_PROPERTY);
        return application == null ? Optional.empty() : SharedConfigurationState.get(application);
    }

    public static SharedConfigurationState getOrFail(Application application, String message, Object ... args) {
        return SharedConfigurationState.get(application).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static SharedConfigurationState getOrFail(Environment environment, String message, Object ... args) {
        return SharedConfigurationState.get(environment).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    @VisibleForTesting
    public static void clear() {
        STATE.clear();
    }

    @VisibleForTesting
    public static int statesCount() {
        return STATE.size();
    }

    private static class RegistryShutdown
    implements Managed {
        private final Application application;

        protected RegistryShutdown(Application application) {
            this.application = application;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            STATE.remove(this.application);
        }
    }
}

