/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.inject.internal.util.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class GuiceStatsTracker {
    private final List<String> messages = new ArrayList<String>();
    private Level originalLevel;
    private final Handler handler = new LogsInterceptor();

    public void injectLogsInterceptor() {
        Logger guiceStatsLogger = this.getLogger();
        if (!guiceStatsLogger.isLoggable(Level.FINE)) {
            this.originalLevel = guiceStatsLogger.getLevel();
            guiceStatsLogger.setUseParentHandlers(false);
            guiceStatsLogger.setLevel(Level.FINE);
        }
        guiceStatsLogger.addHandler(this.handler);
    }

    public void resetStatsLogger() {
        Logger guiceStatsLogger = this.getLogger();
        guiceStatsLogger.removeHandler(this.handler);
        guiceStatsLogger.setUseParentHandlers(true);
        if (this.originalLevel != null) {
            guiceStatsLogger.setLevel(this.originalLevel);
            this.originalLevel = null;
        }
    }

    public List<String> getMessages() {
        return this.messages;
    }

    private Logger getLogger() {
        return Logger.getLogger(Stopwatch.class.getName());
    }

    private class LogsInterceptor
    extends Handler {
        private LogsInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord record) {
            List list = GuiceStatsTracker.this.messages;
            synchronized (list) {
                String msg = record.getMessage();
                GuiceStatsTracker.this.messages.add(msg.substring(0, msg.length() - 2) + " ms");
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

