/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import java.util.List;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;

public class GuiceyBootstrap {
    private final ConfigurationContext context;
    private final List<GuiceyBundle> iterationBundles;

    public GuiceyBootstrap(ConfigurationContext context, List<GuiceyBundle> iterationBundles) {
        this.context = context;
        this.iterationBundles = iterationBundles;
    }

    public <T extends Configuration> Bootstrap<T> bootstrap() {
        return this.context.getBootstrap();
    }

    public Application application() {
        return this.context.getBootstrap().getApplication();
    }

    public <V, T extends Enum> V option(T option) {
        return this.context.option(option);
    }

    public GuiceyBootstrap modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    public GuiceyBootstrap modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap installers(Class<? extends FeatureInstaller> ... installers) {
        this.context.registerInstallers(installers);
        return this;
    }

    public GuiceyBootstrap extensions(Class<?> ... extensionClasses) {
        this.context.registerExtensions(extensionClasses);
        return this;
    }

    public GuiceyBootstrap extensionsOptional(Class<?> ... extensionClasses) {
        this.context.registerExtensionsOptional(extensionClasses);
        return this;
    }

    public GuiceyBootstrap bundles(GuiceyBundle ... bundles) {
        this.iterationBundles.addAll(this.context.registerBundles(bundles));
        return this;
    }

    public GuiceyBootstrap dropwizardBundles(ConfiguredBundle ... bundles) {
        this.context.registerDropwizardBundles(bundles);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableInstallers(Class<? extends FeatureInstaller> ... installers) {
        this.context.disableInstallers(installers);
        return this;
    }

    public final GuiceyBootstrap disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    public GuiceyBootstrap listen(GuiceyLifecycleListener ... listeners) {
        this.context.lifecycle().register(listeners);
        return this;
    }

    public GuiceyBootstrap shareState(Class<?> key, Object value) {
        this.context.getSharedState().put(key, value);
        return this;
    }

    public <T> T sharedState(Class<?> key, Supplier<T> defaultValue) {
        return this.context.getSharedState().get(key, defaultValue);
    }

    public <T> T sharedStateOrFail(Class<?> key, String message, Object ... args) {
        return (T)this.context.getSharedState().getOrFail(key, message, args);
    }
}

