/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestParametersSupport;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;

public abstract class GuiceyExtensionsSupport
extends TestParametersSupport
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback {
    private static final String DW_SUPPORT = "DW_SUPPORT";
    private static final String DW_CLIENT = "DW_CLIENT";
    private static final String INHERITED_DW_SUPPORT = "INHERITED_DW_SUPPORT";

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        DropwizardTestSupport support = (DropwizardTestSupport)Preconditions.checkNotNull(this.getSupport(context));
        Optional<Injector> injector = InjectorLookup.getInjector(support.getApplication());
        Preconditions.checkState((boolean)injector.isPresent(), (Object)"Can't find guicey injector to process test fields injections");
        injector.get().injectMembers(testInstance);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
        if (store.get((Object)DW_SUPPORT) == null) {
            DropwizardTestSupport<?> support = this.prepareTestSupport(context);
            store.put((Object)DW_SUPPORT, support);
            store.put((Object)DW_CLIENT, (Object)new ClientSupport(support));
            this.activateFieldHooks(context.getRequiredTestClass());
            support.before();
        } else {
            ExtensionContext.Store localStore = this.getLocalExtensionStore(context);
            Preconditions.checkState((localStore.get((Object)INHERITED_DW_SUPPORT) == null ? 1 : 0) != 0, (Object)"Storage assumptions were wrong or unexpected junit usage appear. Please report this case to guicey developer.");
            localStore.put((Object)INHERITED_DW_SUPPORT, (Object)true);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ClientSupport client;
        ConfigurationHooksSupport.reset();
        ExtensionContext.Store localExtensionStore = this.getLocalExtensionStore(context);
        if (localExtensionStore.get((Object)INHERITED_DW_SUPPORT) != null) {
            localExtensionStore.remove((Object)INHERITED_DW_SUPPORT);
            return;
        }
        DropwizardTestSupport<?> support = this.getSupport(context);
        if (support != null) {
            support.after();
        }
        if ((client = this.getClient(context)) != null) {
            client.close();
        }
        this.onShutdown(context);
    }

    public static Optional<DropwizardTestSupport<?>> lookupSupport(ExtensionContext extensionContext) {
        return Optional.ofNullable((DropwizardTestSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT));
    }

    public static Optional<Injector> lookupInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).flatMap(it -> InjectorLookup.getInjector(it.getApplication()));
    }

    public static Optional<ClientSupport> lookupClient(ExtensionContext extensionContext) {
        return Optional.ofNullable((ClientSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_CLIENT));
    }

    protected abstract DropwizardTestSupport<?> prepareTestSupport(ExtensionContext var1);

    protected void onShutdown(ExtensionContext context) {
    }

    @Override
    protected DropwizardTestSupport<?> getSupport(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).orElse(null);
    }

    @Override
    protected ClientSupport getClient(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupClient(extensionContext).get();
    }

    @Override
    protected Optional<Injector> getInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupInjector(extensionContext);
    }

    protected static ExtensionContext.Store getExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class}));
    }

    private void activateFieldHooks(Class<?> testClass) {
        List fields = AnnotationSupport.findAnnotatedFields(testClass, EnableHook.class);
        HooksUtil.validateFieldHooks(fields);
        if (!fields.isEmpty()) {
            HooksUtil.register(ReflectionUtils.readFieldValues((List)fields, null));
        }
    }

    private ExtensionContext.Store getLocalExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class, context.getRequiredTestClass()}));
    }
}

