/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.jersey.JerseyConfig;
import ru.vyarus.dropwizard.guice.debug.report.jersey.JerseyConfigRenderer;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.lifecycle.UniqueGuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationStartedEvent;

public class JerseyConfigDiagnostic
extends UniqueGuiceyLifecycleListener {
    private final Logger logger = LoggerFactory.getLogger(JerseyConfigDiagnostic.class);

    @Override
    protected void applicationStarted(ApplicationStartedEvent event) {
        if (!event.isJettyStarted()) {
            return;
        }
        Boolean guiceFirstMode = (Boolean)event.getOptions().get(InstallersOptions.JerseyExtensionsManagedByGuice);
        String report = new JerseyConfigRenderer(event.getInjectionManager(), guiceFirstMode).renderReport(new JerseyConfig());
        this.logger.warn("Jersey configuration = {}", (Object)report);
    }
}

