/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.context.bootstrap.BootstrapProxyFactory;
import ru.vyarus.dropwizard.guice.module.context.bootstrap.DropwizardBundleTracker;
import ru.vyarus.dropwizard.guice.module.context.info.DropwizardBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.GuiceyBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstanceItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.InstanceItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ModuleItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.option.internal.OptionsSupport;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.context.unique.DuplicateConfigDetector;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigTreeBuilder;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public final class ConfigurationContext {
    private final Logger logger = LoggerFactory.getLogger(ConfigurationContext.class);
    private final SharedConfigurationState sharedState = new SharedConfigurationState();
    private DuplicateConfigDetector duplicates;
    private Bootstrap bootstrap;
    private Bootstrap bootstrapProxy;
    private Configuration configuration;
    private ConfigurationTree configurationTree;
    private Environment environment;
    private ExtensionsHolder extensionsHolder;
    private final Multimap<ConfigItem, Object> itemsHolder = LinkedHashMultimap.create();
    private final Multimap<Class<?>, Object> instanceItemsIndex = LinkedHashMultimap.create();
    private final Map<ItemId, ItemInfo> detailsHolder = Maps.newHashMap();
    private final Multimap<ConfigItem, ItemId> disabledItemsHolder = LinkedHashMultimap.create();
    private final Multimap<ItemId, ItemId> disabledByHolder = LinkedHashMultimap.create();
    private final Multimap<ConfigItem, Object> duplicatesHolder = LinkedHashMultimap.create();
    private final Map<String, Class<?>> usedClassesHolder = new HashMap();
    private final List<PredicateHandler> disablePredicates = new ArrayList<PredicateHandler>();
    private ItemId currentScope;
    private final StatsTracker tracker = new StatsTracker();
    private final OptionsSupport optionsSupport = new OptionsSupport();
    private final LifecycleSupport lifecycleTracker = new LifecycleSupport(new Options(this.optionsSupport), this.sharedState);

    public void setDuplicatesDetector(DuplicateConfigDetector detector) {
        if (this.duplicates != null) {
            this.logger.warn("Configured duplicates detector {} is overridden with {}", (Object)this.duplicates.getClass().getSimpleName(), (Object)detector.getClass().getSimpleName());
        }
        this.duplicates = detector;
    }

    public void openScope(ItemId scope) {
        Preconditions.checkState((this.currentScope == null ? 1 : 0) != 0, (Object)"State error: current scope not closed");
        this.currentScope = scope;
    }

    public ItemId replaceContextScope(ItemId scope) {
        ItemId current = this.currentScope;
        this.currentScope = scope;
        return current;
    }

    public void closeScope() {
        Preconditions.checkState((this.currentScope != null ? 1 : 0) != 0, (Object)"State error: trying to close not opened scope");
        this.currentScope = null;
    }

    public void registerCommands(List<Class<Command>> commands) {
        this.openScope(ConfigScope.ClasspathScan.getKey());
        for (Class<Command> cmd : commands) {
            this.register(ConfigItem.Command, cmd);
        }
        this.closeScope();
    }

    public void registerLookupBundles(List<GuiceyBundle> bundles) {
        this.openScope(ConfigScope.BundleLookup.getKey());
        for (GuiceyBundle bundle : bundles) {
            this.register(ConfigItem.Bundle, bundle);
        }
        this.closeScope();
        this.lifecycle().bundlesFromLookupResolved(bundles);
        this.lifecycle().bundlesResolved(this.getEnabledBundles(), this.getDisabledBundles(), this.getIgnoredItems(ConfigItem.Bundle));
    }

    public List<GuiceyBundle> registerBundles(GuiceyBundle ... bundles) {
        ArrayList<GuiceyBundle> res = new ArrayList<GuiceyBundle>();
        for (GuiceyBundle bundle : bundles) {
            GuiceyBundleItemInfo info = (GuiceyBundleItemInfo)this.register(ConfigItem.Bundle, bundle);
            if (info.getRegistrationAttempts() != 1) continue;
            res.add(bundle);
        }
        return res;
    }

    public void disableBundle(Class<? extends GuiceyBundle>[] bundles) {
        for (Class<? extends GuiceyBundle> bundle : bundles) {
            this.registerDisable(ConfigItem.Bundle, ItemId.from(bundle));
        }
    }

    public List<GuiceyBundle> getEnabledBundles() {
        return this.getEnabledItems(ConfigItem.Bundle);
    }

    public List<GuiceyBundle> getDisabledBundles() {
        return this.getDisabledItems(ConfigItem.Bundle);
    }

    public boolean isBundleEnabled(ItemId id) {
        return this.isEnabled(ConfigItem.Bundle, id);
    }

    public void registerDropwizardBundles(ConfiguredBundle ... bundles) {
        for (ConfiguredBundle bundle : bundles) {
            DropwizardBundleItemInfo info = (DropwizardBundleItemInfo)this.register(ConfigItem.DropwizardBundle, bundle);
            if (info.getRegistrationAttempts() != 1 || this.bootstrap == null) continue;
            this.registerDropwizardBundle(bundle);
        }
    }

    public void disableDropwizardBundle(Class<? extends ConfiguredBundle>[] bundles) {
        for (Class<? extends ConfiguredBundle> bundle : bundles) {
            this.registerDisable(ConfigItem.DropwizardBundle, ItemId.from(bundle));
        }
    }

    public List<ConfiguredBundle> getEnabledDropwizardBundles() {
        return this.getEnabledItems(ConfigItem.DropwizardBundle);
    }

    public List<ConfiguredBundle> getDisabledDropwizardBundles() {
        return this.getDisabledItems(ConfigItem.DropwizardBundle);
    }

    public Bootstrap getBootstrapProxy() {
        if (this.bootstrapProxy == null) {
            this.bootstrapProxy = BootstrapProxyFactory.create(this.bootstrap, this);
        }
        return this.bootstrapProxy;
    }

    public void registerModules(Module ... modules) {
        for (Module module : modules) {
            this.register(ConfigItem.Module, module);
        }
    }

    public void registerModulesOverride(Module ... modules) {
        ModuleItemInfoImpl.overrideScope(() -> {
            for (Module module : modules) {
                this.register(ConfigItem.Module, module);
            }
        });
    }

    public void disableModules(Class<? extends Module>[] modules) {
        for (Class<? extends Module> module : modules) {
            this.registerDisable(ConfigItem.Module, ItemId.from(module));
        }
    }

    public List<Module> getEnabledModules() {
        return this.getEnabledItems(ConfigItem.Module);
    }

    public List<Module> getNormalModules() {
        return this.getEnabledModules().stream().filter(mod -> !((ModuleItemInfo)this.getInfo(mod)).isOverriding()).collect(Collectors.toList());
    }

    public List<Module> getOverridingModules() {
        return this.getEnabledModules().stream().filter(mod -> ((ModuleItemInfo)this.getInfo(mod)).isOverriding()).collect(Collectors.toList());
    }

    public List<Module> getDisabledModules() {
        return this.getDisabledItems(ConfigItem.Module);
    }

    public List<Class<Object>> getDisabledModuleTypes() {
        Collection disabledIds = this.disabledItemsHolder.get((Object)ConfigItem.Module);
        return ItemId.typesOnly(disabledIds);
    }

    public void registerInstallers(Class<? extends FeatureInstaller>[] installers) {
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.register(ConfigItem.Installer, installer);
        }
    }

    public void registerInstallersFromScan(List<Class<? extends FeatureInstaller>> installers) {
        this.openScope(ConfigScope.ClasspathScan.getKey());
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.register(ConfigItem.Installer, installer);
        }
        this.closeScope();
    }

    public void disableInstallers(Class<? extends FeatureInstaller>[] installers) {
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.registerDisable(ConfigItem.Installer, ItemId.from(installer));
        }
    }

    public List<Class<? extends FeatureInstaller>> getEnabledInstallers() {
        return this.getEnabledItems(ConfigItem.Installer);
    }

    public List<Class<? extends FeatureInstaller>> getDisabledInstallers() {
        return this.getDisabledItems(ConfigItem.Installer);
    }

    public void installersResolved(List<FeatureInstaller> installers) {
        this.extensionsHolder = new ExtensionsHolder(installers);
        this.lifecycle().installersResolved(new ArrayList<FeatureInstaller>(installers), this.getDisabledInstallers());
    }

    public ExtensionsHolder getExtensionsHolder() {
        return this.extensionsHolder;
    }

    public void registerExtensions(Class<?> ... extensions) {
        for (Class<?> extension : extensions) {
            this.register(ConfigItem.Extension, extension);
        }
    }

    public void registerExtensionsOptional(Class<?> ... extensions) {
        for (Class<?> extension : extensions) {
            ExtensionItemInfoImpl info = (ExtensionItemInfoImpl)this.register(ConfigItem.Extension, extension);
            info.setOptional(true);
        }
    }

    public ExtensionItemInfoImpl getOrRegisterExtension(Class<?> extension, boolean fromScan) {
        ExtensionItemInfoImpl info;
        if (fromScan) {
            this.openScope(ConfigScope.ClasspathScan.getKey());
            info = (ExtensionItemInfoImpl)this.register(ConfigItem.Extension, extension);
            this.closeScope();
        } else {
            info = (ExtensionItemInfoImpl)this.getInfo(extension);
        }
        return info;
    }

    public ExtensionItemInfoImpl getOrRegisterBindingExtension(Class<?> extension, Class<? extends Module> topScope) {
        this.openScope(ItemId.from(topScope));
        ExtensionItemInfoImpl info = (ExtensionItemInfoImpl)this.register(ConfigItem.Extension, extension);
        this.closeScope();
        return info;
    }

    public void disableExtensions(Class<?>[] extensions) {
        for (Class<?> extension : extensions) {
            this.registerDisable(ConfigItem.Extension, ItemId.from(extension));
        }
    }

    public boolean isExtensionEnabled(Class<?> extension) {
        return this.isEnabled(ConfigItem.Extension, ItemId.from(extension));
    }

    public List<Class<?>> getEnabledExtensions() {
        return this.getEnabledItems(ConfigItem.Extension);
    }

    public List<Class<?>> getDisabledExtensions() {
        return this.getDisabledItems(ConfigItem.Extension);
    }

    public <T extends Enum> void setOption(T option, Object value) {
        this.optionsSupport.set(option, value);
    }

    public <V, T extends Enum> V option(T option) {
        return (V)this.optionsSupport.get(option);
    }

    public OptionsSupport options() {
        return this.optionsSupport;
    }

    public void registerDisablePredicates(Predicate<ItemInfo>[] predicates) {
        List<PredicateHandler> list = Arrays.stream(predicates).map(p -> new PredicateHandler((Predicate<ItemInfo>)p, this.getScope())).collect(Collectors.toList());
        this.disablePredicates.addAll(list);
        this.applyPredicatesForRegisteredItems(list);
    }

    public void runHooks(GuiceBundle.Builder builder) {
        ConfigurationHooksSupport.logRegisteredAliases();
        ConfigurationHooksSupport.loadSystemHooks();
        this.openScope(ConfigScope.Hook.getKey());
        Set<GuiceyConfigurationHook> hooks = ConfigurationHooksSupport.run(builder);
        this.closeScope();
        this.lifecycle().configurationHooksProcessed(hooks);
    }

    public void initPhaseStarted(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.sharedState.put(Bootstrap.class, bootstrap);
        this.sharedState.assignTo(bootstrap.getApplication());
        Stopwatch time = this.stat().timer(Stat.BundleTime);
        Stopwatch dwtime = this.stat().timer(Stat.DropwizardBundleInitTime);
        for (ConfiguredBundle bundle : this.getEnabledDropwizardBundles()) {
            this.registerDropwizardBundle(bundle);
        }
        this.lifecycle().initializationStarted(bootstrap, this.getEnabledDropwizardBundles(), this.getDisabledDropwizardBundles(), this.getIgnoredItems(ConfigItem.DropwizardBundle));
        dwtime.stop();
        time.stop();
    }

    public void runPhaseStarted(Configuration configuration, Environment environment) {
        this.configuration = configuration;
        this.configurationTree = ConfigTreeBuilder.build(this.bootstrap, configuration, (Boolean)this.option(GuiceyOptions.BindConfigurationByPath));
        this.environment = environment;
        this.sharedState.put(Configuration.class, configuration);
        this.sharedState.put(ConfigurationTree.class, this.configurationTree);
        this.sharedState.put(Environment.class, environment);
        this.sharedState.listen(environment);
        this.lifecycle().runPhase(configuration, this.configurationTree, environment);
    }

    public void finalizeConfiguration() {
        for (ConfigItem type : this.disabledItemsHolder.keys()) {
            for (ItemId item : this.disabledItemsHolder.get((Object)type)) {
                Collection instances = this.instanceItemsIndex.get(item.getType());
                if (type.isInstanceConfig() && !instances.isEmpty()) {
                    for (Object instance : instances) {
                        DisableSupport info = (DisableSupport)this.getOrCreateInfo(type, instance);
                        info.getDisabledBy().addAll(this.disabledByHolder.get((Object)item));
                    }
                    continue;
                }
                DisableSupport info = (DisableSupport)((Object)this.detailsHolder.get(item));
                if (info == null) {
                    info = (DisableSupport)this.getOrCreateInfo(type, item.getType());
                }
                info.getDisabledBy().addAll(this.disabledByHolder.get((Object)item));
            }
        }
        ArrayList<ExtensionItemInfoImpl> exts = new ArrayList<ExtensionItemInfoImpl>();
        for (Class<?> ext : this.getEnabledExtensions()) {
            exts.add((ExtensionItemInfoImpl)this.getInfo(ext));
        }
        this.extensionsHolder.registerExtensions(exts);
    }

    public void bundleStarted() {
        this.lifecycle().applicationRun();
        this.sharedState.forgetStartupInstance();
    }

    public <T> List<T> getItems(ConfigItem type) {
        Collection res = this.itemsHolder.get((Object)type);
        return res.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)res);
    }

    public <T> List<T> getItems(ConfigItem type, Predicate<T> filter) {
        Collection items = this.itemsHolder.get((Object)type);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        return items.stream().filter(filter).collect(Collectors.toList());
    }

    public <T> List<T> getIgnoredItems(ConfigItem type) {
        Collection res = this.duplicatesHolder.get((Object)type);
        return res.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)res);
    }

    public <T extends ItemInfoImpl> T getInfo(Object item) {
        return (T)((ItemInfoImpl)this.detailsHolder.get(ItemId.from(item)));
    }

    public StatsTracker stat() {
        return this.tracker;
    }

    public LifecycleSupport lifecycle() {
        return this.lifecycleTracker;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationTree getConfigurationTree() {
        return this.configurationTree;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public SharedConfigurationState getSharedState() {
        return this.sharedState;
    }

    private ItemId getScope() {
        return this.currentScope == null ? ConfigScope.Application.getKey() : this.currentScope;
    }

    private void applyPredicatesForRegisteredItems(List<PredicateHandler> predicates) {
        ImmutableList.builder().addAll(this.getEnabledModules()).addAll(this.getEnabledBundles()).addAll(this.getEnabledExtensions()).addAll(this.getEnabledInstallers()).build().stream().map(this::getInfo).forEach(item -> this.applyDisablePredicates(predicates, (ItemInfo)item));
    }

    private void registerDisable(ConfigItem type, ItemId id) {
        if (type.isInstanceConfig() && id.getIdentity() == null && this.disabledByHolder.containsKey((Object)id)) {
            this.disabledItemsHolder.get((Object)type).removeIf(it -> it.getIdentity() != null && it.equals(id));
            Iterator iterator = this.disabledByHolder.entries().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemId key = (ItemId)entry.getKey();
                if (key.getIdentity() == null || !key.equals(id)) continue;
                iterator.remove();
            }
        }
        this.disabledItemsHolder.put((Object)type, (Object)id);
        this.disabledByHolder.put((Object)id, (Object)this.getScope());
    }

    private <T extends ItemInfoImpl> T register(ConfigItem type, Object srcItem) {
        Object item = this.detectDuplicate(type, srcItem);
        T info = this.getOrCreateInfo(type, item);
        if (type.isInstanceConfig() && ((ItemInfoImpl)info).getRegistrationAttempts() == 0) {
            ((InstanceItemInfoImpl)info).setInstanceCount(this.instanceItemsIndex.get(((ItemInfoImpl)info).getType()).size());
        }
        ((ItemInfoImpl)info).countRegistrationAttempt(this.getScope());
        this.fireRegistration((ItemInfo)info);
        return info;
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    private Object detectDuplicate(ConfigItem type, Object item) {
        Object original = null;
        if (type.isInstanceConfig()) {
            Class<?> clsFromOtherCL = this.detectClassFromDifferentClassLoader(item.getClass());
            Collection registeredInstances = this.instanceItemsIndex.get(clsFromOtherCL != null ? clsFromOtherCL : item.getClass());
            if (!registeredInstances.isEmpty()) {
                original = this.findDuplicateInstance(type, registeredInstances, item);
                if (clsFromOtherCL != null && original == null) {
                    this.logger.warn("Registered instances of class {} use different class loaders and may not be properly checked for duplicates: {}, {}", new Object[]{clsFromOtherCL.getName(), clsFromOtherCL.getClassLoader().toString(), item.getClass().getClassLoader().toString()});
                }
            }
            if (original == null) {
                this.instanceItemsIndex.put(item.getClass(), item);
            }
        } else {
            Class clsFromOtherCL = this.detectClassFromDifferentClassLoader((Class)item);
            if (clsFromOtherCL != null) {
                original = clsFromOtherCL;
            }
        }
        return MoreObjects.firstNonNull((Object)original, (Object)item);
    }

    private Class detectClassFromDifferentClassLoader(Class cls) {
        String clsName = cls.getName();
        Class<?> reg = this.usedClassesHolder.get(clsName);
        if (reg != null && !reg.equals(cls)) {
            return reg;
        }
        this.usedClassesHolder.put(clsName, cls);
        return null;
    }

    private Object findDuplicateInstance(ConfigItem type, Collection<Object> registeredInstances, Object item) {
        Object original = null;
        for (Object reg : registeredInstances) {
            if (reg != item && !reg.equals(item)) continue;
            original = reg;
            break;
        }
        if (original == null && this.duplicates != null && (original = this.duplicates.getDuplicateItem(new ArrayList<Object>(registeredInstances), item)) != null) {
            Preconditions.checkState((boolean)registeredInstances.contains(original), (Object)"Incorrect instance duplicates detection result: returned item must be already registered");
        }
        if (original != null && original != item) {
            ItemId originalId = ItemId.from(original);
            InstanceItemInfo originalInfo = (InstanceItemInfo)this.detailsHolder.get(originalId);
            originalInfo.getDuplicates().add(ItemId.from(item));
            this.logger.info("IGNORE {} {}/{} as duplicate for {}/{} (#{})", new Object[]{type, this.getScope().getType().getSimpleName(), ItemId.from(item), originalInfo.getRegistrationScope().getType().getSimpleName(), originalId, originalInfo.getInstanceCount()});
            this.duplicatesHolder.put((Object)type, item);
        }
        return original;
    }

    private void fireRegistration(ItemInfo item) {
        if (item instanceof DisableSupport && item.getRegistrationAttempts() == 1) {
            this.applyDisablePredicates(this.disablePredicates, item);
        }
    }

    private void applyDisablePredicates(List<PredicateHandler> predicates, ItemInfo item) {
        for (PredicateHandler predicate : predicates) {
            if (predicate.disable(item)) break;
        }
    }

    private <T extends ItemInfoImpl> T getOrCreateInfo(ConfigItem type, Object item) {
        ItemInfoImpl info;
        ItemId id = ItemId.from(item);
        if (this.detailsHolder.containsKey(id)) {
            info = (ItemInfoImpl)this.detailsHolder.get(id);
        } else {
            this.itemsHolder.put((Object)type, item);
            info = type.newContainer(item);
            this.detailsHolder.put(id, info);
        }
        return (T)info;
    }

    private <T> List<T> getDisabledItems(ConfigItem type) {
        Collection disabled = this.disabledItemsHolder.get((Object)type);
        return disabled.isEmpty() ? Collections.emptyList() : this.getItems(type, item -> disabled.contains(ItemId.from(item)));
    }

    private <T> List<T> getEnabledItems(ConfigItem type) {
        Collection disabled = this.disabledItemsHolder.get((Object)type);
        return disabled.isEmpty() ? this.getItems(type) : this.getItems(type, item -> !disabled.contains(ItemId.from(item)));
    }

    private boolean isEnabled(ConfigItem type, ItemId itemId) {
        return !this.disabledItemsHolder.get((Object)type).contains(itemId);
    }

    private void registerDropwizardBundle(ConfiguredBundle bundle) {
        this.bootstrap.addBundle((ConfiguredBundle)((Boolean)this.option(GuiceyOptions.TrackDropwizardBundles) != false ? new DropwizardBundleTracker(bundle, this) : bundle));
    }

    private class PredicateHandler {
        private final ItemId predicateScope;
        private final Predicate<ItemInfo> predicate;

        PredicateHandler(Predicate<ItemInfo> predicate, ItemId predicateScope) {
            this.predicate = predicate;
            this.predicateScope = predicateScope;
        }

        public boolean disable(ItemInfo item) {
            boolean test = this.predicate.test(item);
            if (test) {
                ItemId scope = ConfigurationContext.this.currentScope;
                ConfigurationContext.this.currentScope = this.predicateScope;
                ConfigurationContext.this.registerDisable(item.getItemType(), item.getId());
                ConfigurationContext.this.currentScope = scope;
            }
            return test;
        }
    }
}

