/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.plugin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.feature.plugin.PluginInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class PluginReporter
extends Reporter {
    private static final String NAMED_KEY = "Map<%s, %s>";
    private static final String NAMED_LINE = "    %-10s %s";
    private static final String KEY = "Set<%s>";
    private static final String LINE = "    %s";
    private final Multimap<String, String> namedPlugins = HashMultimap.create();
    private final Multimap<String, String> plugins = HashMultimap.create();

    public PluginReporter() {
        super(PluginInstaller.class, "plugins =");
    }

    public PluginReporter named(Class keyType, Class extType, Object key, Class extension) {
        this.namedPlugins.put((Object)String.format(NAMED_KEY, keyType.getSimpleName(), extType.getSimpleName()), (Object)String.format(NAMED_LINE, key, RenderUtils.renderClassLine(extension)));
        return this;
    }

    public PluginReporter simple(Class extType, Class extension) {
        this.plugins.put((Object)String.format(KEY, extType.getSimpleName()), (Object)String.format(LINE, RenderUtils.renderClassLine(extension)));
        return this;
    }

    @Override
    public void report() {
        this.printAll(this.plugins);
        if (!this.plugins.isEmpty() && !this.namedPlugins.isEmpty()) {
            this.emptyLine();
        }
        this.printAll(this.namedPlugins);
        super.report();
    }

    private void printAll(Multimap<String, String> map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.line(key, new Object[0]);
            for (String ext : map.get((Object)key)) {
                this.line(ext, new Object[0]);
            }
            if (!it.hasNext()) continue;
            this.emptyLine();
        }
    }
}

