/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.AdminContext;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.util.WebUtils;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=100)
public class WebFilterInstaller
implements FeatureInstaller,
InstanceInstaller<Filter>,
Ordered {
    private final Reporter reporter = new Reporter(WebFilterInstaller.class, "filters =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, Filter.class) && FeatureUtils.hasAnnotation(type, WebFilter.class);
    }

    @Override
    public void install(Environment environment, Filter instance) {
        Class<Filter> extType = FeatureUtils.getInstanceClass(instance);
        WebFilter annotation = FeatureUtils.getAnnotation(extType, WebFilter.class);
        Object[] servlets = annotation.servletNames();
        String[] patterns = annotation.urlPatterns().length > 0 ? annotation.urlPatterns() : annotation.value();
        Preconditions.checkArgument((servlets.length > 0 || patterns.length > 0 ? 1 : 0) != 0, (String)"Filter %s not specified servlet or pattern for mapping", (Object)extType.getName());
        Preconditions.checkArgument((servlets.length == 0 || patterns.length == 0 ? 1 : 0) != 0, (String)"Filter %s specifies both servlets and patters, when only one allowed", (Object)extType.getName());
        boolean servletMapping = servlets.length > 0;
        AdminContext context = FeatureUtils.getAnnotation(extType, AdminContext.class);
        String name = WebUtils.getFilterName(annotation, extType);
        this.reporter.line("%-25s %-8s %-4s %s   %s", Joiner.on((String)",").join(servletMapping ? servlets : patterns), WebUtils.getAsyncMarker(annotation), WebUtils.getContextMarkers(context), RenderUtils.renderClassLine(extType), name);
        if (WebUtils.isForMain(context)) {
            this.configure(environment.servlets(), instance, name, annotation);
        }
        if (WebUtils.isForAdmin(context)) {
            this.configure((ServletEnvironment)environment.admin(), instance, name, annotation);
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    private void configure(ServletEnvironment environment, Filter filter, String name, WebFilter annotation) {
        FilterRegistration.Dynamic mapping = environment.addFilter(name, filter);
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.copyOf(Arrays.asList(annotation.dispatcherTypes()));
        if (annotation.servletNames().length > 0) {
            mapping.addMappingForServletNames(dispatcherTypes, false, annotation.servletNames());
        } else {
            String[] urlPatterns = annotation.urlPatterns().length > 0 ? annotation.urlPatterns() : annotation.value();
            mapping.addMappingForUrlPatterns(dispatcherTypes, false, urlPatterns);
        }
        if (annotation.initParams().length > 0) {
            for (WebInitParam param : annotation.initParams()) {
                mapping.setInitParameter(param.name(), param.value());
            }
        }
        mapping.setAsyncSupported(annotation.asyncSupported());
    }

    @Override
    public List<String> getRecognizableSigns() {
        return Collections.singletonList("implements " + Filter.class.getSimpleName() + " + @" + WebFilter.class.getSimpleName());
    }
}

