/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Environment;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class TestCommand<C extends Configuration>
extends EnvironmentCommand<C> {
    private final Class<C> configurationClass;
    private ContainerLifeCycle container;

    public TestCommand(Application<C> application) {
        super(application, "guicey-test", "Specific command to run guice context without jetty server");
        this.cleanupAsynchronously();
        this.configurationClass = application.getConfigurationClass();
    }

    protected void run(Environment environment, Namespace namespace, C configuration) throws Exception {
        this.container = new ContainerLifeCycle();
        environment.lifecycle().attach(this.container);
        this.container.start();
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to stop managed objects container", e);
            }
            this.container.destroy();
        }
        this.cleanup();
    }

    protected Class<C> getConfigurationClass() {
        return this.configurationClass;
    }
}

