/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.injector.lookup;

import com.google.inject.Injector;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import java.util.Optional;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;

public final class InjectorLookup {
    private InjectorLookup() {
    }

    public static Optional<Injector> getInjector(Application application) {
        return SharedConfigurationState.lookup(application, Injector.class);
    }

    public static Optional<Injector> getInjector(Environment environment) {
        return SharedConfigurationState.lookup(environment, Injector.class);
    }

    public static <T> Optional<T> getInstance(Application application, Class<T> bean) {
        return InjectorLookup.getInjector(application).map(it -> it.getInstance(bean));
    }

    public static <T> Optional<T> getInstance(Environment environment, Class<T> bean) {
        return InjectorLookup.getInjector(environment).map(it -> it.getInstance(bean));
    }

    public static void registerInjector(Application application, Injector injector) {
        SharedConfigurationState.getOrFail(application, "No shared state assigned to application", new Object[0]).put(Injector.class, injector);
    }
}

