/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info.impl;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;

public class ItemInfoImpl
implements ItemInfo {
    private final ItemId id;
    private final ConfigItem itemType;
    private final Set<ItemId> registeredBy = Sets.newLinkedHashSet();
    private ItemId registrationScope;
    private int registrationAttempts;
    private final InstanceCounter counter = new InstanceCounter();

    public ItemInfoImpl(ConfigItem itemType, ItemId id) {
        this.itemType = itemType;
        this.id = id;
    }

    @Override
    public ItemId getId() {
        return this.id;
    }

    @Override
    public ConfigItem getItemType() {
        return this.itemType;
    }

    @Override
    public Class<?> getType() {
        return this.id.getType();
    }

    @Override
    public Set<ItemId> getRegisteredBy() {
        return this.registeredBy;
    }

    @Override
    public int getRegistrationAttempts() {
        return this.registrationAttempts;
    }

    @Override
    public boolean isRegistered() {
        return !this.registeredBy.isEmpty();
    }

    @Override
    public boolean isRegisteredDirectly() {
        return this.getRegisteredBy().contains(ConfigScope.Application.getKey());
    }

    @Override
    public ItemId getRegistrationScope() {
        return this.registrationScope;
    }

    @Override
    public ConfigScope getRegistrationScopeType() {
        return ConfigScope.recognize(this.getRegistrationScope());
    }

    @Override
    public int getIgnoresByScope(ItemId scope) {
        int res = this.counter.getCount(scope);
        if (scope.getIdentity() == null && res == 0) {
            for (ItemId reg : this.counter.getScopes()) {
                if (!reg.getType().equals(scope.getType())) continue;
                res += this.counter.getCount(reg);
                if (!reg.equals(this.registrationScope)) continue;
                --res;
            }
        } else if (scope.equals(this.registrationScope)) {
            --res;
        }
        return Math.max(res, 0);
    }

    @Override
    public int getIgnoresByScope(Class<?> scope) {
        return this.getIgnoresByScope(ItemId.from(scope));
    }

    public void countRegistrationAttempt(ItemId scope) {
        ++this.registrationAttempts;
        if (this.registrationScope == null) {
            this.registrationScope = scope;
        }
        this.registeredBy.add(scope);
        this.counter.count(scope);
    }

    public String toString() {
        return this.itemType.name() + " " + this.id;
    }

    private static class InstanceCounter {
        private final Map<ItemId, Integer> counts = new HashMap<ItemId, Integer>();

        private InstanceCounter() {
        }

        public int count(ItemId type) {
            int value = this.getCount(type) + 1;
            this.counts.put(type, value);
            return value;
        }

        public int getCount(ItemId type) {
            int res = 0;
            if (type.getIdentity() != null) {
                Integer count = this.counts.get(type);
                if (count != null) {
                    res = count;
                }
            } else {
                for (ItemId id : this.getScopes()) {
                    if (id.getIdentity() != null || !id.equals(type)) continue;
                    res = this.counts.get(id);
                }
            }
            return res;
        }

        public Set<ItemId> getScopes() {
            return this.counts.keySet();
        }
    }
}

