/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web.listener;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.EventListener;
import java.util.Map;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.listener.WebListenerInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class ListenerReporter
extends Reporter {
    private static final Map<Class<? extends EventListener>, String> DESCRIPTORS = ImmutableMap.builder().put(ServletContextListener.class, (Object)"Context").put(ServletContextAttributeListener.class, (Object)"Context attribute").put(ServletRequestListener.class, (Object)"Request").put(ServletRequestAttributeListener.class, (Object)"Request attribute").put(HttpSessionListener.class, (Object)"Session").put(HttpSessionAttributeListener.class, (Object)"Session attribute").put(HttpSessionIdListener.class, (Object)"Session id").build();
    private final Multimap<String, String> prerender = HashMultimap.create();

    public ListenerReporter() {
        super(WebListenerInstaller.class, "web listeners = ");
    }

    public void listener(Class<? extends EventListener> type, String contextMarkers) {
        String line = String.format("    %-2s  %s", contextMarkers, RenderUtils.renderClassLine(type));
        for (Map.Entry<Class<? extends EventListener>, String> entry : DESCRIPTORS.entrySet()) {
            Class<? extends EventListener> ext = entry.getKey();
            if (!ext.isAssignableFrom(type)) continue;
            this.prerender.put((Object)entry.getValue(), (Object)line);
        }
    }

    @Override
    public void report() {
        for (String group : this.prerender.keySet()) {
            this.separate();
            this.line(group, new Object[0]);
            this.prerender.get((Object)group).forEach(x$0 -> this.line((String)x$0, new Object[0]));
        }
        super.report();
    }
}

