/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import io.dropwizard.testing.DropwizardTestSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.env.EnableSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestParametersSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.ReusableAppUtils;
import ru.vyarus.dropwizard.guice.test.util.StoredReusableApp;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public abstract class GuiceyExtensionsSupport
extends TestParametersSupport
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceyExtensionsSupport.class);
    private static final String DW_SUPPORT = "DW_SUPPORT";
    private static final String DW_SUPPORT_GLOBAL = "DW_SUPPORT_GLOBAL";
    private static final String DW_CLIENT = "DW_CLIENT";
    private static final String INHERITED_DW_SUPPORT = "INHERITED_DW_SUPPORT";
    private static final String PER_METHOD_DW_SUPPORT = "PER_METHOD_DW_SUPPORT";
    private static final Object SYNC = new Object();
    protected final TestExtensionsTracker tracker;

    public GuiceyExtensionsSupport(TestExtensionsTracker tracker) {
        this.tracker = tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        Object object = SYNC;
        synchronized (object) {
            this.checkReusableApp(context);
        }
        if (!GuiceyExtensionsSupport.lookupSupport(context).isPresent()) {
            this.start(context, null);
        } else {
            ExtensionContext.Store localStore = this.getLocalExtensionStore(context);
            Preconditions.checkState((localStore.get((Object)INHERITED_DW_SUPPORT) == null ? 1 : 0) != 0, (Object)"Storage assumptions were wrong or unexpected junit usage appear. Please report this case to guicey developer.");
            localStore.put((Object)INHERITED_DW_SUPPORT, (Object)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!GuiceyExtensionsSupport.lookupSupport(context).isPresent()) {
            this.start(context, context.getTestInstance().get());
            this.getLocalExtensionStore(context).put((Object)PER_METHOD_DW_SUPPORT, (Object)true);
        }
        Object testInstance = context.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        DropwizardTestSupport support = (DropwizardTestSupport)Preconditions.checkNotNull(this.getSupport(context), (Object)"Guicey test support was not initialized: most likely, you are trying to manually register extension using non-static field - such usage is not supported.");
        InjectorLookup.getInjector(support.getApplication()).orElseThrow(() -> new IllegalStateException("Can't find guicey injector to process test fields injections")).injectMembers(testInstance);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.getLocalExtensionStore(context).get((Object)PER_METHOD_DW_SUPPORT) != null) {
            this.stop(context);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (GuiceyExtensionsSupport.lookupSupport(context).isPresent()) {
            Object nestedTestMarker = this.getLocalExtensionStore(context).remove((Object)INHERITED_DW_SUPPORT);
            if (nestedTestMarker != null) {
                return;
            }
            this.stop(context);
        }
    }

    public static Optional<DropwizardTestSupport<?>> lookupSupport(ExtensionContext extensionContext) {
        return Optional.ofNullable((DropwizardTestSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT));
    }

    public static Optional<Injector> lookupInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).flatMap(it -> InjectorLookup.getInjector(it.getApplication()));
    }

    public static Optional<ClientSupport> lookupClient(ExtensionContext extensionContext) {
        return Optional.ofNullable((ClientSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_CLIENT));
    }

    public static boolean isReusableAppUsed(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT_GLOBAL) != null;
    }

    public static boolean closeReusableApp(ExtensionContext extensionContext) {
        Class baseClass = (Class)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT_GLOBAL);
        return baseClass != null && ReusableAppUtils.closeGlobalApp(extensionContext, baseClass);
    }

    protected abstract ExtensionConfig getConfig(ExtensionContext var1);

    protected abstract DropwizardTestSupport<?> prepareTestSupport(String var1, ExtensionContext var2, List<TestEnvironmentSetup> var3);

    @Override
    protected DropwizardTestSupport<?> getSupport(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).orElse(null);
    }

    @Override
    protected ClientSupport getClient(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupClient(extensionContext).orElse(null);
    }

    @Override
    protected Optional<Injector> getInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupInjector(extensionContext);
    }

    protected static ExtensionContext.Store getExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class}));
    }

    private ExtensionContext.Store getLocalExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class, context.getRequiredTestClass()}));
    }

    private void checkReusableApp(ExtensionContext context) throws Exception {
        ExtensionConfig config = this.getConfig(context);
        if (config.reuseApp) {
            String source = config.reuseSource;
            StoredReusableApp globalApp = ReusableAppUtils.getGlobalApp(context, config.reuseDeclarationClass);
            ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
            if (globalApp != null) {
                Preconditions.checkState((boolean)globalApp.getSource().equals(config.reuseSource), (String)"Can't apply reusable app instance from %s in test %s because different reusable app (%s)is already registered", (Object)source, (Object)context.getRequiredTestClass().getSimpleName(), (Object)globalApp.getSource());
                new FieldSupport(context.getRequiredTestClass(), null, null).hintIgnoredFields(config.reuseDeclarationClass);
                if (store.get((Object)DW_SUPPORT) == null) {
                    store.put((Object)DW_SUPPORT, globalApp.getSupport());
                    store.put((Object)DW_CLIENT, (Object)globalApp.getClient());
                } else {
                    Preconditions.checkState((boolean)store.get((Object)DW_SUPPORT).equals(globalApp.getSupport()), (String)"Can't apply reusable app instance from %s in test %s context because it already contains started app", (Object)source, (Object)context.getRequiredTestClass().getSimpleName());
                }
            } else {
                this.start(context, null);
                ReusableAppUtils.registerGlobalApp(context, new StoredReusableApp(config.reuseDeclarationClass, source, GuiceyExtensionsSupport.lookupSupport(context).get(), GuiceyExtensionsSupport.lookupClient(context).get()));
            }
            if (store.get((Object)DW_SUPPORT_GLOBAL) == null) {
                store.put((Object)DW_SUPPORT_GLOBAL, config.reuseDeclarationClass);
            }
        }
    }

    private void start(ExtensionContext context, Object testInstance) throws Exception {
        ExtensionConfig config = this.getConfig(context);
        ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
        FieldSupport fields = new FieldSupport(context.getRequiredTestClass(), testInstance, this.tracker);
        if (config.reuseApp) {
            fields.hintIncorrectFieldsUsage(config.reuseDeclarationClass);
        }
        fields.activateBaseHooks();
        String configPrefix = ConfigOverrideUtils.createPrefix(context);
        DropwizardTestSupport<?> support = this.prepareTestSupport(configPrefix, context, fields.getSetupObjects());
        fields.activateClassHooks();
        store.put((Object)DW_SUPPORT, support);
        store.put((Object)DW_CLIENT, (Object)new ClientSupport(support));
        this.tracker.enableDebugFromSystemProperty();
        this.tracker.logUsedHooksAndSetupObjects(configPrefix);
        support.before();
        this.tracker.logOverriddenConfigs(configPrefix);
    }

    private void stop(ExtensionContext context) throws Exception {
        ClientSupport client;
        ConfigurationHooksSupport.reset();
        DropwizardTestSupport<?> support = this.getSupport(context);
        if (support != null) {
            support.after();
        }
        if ((client = this.getClient(context)) != null) {
            client.close();
        }
    }

    private static class FieldSupport {
        private final Class<?> testClass;
        private final Object instance;
        private final TestExtensionsTracker tracker;
        private final List<Field> parentHookFields;
        private final List<Field> ownHookFields;
        private final List<Field> extensionFields;

        FieldSupport(Class<?> testClass, Object instance, TestExtensionsTracker tracker) {
            this.testClass = testClass;
            this.instance = instance;
            this.tracker = tracker;
            boolean includeInstanceFields = instance != null;
            this.ownHookFields = this.findHookFields(testClass, includeInstanceFields);
            this.parentHookFields = this.ownHookFields.isEmpty() ? Collections.emptyList() : this.ownHookFields.stream().filter(field -> !testClass.equals(field.getDeclaringClass())).collect(Collectors.toList());
            this.ownHookFields.removeAll(this.parentHookFields);
            this.extensionFields = this.findSetupFields(testClass, includeInstanceFields);
        }

        public void hintIncorrectFieldsUsage(Class<?> declarationClass) {
            List<String> wrong = this.findNonBaseFields(declarationClass);
            if (!wrong.isEmpty()) {
                LOGGER.warn("The following extensions were used during reusable app startup in test {}, but they did not belong to base class {} hierarchy where reusable app is declared and so would be ignored if reusable app would start by different test: \n{}", new Object[]{this.testClass.getName(), declarationClass.getName(), Joiner.on((String)"\n").join(wrong)});
            }
        }

        public void hintIgnoredFields(Class<?> declarationClass) {
            List<String> wrong = this.findNonBaseFields(declarationClass);
            if (!wrong.isEmpty()) {
                LOGGER.warn("The following extensions were ignored in test {} because reusable application was already started by another test: \n{}", (Object)this.testClass.getName(), (Object)Joiner.on((String)"\n").join(wrong));
            }
        }

        public List<TestEnvironmentSetup> getSetupObjects() {
            this.tracker.extensionsFromFields(this.extensionFields, this.instance);
            return this.extensionFields.isEmpty() ? Collections.emptyList() : this.getFieldValues(this.extensionFields);
        }

        public void activateBaseHooks() {
            this.activateFieldHooks(this.parentHookFields);
            this.tracker.hooksFromFields(this.parentHookFields, true, this.instance);
        }

        public void activateClassHooks() {
            this.activateFieldHooks(this.ownHookFields);
            this.tracker.hooksFromFields(this.ownHookFields, false, this.instance);
        }

        private List<String> findNonBaseFields(Class<?> declarationClass) {
            ArrayList<String> wrong = new ArrayList<String>();
            this.checkFieldsDeclaration(wrong, this.parentHookFields, declarationClass);
            this.checkFieldsDeclaration(wrong, this.ownHookFields, declarationClass);
            this.checkFieldsDeclaration(wrong, this.extensionFields, declarationClass);
            return wrong;
        }

        private void checkFieldsDeclaration(List<String> wrong, List<Field> fields, Class<?> baseClass) {
            for (Field field : fields) {
                if (field.getDeclaringClass().isAssignableFrom(baseClass)) continue;
                wrong.add("\t" + field.getDeclaringClass().getName() + "." + field.getName() + " (" + field.getType().getSimpleName() + ")");
            }
        }

        private void activateFieldHooks(List<Field> fields) {
            HooksUtil.register(this.getFieldValues(fields));
        }

        private <T> List<T> getFieldValues(List<Field> fields) {
            return fields.isEmpty() ? Collections.emptyList() : ReflectionUtils.readFieldValues(fields, (Object)this.instance);
        }

        private List<Field> findHookFields(Class<?> testClass, boolean includeInstanceFields) {
            ArrayList<Field> fields = AnnotationSupport.findAnnotatedFields(testClass, EnableHook.class);
            if (includeInstanceFields) {
                fields = new ArrayList<Field>(fields);
                fields.sort(Comparator.comparing(field -> Modifier.isStatic(field.getModifiers()) ? 0 : 1));
            }
            HooksUtil.validateFieldHooks((List<Field>)fields, includeInstanceFields);
            return fields.isEmpty() ? Collections.emptyList() : new ArrayList(fields);
        }

        private List<Field> findSetupFields(Class<?> testClass, boolean includeInstanceFields) {
            List fields = AnnotationSupport.findAnnotatedFields(testClass, EnableSetup.class);
            TestSetupUtils.validateFields(fields, includeInstanceFields);
            return fields.isEmpty() ? Collections.emptyList() : new ArrayList(fields);
        }
    }
}

