/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.servlet.DispatcherType;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.bundle.DefaultBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.VoidBundleLookup;
import ru.vyarus.dropwizard.guice.debug.ConfigurationDiagnostic;
import ru.vyarus.dropwizard.guice.debug.ExtensionsHelpDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceAopDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.JerseyConfigDiagnostic;
import ru.vyarus.dropwizard.guice.debug.LifecycleDiagnostic;
import ru.vyarus.dropwizard.guice.debug.WebMappingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.YamlBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.hook.DiagnosticHook;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceConfig;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.report.web.MappingsConfig;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.injector.DefaultInjectorFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.module.GuiceyInitializer;
import ru.vyarus.dropwizard.guice.module.GuiceyRunner;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.unique.DuplicateConfigDetector;
import ru.vyarus.dropwizard.guice.module.context.unique.UniqueItemsDuplicatesDetector;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.jersey.debug.HK2DebugBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;

public final class GuiceBundle
implements ConfiguredBundle<Configuration> {
    private final ConfigurationContext context = new ConfigurationContext();
    private InjectorFactory injectorFactory = new DefaultInjectorFactory();
    private GuiceyBundleLookup bundleLookup = new DefaultBundleLookup();

    GuiceBundle() {
    }

    public void initialize(Bootstrap bootstrap) {
        GuiceyInitializer starter = new GuiceyInitializer(bootstrap, this.context);
        starter.initializeBundles(this.bundleLookup);
        starter.findCommands();
        starter.resolveInstallers();
        starter.resolveExtensions();
        starter.initFinished();
    }

    public void run(Configuration configuration, Environment environment) throws Exception {
        GuiceyRunner runner = new GuiceyRunner(this.context, configuration, environment);
        runner.runBundles();
        runner.prepareModules();
        runner.createInjector(this.injectorFactory, runner.analyzeAndRepackageBindings());
        runner.installExtensions();
        runner.injectCommands();
        runner.runFinished();
    }

    public Injector getInjector() {
        return (Injector)this.context.getSharedState().getOrFail(Injector.class, "Guice not initialized", new Object[0]);
    }

    public static Builder builder() {
        return new Builder().hookAlias("diagnostic", DiagnosticHook.class);
    }

    public static class Builder {
        private final GuiceBundle bundle = new GuiceBundle();

        public Builder listen(GuiceyLifecycleListener ... listeners) {
            this.bundle.context.lifecycle().register(listeners);
            return this;
        }

        public <K extends Enum> Builder option(K option, Object value) {
            this.bundle.context.setOption(option, value);
            return this;
        }

        public <K extends Enum> Builder options(Map<Enum, Object> options) {
            options.forEach((x$0, x$1) -> this.option((Enum)x$0, x$1));
            return this;
        }

        public Builder injectorFactory(InjectorFactory injectorFactory) {
            this.bundle.injectorFactory = injectorFactory;
            return this;
        }

        public Builder bundleLookup(GuiceyBundleLookup bundleLookup) {
            this.bundle.bundleLookup = bundleLookup;
            return this;
        }

        public Builder disableBundleLookup() {
            return this.bundleLookup(new VoidBundleLookup());
        }

        public Builder enableAutoConfig(String ... basePackages) {
            Preconditions.checkState((basePackages.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one package to scan");
            return this.option(GuiceyOptions.ScanPackages, basePackages);
        }

        public Builder enableAutoConfig() {
            return this.enableAutoConfig("<app>");
        }

        public Builder duplicateConfigDetector(DuplicateConfigDetector detector) {
            this.bundle.context.setDuplicatesDetector(detector);
            return this;
        }

        public Builder uniqueItems(Class<?> ... configurationItems) {
            return this.duplicateConfigDetector(new UniqueItemsDuplicatesDetector(configurationItems));
        }

        public Builder modules(Module ... modules) {
            Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
            this.bundle.context.registerModules(modules);
            return this;
        }

        public Builder modulesOverride(Module ... modules) {
            this.bundle.context.registerModulesOverride(modules);
            return this;
        }

        public Builder searchCommands() {
            return this.option(GuiceyOptions.SearchCommands, true);
        }

        public Builder noDefaultInstallers() {
            return this.option(GuiceyOptions.UseCoreInstallers, false);
        }

        @Deprecated
        public Builder noGuiceFilter() {
            return this.option(GuiceyOptions.GuiceFilterRegistration, EnumSet.noneOf(DispatcherType.class));
        }

        @SafeVarargs
        public final Builder installers(Class<? extends FeatureInstaller> ... installers) {
            this.bundle.context.registerInstallers(installers);
            return this;
        }

        public Builder extensions(Class<?> ... extensionClasses) {
            this.bundle.context.registerExtensions(extensionClasses);
            return this;
        }

        public Builder extensionsOptional(Class<?> ... extensionClasses) {
            this.bundle.context.registerExtensionsOptional(extensionClasses);
            return this;
        }

        public Builder bundles(GuiceyBundle ... bundles) {
            this.bundle.context.registerBundles(bundles);
            return this;
        }

        public Builder dropwizardBundles(ConfiguredBundle ... bundles) {
            this.bundle.context.registerDropwizardBundles(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disableInstallers(Class<? extends FeatureInstaller> ... installers) {
            this.bundle.context.disableInstallers(installers);
            return this;
        }

        public final Builder disableExtensions(Class<?> ... extensions) {
            this.bundle.context.disableExtensions(extensions);
            return this;
        }

        @SafeVarargs
        public final Builder disableModules(Class<? extends Module> ... modules) {
            this.bundle.context.disableModules(modules);
            return this;
        }

        @SafeVarargs
        public final Builder disableBundles(Class<? extends GuiceyBundle> ... bundles) {
            this.bundle.context.disableBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disableDropwizardBundles(Class<? extends ConfiguredBundle> ... bundles) {
            this.bundle.context.disableDropwizardBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disable(Predicate<ItemInfo> ... predicates) {
            this.bundle.context.registerDisablePredicates(predicates);
            return this;
        }

        @Deprecated
        public Builder strictScopeControl() {
            this.bundle.context.registerBundles(new HK2DebugBundle());
            return this;
        }

        @Deprecated
        public Builder useHK2ForJerseyExtensions() {
            this.option(InstallersOptions.JerseyExtensionsManagedByGuice, false);
            this.option(GuiceyOptions.UseHkBridge, true);
            return this;
        }

        public Builder printDiagnosticInfo() {
            return this.listen(new ConfigurationDiagnostic());
        }

        public Builder printExtensionsHelp() {
            return this.listen(new ExtensionsHelpDiagnostic());
        }

        public Builder printAvailableInstallers() {
            return this.listen(ConfigurationDiagnostic.builder("Available installers report").printConfiguration(new DiagnosticConfig().printInstallers().printNotUsedInstallers().printInstallerInterfaceMarkers()).printContextTree(new ContextTreeConfig().hideCommands().hideDuplicateRegistrations().hideEmptyBundles().hideExtensions().hideModules()).build());
        }

        public Builder printConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic());
        }

        public Builder printCustomConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic(new BindingsConfig().showConfigurationTree().showNullValues().showCustomConfigOnly()));
        }

        public Builder printGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig().hideGuiceBindings().hideGuiceyBindings()));
        }

        public Builder printAllGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig()));
        }

        public Builder printGuiceAopMap() {
            return this.printGuiceAopMap(new GuiceAopConfig());
        }

        public Builder printGuiceAopMap(GuiceAopConfig config) {
            return this.listen(new GuiceAopDiagnostic(config));
        }

        public Builder printLifecyclePhases() {
            return this.listen(new LifecycleDiagnostic(false));
        }

        public Builder printLifecyclePhasesDetailed() {
            return this.listen(new LifecycleDiagnostic(true));
        }

        public Builder printWebMappings() {
            return this.listen(new WebMappingsDiagnostic(new MappingsConfig().showMainContext().showAdminContext().showDropwizardMappings().showGuiceMappings()));
        }

        public Builder printJerseyConfig() {
            return this.listen(new JerseyConfigDiagnostic());
        }

        public Builder hookAlias(String name, Class<? extends GuiceyConfigurationHook> hook) {
            ConfigurationHooksSupport.registerSystemHookAlias(name, hook);
            return this;
        }

        public Builder withSharedState(Consumer<SharedConfigurationState> stateAction) {
            stateAction.accept(this.bundle.context.getSharedState());
            return this;
        }

        public GuiceBundle build(Stage stage) {
            this.option(GuiceyOptions.InjectorStage, stage);
            return this.build();
        }

        public GuiceBundle build() {
            this.bundle.context.runHooks(this);
            return this.bundle;
        }
    }
}

